/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.World;

public class PeripheralRefinery
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getInputFluidTanks", "getOutputTank", "getRecipe", "setEnabled", "isValidRecipe", "getEmptyCannisters", "getFullCannisters", "getMaxEnergyStored", "getEnergyStored"};

    public PeripheralRefinery(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:refinery";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityRefinery te = (TileEntityRefinery)this.getTileEntity(TileEntityRefinery.class);
        if (te == null) {
            throw new LuaException("The refinery was removed");
        }
        switch (method) {
            case 0: {
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(2);
                ret.put("input1", Utils.saveFluidTank(te.tank0));
                ret.put("input2", Utils.saveFluidTank(te.tank1));
                return new Object[]{ret};
            }
            case 1: {
                return new Object[]{Utils.saveFluidTank(te.tank2)};
            }
            case 2: {
                DieselHandler.RefineryRecipe ref = te.getRecipe(false);
                if (ref == null) {
                    throw new LuaException("The recipe of the refinery is invalid");
                }
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(3);
                ret.put("input1", Utils.saveFluidStack(ref.input0));
                ret.put("input2", Utils.saveFluidStack(ref.input1));
                ret.put("output", Utils.saveFluidStack(ref.output));
                return new Object[]{ret};
            }
            case 3: {
                boolean param;
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = param = ((Boolean)arguments[0]).booleanValue();
                return null;
            }
            case 4: {
                return new Object[]{te.getRecipe(false) != null};
            }
            case 5: {
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(3);
                ret.put("input1", Utils.saveStack(te.inventory[1]));
                ret.put("input2", Utils.saveStack(te.inventory[3]));
                ret.put("output", Utils.saveStack(te.inventory[4]));
                return new Object[]{ret};
            }
            case 6: {
                HashMap<String, Map<String, Object>> ret = new HashMap<String, Map<String, Object>>(3);
                ret.put("input1", Utils.saveStack(te.inventory[0]));
                ret.put("input2", Utils.saveStack(te.inventory[2]));
                ret.put("output", Utils.saveStack(te.inventory[5]));
                return new Object[]{ret};
            }
            case 7: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 8: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityRefinery te = (TileEntityRefinery)this.w.getTileEntity(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        te.computerControlled = true;
        te.computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntityRefinery te = (TileEntityRefinery)this.w.getTileEntity(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        te.computerControlled = false;
    }
}

