/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFloodlight;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import net.minecraft.world.World;

public class PeripheralFloodlight
extends IEPeripheral {
    public PeripheralFloodlight(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:floodlight";
    }

    public String[] getMethodNames() {
        return new String[]{"turnAroundXZ", "turnAroundY", "canTurn", "waitForTimeout", "setEnabled", "isActive", "getEnergyStored", "getMaxEnergyStored"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityFloodlight te = (TileEntityFloodlight)this.getTileEntity(TileEntityFloodlight.class);
        if (te == null) {
            throw new LuaException("The floodlight was removed");
        }
        switch (method) {
            case 0: {
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                if (!te.canComputerTurn()) {
                    throw new LuaException("The floodlight can not turn again yet");
                }
                boolean param = (Boolean)arguments[0];
                te.turnX(param, true);
                return null;
            }
            case 1: {
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                if (!te.canComputerTurn()) {
                    throw new LuaException("The floodlight can not turn again yet");
                }
                boolean param = (Boolean)arguments[0];
                te.turnY(param, true);
                return null;
            }
            case 2: {
                return new Object[]{te.canComputerTurn()};
            }
            case 3: {
                TileEntityFloodlight tileEntityFloodlight = te;
                synchronized (tileEntityFloodlight) {
                    while (!te.canComputerTurn()) {
                        te.wait();
                    }
                }
                return null;
            }
            case 4: {
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = (Boolean)arguments[0];
                return null;
            }
            case 5: {
                return new Object[]{te.active};
            }
            case 6: {
                return new Object[]{te.energyStorage};
            }
            case 7: {
                return new Object[]{80};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityFloodlight te = (TileEntityFloodlight)this.w.getTileEntity(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        te.computerControlled = true;
        te.computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntityFloodlight te = (TileEntityFloodlight)this.w.getTileEntity(this.x, this.y, this.z);
        if (te == null) {
            return;
        }
        te.computerControlled = false;
    }
}

