/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PeripheralBottlingMachine
extends IEPeripheral {
    public static final String[] cmds = new String[]{"getFluid", "getEmptyCannister", "getEmptyCannisterCount", "getFilledCannister", "getFilledCannisterCount", "getEnergyStored", "getMaxEnergyStored", "setEnabled"};

    public PeripheralBottlingMachine(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:bottlingMachine";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityBottlingMachine te = (TileEntityBottlingMachine)this.getTileEntity(TileEntityBottlingMachine.class);
        if (te == null) {
            throw new LuaException("The bottling machine was removed");
        }
        switch (method) {
            case 0: {
                return new Object[]{Utils.saveFluidTank(te.tank)};
            }
            case 1: {
                int id;
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int param = (int)((Double)arguments[0]).doubleValue();
                if (param < 1 || param > 5) {
                    throw new LuaException("Only 1-5 are valid cannister positions");
                }
                try {
                    id = te.getEmptyCannister(param - 1);
                }
                catch (IllegalArgumentException e) {
                    throw new LuaException(e.getMessage());
                }
                Map<String, Object> map = Utils.saveStack(te.inventory[id]);
                map.put("process", te.process[id]);
                return new Object[]{map};
            }
            case 2: {
                return new Object[]{te.getEmptyCount()};
            }
            case 3: {
                int id;
                if (arguments.length != 1 || !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int param = (int)((Double)arguments[0]).doubleValue();
                if (param < 1 || param > 5) {
                    throw new LuaException("Only 1-5 are valid cannister positions");
                }
                try {
                    id = te.getFilledCannister(param - 1);
                }
                catch (IllegalArgumentException e) {
                    throw new LuaException(e.getMessage());
                }
                Map<String, Object> map = Utils.saveStack(te.inventory[id]);
                map.put("process", te.process[id]);
                return new Object[]{map};
            }
            case 4: {
                return new Object[]{te.getFilledCount()};
            }
            case 5: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
            case 6: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 7: {
                boolean active;
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = active = ((Boolean)arguments[0]).booleanValue();
                return null;
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntity te = this.w.getTileEntity(this.x, this.y, this.z);
        if (!(te instanceof TileEntityBottlingMachine)) {
            return;
        }
        ((TileEntityBottlingMachine)te).computerControlled = true;
        ((TileEntityBottlingMachine)te).computerOn = true;
    }

    public void detach(IComputerAccess computer) {
        TileEntity te = this.w.getTileEntity(this.x, this.y, this.z);
        if (!(te instanceof TileEntityBottlingMachine)) {
            return;
        }
        ((TileEntityBottlingMachine)te).computerControlled = false;
    }
}

