/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computercraft;

import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.items.ItemGraphiteElectrode;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.computercraft.IEPeripheral;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PeripheralArcFurnace
extends IEPeripheral {
    public static final String[] cmds = new String[]{"setEnabled", "isActive", "getInputStack", "getOutputStack", "getAdditiveStack", "getSlagStack", "hasElectrodes", "getElectrode", "getMaxEnergyStored", "getEnergyStored"};

    public PeripheralArcFurnace(World w, int _x, int _y, int _z) {
        super(w, _x, _y, _z);
    }

    public String getType() {
        return "IE:arcFurnace";
    }

    public String[] getMethodNames() {
        return cmds;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        TileEntityArcFurnace te = (TileEntityArcFurnace)this.getTileEntity(TileEntityArcFurnace.class);
        if (te == null) {
            throw new LuaException("The arc furnace was removed");
        }
        switch (method) {
            case 0: {
                boolean param;
                if (arguments.length != 1 || !(arguments[0] instanceof Boolean)) {
                    throw new LuaException("Wrong amount of arguments, needs one boolean");
                }
                te.computerOn = param = ((Boolean)arguments[0]).booleanValue();
                return null;
            }
            case 1: {
                return new Object[]{te.active};
            }
            case 2: {
                if (arguments.length != 1 || !(arguments[0] instanceof Integer) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 12) {
                    throw new LuaException("Input slots are 1-12");
                }
                Map<String, Object> ret = Utils.saveStack(te.getStackInSlot(slot - 1));
                ret.put("progress", te.process[slot - 1]);
                ret.put("maxProgress", te.processMax[slot - 1]);
                return new Object[]{ret};
            }
            case 3: {
                if (arguments.length != 1 || !(arguments[0] instanceof Integer) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 6) {
                    throw new LuaException("Output slots are 1-6");
                }
                return new Object[]{Utils.saveStack(te.getStackInSlot(slot + 15))};
            }
            case 4: {
                if (arguments.length != 1 || !(arguments[0] instanceof Integer) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 4) {
                    throw new LuaException("Additive slots are 1-4");
                }
                return new Object[]{Utils.saveStack(te.getStackInSlot(slot + 11))};
            }
            case 5: {
                return new Object[]{Utils.saveStack(te.getStackInSlot(22))};
            }
            case 6: {
                return new Object[]{te.electrodes[0] && te.electrodes[1] && te.electrodes[2]};
            }
            case 7: {
                if (arguments.length != 1 || !(arguments[0] instanceof Integer) && !(arguments[0] instanceof Double)) {
                    throw new LuaException("Wrong amount of arguments, needs one integer");
                }
                int slot = (int)((Double)arguments[0]).doubleValue();
                if (slot < 1 || slot > 3) {
                    throw new LuaException("Electrode slots are 1-3");
                }
                ItemStack stack = te.getStackInSlot(slot + 22);
                Map<String, Object> map = Utils.saveStack(stack);
                if (stack != null && stack.getItem() instanceof ItemGraphiteElectrode) {
                    map.put("damage", ItemNBTHelper.getInt(stack, "graphDmg"));
                }
                return new Object[]{map};
            }
            case 8: {
                return new Object[]{te.energyStorage.getMaxEnergyStored()};
            }
            case 9: {
                return new Object[]{te.energyStorage.getEnergyStored()};
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
        TileEntityArcFurnace te = (TileEntityArcFurnace)this.w.getTileEntity(this.x, this.y, this.z);
        if (te != null) {
            te.computerControlled = true;
            te.computerOn = true;
        }
    }

    public void detach(IComputerAccess computer) {
        TileEntityArcFurnace te = (TileEntityArcFurnace)this.w.getTileEntity(this.x, this.y, this.z);
        if (te != null) {
            te.computerControlled = false;
        }
    }
}

