/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IERecipes;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IEPotions;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import blusunrize.immersiveengineering.common.util.compat.ModCompatability;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;

public class GregTechHelper
extends IECompatModule {
    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        IERecipes.addOredictRecipe(new ItemStack((Block)IEContent.blockMetalDevice, 8, 11), "LLL", "IRI", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), "sheetRubber");
        IERecipes.addOredictRecipe(new ItemStack((Block)IEContent.blockMetalDevice, 1, 10), "III", "CBC", "CCC", Character.valueOf('I'), "ingotSteel", Character.valueOf('C'), "ingotCupronickel", Character.valueOf('B'), new ItemStack((Block)IEContent.blockStorage, 1, 8));
        if (Config.getBoolean("hardmodeBulletRecipes")) {
            BlueprintCraftingRecipe.addRecipe("bullet", new ItemStack((Item)IEContent.itemBullet, 1, 3), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.gunpowder, "ingotSteel", "ingotCupronickel");
        } else {
            BlueprintCraftingRecipe.addRecipe("bullet", new ItemStack((Item)IEContent.itemBullet, 1, 3), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.gunpowder, "nuggetSteel", "nuggetSteel", "nuggetCupronickel", "nuggetCupronickel");
        }
        IERecipes.oreOutputSecondaries.put("Beryllium", new Object[]{Items.emerald, Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Magnesium", new Object[]{"gemPeridot", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Silicon", new Object[]{"dustSiliconDioxide", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Phosphor", new Object[]{"dustPhosphate", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Titanium", new Object[]{new ItemStack((Item)IEContent.itemMetal, 1, 11), Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Chrome", new Object[]{"dustIron", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Manganese", new Object[]{"dustChrome", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Thorium", new Object[]{"dustUranium", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("PigIron", new Object[]{"dustIron", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("Naquadah", new Object[]{"dustNaquadahEnriched", Float.valueOf(0.1f)});
        IERecipes.oreOutputSecondaries.put("NaquadahEnriched", new Object[]{"dustNaquadah", Float.valueOf(0.1f)});
        IERecipes.addOreDictAlloyingRecipe("ingotHotNichrome", 5, "Chrome", 400, 4096, "dustNickel", "dustNickel", "dustNickel", "dustNickel");
        IERecipes.addOreDictAlloyingRecipe("ingotHotKanthal", 3, "Iron", 500, 4096, "dustAluminium", "dustChrome");
        IERecipes.addOreDictAlloyingRecipe("ingotHotKanthal", 3, "Aluminium", 500, 4096, "dustIron", "dustChrome");
        IERecipes.addOreDictAlloyingRecipe("ingotHotKanthal", 3, "Chrome", 500, 4096, "dustAluminium", "dustIron");
        IERecipes.addOreDictAlloyingRecipe("ingotMagnalium", 3, "Magnesium", 200, 512, "dustAluminium", "dustAluminium");
        IERecipes.addOreDictAlloyingRecipe("ingotBatteryAlloy", 5, "Antimony", 200, 512, "dustLead", "dustLead", "dustLead", "dustLead");
        IERecipes.addOreDictAlloyingRecipe("ingotHotTungstenSteel", 2, "Tungsten", 800, 4096, "dustSteel");
        IERecipes.addOreDictAlloyingRecipe("ingotHotTungstenSteel", 2, "Steel", 800, 4096, "dustTungsten");
        IERecipes.addOreDictAlloyingRecipe("ingotHotTungstenCarbide", 2, "Tungsten", 1000, 4096, "dustCoke");
        for (ExcavatorHandler.MineralMix min : ExcavatorHandler.mineralList.keySet()) {
            if (!min.name.equalsIgnoreCase("Magnetite")) continue;
            min.ores = new String[]{"oreMagnetite", "oreIron", "oreVanadiumMagnetite"};
            min.chances = new float[]{0.75f, 0.2f, 0.05f};
        }
        ExcavatorHandler.addMineral("Wolframite", 15, 0.2f, new String[]{"oreTungsten", "oreIron", "oreManganese"}, new float[]{0.55f, 0.3f, 0.15f});
        for (GregsTerribleFluidPotions fluidPotion : GregsTerribleFluidPotions.values()) {
            String potionName = "potion." + fluidPotion.toString().toLowerCase();
            ChemthrowerHandler.registerEffect(potionName, (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, fluidPotion.potion, fluidPotion.baseDuration, fluidPotion.baseAmplifier));
            if (fluidPotion.strong) {
                ChemthrowerHandler.registerEffect(potionName + ".strong", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, fluidPotion.potion, (int)((float)fluidPotion.baseDuration * 0.5f), fluidPotion.baseAmplifier + 1));
            }
            if (fluidPotion.extended) {
                ChemthrowerHandler.registerEffect(potionName + ".long", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, fluidPotion.potion, fluidPotion.baseDuration * 2, fluidPotion.baseAmplifier));
            }
            if (fluidPotion.splash) {
                ChemthrowerHandler.registerEffect(potionName + ".splash", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, fluidPotion.potion, (int)((float)fluidPotion.baseDuration * 0.75f), fluidPotion.baseAmplifier));
            }
            if (fluidPotion.strong && fluidPotion.splash) {
                ChemthrowerHandler.registerEffect(potionName + ".strong.splash", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, fluidPotion.potion, (int)((float)fluidPotion.baseDuration * 0.375f), fluidPotion.baseAmplifier + 1));
            }
            if (!fluidPotion.extended || !fluidPotion.splash) continue;
            ChemthrowerHandler.registerEffect(potionName + ".long.splash", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, fluidPotion.potion, (int)((float)fluidPotion.baseDuration * 1.5f), fluidPotion.baseAmplifier));
        }
        ChemthrowerHandler.registerEffect("liquid_light_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 0)));
        ChemthrowerHandler.registerFlammable("liquid_light_oil");
        ChemthrowerHandler.registerEffect("liquid_medium_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 0)));
        ChemthrowerHandler.registerFlammable("liquid_medium_oil");
        ChemthrowerHandler.registerEffect("liquid_heavy_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 120, 0)));
        ChemthrowerHandler.registerFlammable("liquid_heavy_oil");
        ChemthrowerHandler.registerEffect("liquid_extra_heavy_oil", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 140, 0), new PotionEffect(Potion.blindness.id, 80, 1)));
        ChemthrowerHandler.registerFlammable("liquid_extra_heavy_oil");
        ChemthrowerHandler.registerFlammable("gas_natural_gas");
        ChemthrowerHandler.registerEffect("liquid_heavy_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("liquid_heavy_fuel");
        ChemthrowerHandler.registerEffect("liquid_light_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("liquid_light_fuel");
        ChemthrowerHandler.registerEffect("liquid_cracked_light_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 60, 1)));
        ChemthrowerHandler.registerFlammable("liquid_cracked_light_fuel");
        ChemthrowerHandler.registerEffect("liquid_cracked_heavy_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 80, 1)));
        ChemthrowerHandler.registerFlammable("liquid_cracked_heavy_fuel");
        ChemthrowerHandler.registerEffect("liquid_heavy_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("liquid_heavy_fuel");
        ChemthrowerHandler.registerEffect("liquid_light_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 80, 1)));
        ChemthrowerHandler.registerFlammable("liquid_light_fuel");
        ChemthrowerHandler.registerEffect("liquid_sulfuricheavy_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("liquid_sulfuricheavy_fuel");
        ChemthrowerHandler.registerEffect("liquid_sufluriclight_fuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 80, 1)));
        ChemthrowerHandler.registerFlammable("liquid_sufluriclight_fuel");
        ChemthrowerHandler.registerEffect("liquid_naphtha", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("liquid_naphtha");
        ChemthrowerHandler.registerEffect("liquid_sulfuricnaphtha", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("liquid_sulfuricnaphtha");
        ChemthrowerHandler.registerEffect("nitrofuel", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.flammable.id, 100, 1)));
        ChemthrowerHandler.registerFlammable("nitrofuel");
        ChemthrowerHandler.registerEffect("lubricant", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, new PotionEffect(IEPotions.slippery.id, 80, 0)));
        ChemthrowerHandler.registerEffect("sulfuricacid", (ChemthrowerHandler.ChemthrowerEffect)new ChemthrowerHandler.ChemthrowerEffect_Damage(IEDamageSources.causeAcidDamage(), 2.0f));
        ChemthrowerHandler.registerFlammable("hydrogen");
        ChemthrowerHandler.registerFlammable("methane");
        ChemthrowerHandler.registerFlammable("gas_gas");
        ChemthrowerHandler.registerFlammable("gas_natural_gas");
        ChemthrowerHandler.registerFlammable("gas_sulfuricgas");
        ChemthrowerHandler.registerFlammable("liquid_lpg");
        ChemthrowerHandler.registerGas("liquid_lpg");
    }

    @Override
    public void postInit() {
    }

    public static boolean gregtech_isValidEnergyOutput(TileEntity tile) {
        if (!Lib.GREG) {
            return false;
        }
        return tile instanceof IBasicEnergyContainer && ((IBasicEnergyContainer)tile).getEUCapacity() > 0L;
    }

    public static long gregtech_outputGTPower(Object energyContainer, byte side, long volt, long amp, boolean simulate) {
        if (!Lib.GREG) {
            return 0L;
        }
        if (energyContainer instanceof IBasicEnergyContainer) {
            IBasicEnergyContainer container = (IBasicEnergyContainer)energyContainer;
            if (!container.inputEnergyFrom(side) || container.getStoredEU() >= container.getEUCapacity()) {
                return 0L;
            }
            if (volt > container.getInputVoltage() && container instanceof IGregTechTileEntity) {
                ((IGregTechTileEntity)container).doExplosion(volt);
                return 0L;
            }
            long voltRound = volt;
            long in = 0L;
            if (((IBasicEnergyContainer)energyContainer).increaseStoredEnergyUnits(voltRound, false)) {
                // empty if block
            }
            if (simulate) {
                ((IBasicEnergyContainer)energyContainer).decreaseStoredEnergyUnits(voltRound, true);
            }
            return ++in > 0L ? volt : 0L;
        }
        return 0L;
    }

    public static String gregtech_getEnergyStored(TileEntity tile) {
        if (!Lib.GREG) {
            return null;
        }
        if (tile instanceof IBasicEnergyContainer) {
            long stored = ((IBasicEnergyContainer)tile).getStoredEU();
            long maxStored = ((IBasicEnergyContainer)tile).getEUCapacity();
            if (maxStored > 0L) {
                return Utils.toScientificNotation(ModCompatability.convertEUtoRF(stored), "0##", 100000) + " / " + Utils.toScientificNotation(ModCompatability.convertEUtoRF(maxStored), "0##", 100000);
            }
        }
        return null;
    }

    public static enum GregsTerribleFluidPotions {
        DAMAGE(Potion.harm, 0, 0, true, false, true),
        HEALTH(Potion.heal, 0, 0, true, false, true),
        SPEED(Potion.moveSpeed, 60, 0, true, true, true),
        STRENGTH(Potion.damageBoost, 60, 0, true, true, true),
        REGEN(Potion.regeneration, 60, 0, true, true, true),
        POISON(Potion.poison, 60, 0, true, true, true),
        FIRERESISTANCE(Potion.fireResistance, 60, 0, false, true, true),
        NIGHTVISION(Potion.nightVision, 60, 0, false, true, true),
        WEAKNESS(Potion.weakness, 60, 0, false, true, true),
        SLOWNESS(Potion.moveSlowdown, 60, 0, false, true, true),
        WATERBREATHING(Potion.waterBreathing, 60, 0, false, true, true),
        INVISIBILITY(Potion.invisibility, 60, 0, false, true, true);

        final Potion potion;
        final int baseDuration;
        final int baseAmplifier;
        final boolean strong;
        final boolean extended;
        final boolean splash;

        private GregsTerribleFluidPotions(Potion pot, int baseDur, int baseAmp, boolean strong, boolean extended, boolean splash) {
            this.potion = pot;
            this.baseDuration = baseDur;
            this.baseAmplifier = baseAmp;
            this.strong = strong;
            this.extended = extended;
            this.splash = splash;
        }
    }
}

