/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.IECompatModule;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.TinyPotatoRenderEvent;

public class BotaniaHelper
extends IECompatModule {
    private static ArrayListMultimap<String, ItemRevolver.SpecialRevolver> nameToSpecial = ArrayListMultimap.create();
    EntityItem revolverEntity;

    @Override
    public void preInit() {
    }

    @Override
    public void init() {
        if (Config.getBoolean("hardmodeBulletRecipes")) {
            BlueprintCraftingRecipe.addRecipe("specialBullet", new ItemStack((Item)IEContent.itemBullet, 1, 7), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.gunpowder, "ingotTerrasteel");
        } else {
            BlueprintCraftingRecipe.addRecipe("specialBullet", new ItemStack((Item)IEContent.itemBullet, 1, 7), new ItemStack((Item)IEContent.itemBullet, 1, 0), Items.gunpowder, "nuggetTerrasteel", "nuggetTerrasteel");
        }
        BlueprintCraftingRecipe.addRecipe("specialBullet", new ItemStack((Item)IEContent.itemBullet, 1, 8), new ItemStack((Item)IEContent.itemBullet, 1, 1), Items.gunpowder, new ItemStack((Item)IEContent.itemBullet, 4, 7));
        Config.setBoolean("botaniaBullets", true);
        if (Utils.getModVersion("Botania").startsWith("r1.8")) {
            BotaniaAPI.blacklistBlockFromMagnet((Block)IEContent.blockMetalDevice, (int)11);
            BotaniaAPI.blacklistBlockFromMagnet((Block)IEContent.blockMetalDevice, (int)15);
        }
        ShaderRegistry.rarityWeightMap.put(EnumRarity.valueOf((String)"RELIC"), 2);
        ShaderRegistry.registerShader("Spectral", "5", EnumRarity.epic, new int[]{26, 26, 40, 220}, new int[]{0, 70, 49, 220}, new int[]{40, 40, 50, 220}, new int[]{5, 10, 8, 180}, null, false, true);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Override
    public void postInit() {
        new ThreadContributorToNameFormatter();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled() && event.entityLiving.getClass().getName().endsWith("EntityDoppleganger")) {
            NBTTagCompound tag = new NBTTagCompound();
            event.entityLiving.writeEntityToNBT(tag);
            if (tag.getBoolean("hardMode")) {
                for (EntityItem item : event.drops) {
                    if (item == null || item.getEntityItem() == null || !((Object)((Object)IEContent.itemShaderBag)).equals(item.getEntityItem().getItem())) continue;
                    ItemNBTHelper.setString(item.getEntityItem(), "rarity", "RELIC");
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPotatoRender(TinyPotatoRenderEvent event) {
        if (event.tile.getWorldObj() == null) {
            return;
        }
        if (this.revolverEntity == null) {
            this.revolverEntity = new EntityItem(event.tile.getWorldObj(), 0.0, 0.0, 0.0, new ItemStack((Item)IEContent.itemRevolver));
            this.revolverEntity.hoverStart = 0.0f;
        }
        try {
            List list;
            String formattedName = event.name.replace("_", " ");
            ItemRevolver.SpecialRevolver special = null;
            if (formattedName.equalsIgnoreCase("Mr Damien Hazard") || event.name.equalsIgnoreCase("Mr Hazard")) {
                special = ItemRevolver.specialRevolversByTag.get("dev");
            } else if (event.name.equalsIgnoreCase("BluSunrize")) {
                special = ItemRevolver.specialRevolversByTag.get("fenrir");
            } else if (nameToSpecial.containsKey((Object)event.name.toLowerCase()) && (list = nameToSpecial.get((Object)event.name.toLowerCase())) != null && list.size() > 0) {
                long ticks = event.tile.getWorldObj() != null ? event.tile.getWorldObj().getTotalWorldTime() / 100L : 0L;
                special = (ItemRevolver.SpecialRevolver)list.get((int)(ticks % (long)list.size()));
            }
            if (special != null) {
                GL11.glPushMatrix();
                ((ItemRevolver)IEContent.itemRevolver).applySpecialCrafting(this.revolverEntity.getEntityItem(), special);
                GL11.glRotated((double)200.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)-0.16, (double)-1.3, (double)0.6);
                GL11.glScalef((float)0.625f, (float)0.625f, (float)0.625f);
                RenderManager.instance.renderEntityWithPosYaw((Entity)this.revolverEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                GL11.glPopMatrix();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ThreadContributorToNameFormatter
    extends Thread {
        public ThreadContributorToNameFormatter() {
            this.setName("Immersive Engineering Contributors Name Finder Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                if (ImmersiveEngineering.ThreadContributorSpecialsDownloader.activeThread != null) {
                    ImmersiveEngineering.ThreadContributorSpecialsDownloader.activeThread.join();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            for (String uuid : ItemRevolver.specialRevolvers.keySet()) {
                nameToSpecial.putAll((Object)ImmersiveEngineering.proxy.getNameFromUUID(uuid).toLowerCase(), (Iterable)ItemRevolver.specialRevolvers.get((Object)uuid));
            }
        }
    }
}

