/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ItemNBTHelper {
    public static NBTTagCompound getTag(ItemStack stack) {
        if (!stack.hasTagCompound()) {
            stack.setTagCompound(new NBTTagCompound());
        }
        return stack.getTagCompound();
    }

    public static boolean hasTag(ItemStack stack) {
        return stack.hasTagCompound();
    }

    public static boolean hasKey(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).hasKey(key) : false;
    }

    public static void remove(ItemStack stack, String key) {
        if (ItemNBTHelper.hasKey(stack, key)) {
            ItemNBTHelper.getTag(stack).removeTag(key);
            if (ItemNBTHelper.getTag(stack).hasNoTags()) {
                stack.setTagCompound(null);
            }
        }
    }

    public static void setInt(ItemStack stack, String key, int val) {
        ItemNBTHelper.getTag(stack).setInteger(key, val);
    }

    public static void modifyInt(ItemStack stack, String key, int mod) {
        ItemNBTHelper.getTag(stack).setInteger(key, ItemNBTHelper.getTag(stack).getInteger(key) + mod);
    }

    public static int getInt(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getInteger(key) : 0;
    }

    public static void setString(ItemStack stack, String key, String val) {
        ItemNBTHelper.getTag(stack).setString(key, val);
    }

    public static String getString(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getString(key) : "";
    }

    public static void setLong(ItemStack stack, String key, long val) {
        ItemNBTHelper.getTag(stack).setLong(key, val);
    }

    public static long getLong(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getLong(key) : 0L;
    }

    public static void setIntArray(ItemStack stack, String key, int[] val) {
        ItemNBTHelper.getTag(stack).setIntArray(key, val);
    }

    public static int[] getIntArray(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getIntArray(key) : new int[]{};
    }

    public static void setFloat(ItemStack stack, String key, float val) {
        ItemNBTHelper.getTag(stack).setFloat(key, val);
    }

    public static float getFloat(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getFloat(key) : 0.0f;
    }

    public static void setBoolean(ItemStack stack, String key, boolean val) {
        ItemNBTHelper.getTag(stack).setBoolean(key, val);
    }

    public static boolean getBoolean(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getBoolean(key) : false;
    }

    public static void setTagCompound(ItemStack stack, String key, NBTTagCompound val) {
        ItemNBTHelper.getTag(stack).setTag(key, (NBTBase)val);
    }

    public static NBTTagCompound getTagCompound(ItemStack stack, String key) {
        return ItemNBTHelper.hasTag(stack) ? ItemNBTHelper.getTag(stack).getCompoundTag(key) : new NBTTagCompound();
    }

    public static void setDelayedSoundsForStack(ItemStack stack, String nbtKey, String sound, float volume, float pitch, int amount, int baseDelay, int iDelay) {
        int[] delayedSounds = new int[amount];
        for (int i = 0; i < delayedSounds.length; ++i) {
            delayedSounds[i] = baseDelay + i * iDelay;
        }
        ItemNBTHelper.setIntArray(stack, "delayedSound_" + nbtKey + "_delay", delayedSounds);
        ItemNBTHelper.setString(stack, "delayedSound_" + nbtKey + "_sound", sound);
        ItemNBTHelper.setFloat(stack, "delayedSound_" + nbtKey + "_volume", volume);
        ItemNBTHelper.setFloat(stack, "delayedSound_" + nbtKey + "_pitch", pitch);
    }

    public static int handleDelayedSoundsForStack(ItemStack stack, String nbtKey, Entity ent) {
        if (!ItemNBTHelper.hasKey(stack, "delayedSound_" + nbtKey + "_delay")) {
            return -1;
        }
        int[] delayedSounds = ItemNBTHelper.getIntArray(stack, "delayedSound_" + nbtKey + "_delay");
        int l = 0;
        for (int i = 0; i < delayedSounds.length; ++i) {
            int n = i;
            delayedSounds[n] = delayedSounds[n] - 1;
            if (delayedSounds[i] <= 0) {
                ent.worldObj.playSoundAtEntity(ent, ItemNBTHelper.getString(stack, "delayedSound_" + nbtKey + "_sound"), ItemNBTHelper.getFloat(stack, "delayedSound_" + nbtKey + "_volume"), ItemNBTHelper.getFloat(stack, "delayedSound_" + nbtKey + "_pitch"));
                continue;
            }
            ++l;
        }
        if (l > 0) {
            ItemNBTHelper.setIntArray(stack, "delayedSound_" + nbtKey + "_delay", delayedSounds);
        } else {
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_delay");
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_sound");
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_volume");
            ItemNBTHelper.remove(stack, "delayedSound_" + nbtKey + "_pitch");
        }
        return l;
    }

    public static void setFluidStack(ItemStack stack, String key, FluidStack val) {
        if (val != null && val.getFluid() != null) {
            NBTTagCompound tag = ItemNBTHelper.getTagCompound(stack, key);
            tag.setString("fluid", val.getFluid().getName());
            tag.setInteger("amount", val.amount);
            ItemNBTHelper.setTagCompound(stack, key, tag);
        } else {
            ItemNBTHelper.remove(stack, "fluid");
        }
    }

    public static FluidStack getFluidStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack)) {
            NBTTagCompound tag = ItemNBTHelper.getTagCompound(stack, key);
            String name = tag.getString("fluid");
            int amount = tag.getInteger("amount");
            if (FluidRegistry.getFluid((String)name) != null) {
                return new FluidStack(FluidRegistry.getFluid((String)name), amount);
            }
        }
        return null;
    }

    public static void setItemStack(ItemStack stack, String key, ItemStack val) {
        ItemNBTHelper.getTag(stack).setTag(key, (NBTBase)val.writeToNBT(new NBTTagCompound()));
    }

    public static ItemStack getItemStack(ItemStack stack, String key) {
        if (ItemNBTHelper.hasTag(stack) && ItemNBTHelper.getTag(stack).hasKey(key)) {
            return ItemStack.loadItemStackFromNBT((NBTTagCompound)ItemNBTHelper.getTagCompound(stack, key));
        }
        return null;
    }

    public static void setLore(ItemStack stack, String ... lore) {
        NBTTagCompound displayTag = ItemNBTHelper.getTagCompound(stack, "display");
        NBTTagList list = new NBTTagList();
        for (String s : lore) {
            list.appendTag((NBTBase)new NBTTagString(s));
        }
        displayTag.setTag("Lore", (NBTBase)list);
        ItemNBTHelper.setTagCompound(stack, "display", displayTag);
    }
}

