/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.util.IELogger;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;

public class IEPotions {
    public static Potion flammable;
    public static Potion slippery;
    public static Potion conductive;
    public static Potion sticky;

    public static void init() {
        int l = 4;
        IEPotions.extendPotionArray(l);
        long potionUUIDBase = 109406000905L;
        int potionID = Config.getPotionID(24, "Flammable");
        flammable = new IEPotion(potionID, true, 9387807, 0, false, 0).setPotionName("immersiveengineering.potion.flammable");
        potionID = Config.getPotionID(potionID, "Slippery");
        slippery = new IEPotion(potionID, true, 1511427, 0, false, 1).setPotionName("immersiveengineering.potion.slippery");
        potionID = Config.getPotionID(potionID, "Conductive");
        conductive = new IEPotion(potionID, true, 0x690000, 0, false, 2).setPotionName("immersiveengineering.potion.conductive");
        potionID = Config.getPotionID(potionID, "Sticky");
        sticky = new IEPotion(potionID, true, 10250240, 0, false, 3).setPotionName("immersiveengineering.potion.sticky").func_111184_a(SharedMonsterAttributes.movementSpeed, new UUID(potionUUIDBase, 1L).toString(), -0.5000000029802323, 2);
        IEApi.potions = new Potion[]{flammable, slippery, conductive, sticky};
    }

    public static void extendPotionArray(int extendBy) {
        IELogger.info("Attempting to extend PotionArray by " + extendBy);
        Potion[] potions = new Potion[Potion.potionTypes.length + extendBy];
        for (int i = 0; i < Potion.potionTypes.length; ++i) {
            potions[i] = Potion.potionTypes[i];
        }
        try {
            Field[] fields;
            Field field = null;
            for (Field f : fields = Potion.class.getDeclaredFields()) {
                if (!f.getType().toString().equals("class [Lnet.minecraft.potion.Potion;")) continue;
                field = f;
                break;
            }
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, potions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getNextPotionId(int start) {
        if (Potion.potionTypes == null) {
            return -2;
        }
        if (start < 0) {
            start = 0;
        }
        int max = Math.min(Potion.potionTypes.length, 256);
        while (start < max && Potion.potionTypes[start] != null) {
            ++start;
        }
        if (start >= 256) {
            return -1;
        }
        return start;
    }

    public static class IEPotion
    extends Potion {
        static ResourceLocation tex = new ResourceLocation("immersiveengineering", "textures/gui/potioneffects.png");
        final int tickrate;
        final boolean halfTickRateWIthAmplifier;

        public IEPotion(int id, boolean isBad, int colour, int tick, boolean halveTick, int icon) {
            super(id, isBad, colour);
            this.tickrate = tick;
            this.halfTickRateWIthAmplifier = halveTick;
            this.setIconIndex(icon % 8, icon / 8);
        }

        public int getStatusIconIndex() {
            Minecraft.getMinecraft().getTextureManager().bindTexture(tex);
            return super.getStatusIconIndex();
        }

        public boolean isReady(int duration, int amplifier) {
            if (this.tickrate < 0) {
                return false;
            }
            int k = this.tickrate >> amplifier;
            return k > 0 ? duration % k == 0 : true;
        }

        public void performEffect(EntityLivingBase living, int amplifier) {
            if (this == slippery) {
                if (living.onGround) {
                    living.moveFlying(0.0f, 1.0f, 0.005f);
                }
                if (!living.worldObj.isRemote && living.getRNG().nextInt(300) == 0 && living.getEquipmentInSlot(0) != null) {
                    EntityItem dropped = living.entityDropItem(living.getEquipmentInSlot(0).copy(), 1.0f);
                    dropped.delayBeforeCanPickup = 20;
                    living.setCurrentItemOrArmor(0, null);
                }
            }
        }
    }
}

