/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemSkyhook
extends ItemUpgradeableTool
implements ITool {
    public static HashMap<String, EntitySkylineHook> existingHooks = new HashMap();

    public ItemSkyhook() {
        super("skyhook", 1, "SKYHOOK", new String[0]);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.skyhook"));
    }

    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        if (this.getUpgrades(stack).getBoolean("fallBoost")) {
            float dmg = (float)Math.ceil(ent.fallDistance / 5.0f);
            ItemNBTHelper.setFloat(stack, "fallDamageBoost", dmg);
        }
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        float dmg = 5.0f + ItemNBTHelper.getFloat(stack, "fallDamageBoost");
        Multimap multimap = super.getAttributeModifiers(stack);
        multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)dmg, 0));
        return multimap;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        TileEntity connector = null;
        double lastDist = 0.0;
        ImmersiveNetHandler.Connection line = null;
        double py = player.posY + (double)player.getEyeHeight();
        for (int xx = -2; xx <= 2; ++xx) {
            for (int zz = -2; zz <= 2; ++zz) {
                for (int yy = 0; yy <= 3; ++yy) {
                    ImmersiveNetHandler.Connection con;
                    TileEntity tile = world.getTileEntity((int)player.posX + xx, (int)py + yy, (int)player.posZ + zz);
                    if (tile == null || (con = SkylineHelper.getTargetConnection(world, tile.xCoord, tile.yCoord, tile.zCoord, (EntityLivingBase)player, null)) == null) continue;
                    double d = tile.getDistanceFrom(player.posX, py, player.posZ);
                    if (connector != null && !(d < lastDist)) continue;
                    connector = tile;
                    lastDist = d;
                    line = con;
                }
            }
        }
        if (line != null && connector != null) {
            SkylineHelper.spawnHook(player, connector, line);
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public float getSkylineSpeed(ItemStack stack) {
        return 3.0f + this.getUpgrades(stack).getFloat("speed");
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int ticks) {
        if (existingHooks.containsKey(player.getCommandSenderName())) {
            EntitySkylineHook hook = existingHooks.get(player.getCommandSenderName());
            hook.setDead();
            existingHooks.remove(player.getCommandSenderName());
        }
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 0, 102, 42, "SKYHOOK", stack, true), new IESlot.Upgrades(container, invItem, 1, 102, 22, "SKYHOOK", stack, true)};
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 2;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

