/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.tool.IBullet;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.network.MessageSpeedloaderSync;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemRevolver
extends ItemUpgradeableTool
implements IShaderEquipableItem,
ITool {
    public HashMap<String, IIcon> revolverIcons = new HashMap();
    public IIcon revolverDefaultTexture;
    public static final ArrayListMultimap<String, SpecialRevolver> specialRevolvers = ArrayListMultimap.create();
    public static final Map<String, SpecialRevolver> specialRevolversByTag = new HashMap<String, SpecialRevolver>();

    public ItemRevolver() {
        super("revolver", 1, "REVOLVER", new String[]{"normal", "speedloader"});
    }

    @Override
    public void registerIcons(IIconRegister ir) {
        this.icons[1] = ir.registerIcon("immersiveengineering:" + this.itemName + "_" + "speedloader");
    }

    public void stichRevolverTextures(IIconRegister ir) {
        this.revolverDefaultTexture = ir.registerIcon("immersiveengineering:revolver");
        for (String key : specialRevolversByTag.keySet()) {
            if (key.isEmpty() || ItemRevolver.specialRevolversByTag.get((Object)key).tag.isEmpty()) continue;
            int split = key.lastIndexOf("_");
            if (split < 0) {
                split = key.length();
            }
            this.revolverIcons.put(key, ir.registerIcon("immersiveengineering:revolver_" + key.substring(0, split)));
        }
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 21;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 18, 80, 32, "REVOLVER", stack, true), new IESlot.Upgrades(container, invItem, 19, 100, 32, "REVOLVER", stack, true), new IESlot.Shader(container, invItem, 20, 130, 32, stack)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return stack.getItemDamage() != 1;
    }

    @Override
    public void setShaderItem(ItemStack stack, ItemStack shader) {
        ItemStack[] contained = this.getContainedItems(stack);
        contained[20] = shader;
        this.setContainedItems(stack, contained);
    }

    @Override
    public ItemStack getShaderItem(ItemStack stack) {
        ItemStack[] contained = this.getContainedItems(stack);
        return contained[20];
    }

    @Override
    public String getShaderType() {
        return "revolver";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        if (stack.getItemDamage() != 1) {
            String tag = this.getRevolverDisplayTag(stack);
            if (!tag.isEmpty()) {
                list.add(StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.flavour.revolver." + tag)));
            } else if (ItemNBTHelper.hasKey(stack, "flavour")) {
                list.add(StatCollector.translateToLocal((String)("desc.ImmersiveEngineering.flavour.revolver." + ItemNBTHelper.getString(stack, "flavour"))));
            } else if (stack.getItemDamage() == 0) {
                list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.revolver"));
            }
            ItemStack shader = this.getShaderItem(stack);
            if (shader != null) {
                list.add(EnumChatFormatting.DARK_GRAY + shader.getDisplayName());
            }
        }
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        String tag;
        if (stack.getItemDamage() != 1 && !(tag = this.getRevolverDisplayTag(stack)).isEmpty()) {
            return this.getUnlocalizedName() + "." + tag;
        }
        return super.getUnlocalizedName(stack);
    }

    public boolean isFull3D() {
        return true;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        double speed;
        Multimap multimap = super.getAttributeModifiers(stack);
        double melee = this.getUpgrades(stack).getDouble("melee");
        if (melee != 0.0) {
            multimap.put((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", melee, 0));
        }
        if ((speed = this.getUpgrades(stack).getDouble("speed")) != 0.0) {
            multimap.put((Object)SharedMonsterAttributes.movementSpeed.getAttributeUnlocalizedName(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", speed, 1));
        }
        return multimap;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
        if (!world.isRemote && stack.getItemDamage() != 1 && ent != null && ItemNBTHelper.hasKey(stack, "blocked")) {
            int l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "casings", ent);
            if (l == 0) {
                ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderFill", "tile.piston.in", 0.3f, 3.0f, 1, 6, 1);
            }
            if ((l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderFill", ent)) == 0) {
                ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderClose", "fire.ignite", 0.6f, 5.0f, 1, 6, 1);
            }
            if ((l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderClose", ent)) == 0) {
                ItemNBTHelper.setDelayedSoundsForStack(stack, "cylinderSpin", "note.hat", 0.1f, 5.0f, 5, 8, 1);
            }
            if ((l = ItemNBTHelper.handleDelayedSoundsForStack(stack, "cylinderSpin", ent)) == 0) {
                ItemNBTHelper.remove(stack, "blocked");
            }
        }
    }

    public ItemStack onItemRightClick(ItemStack revolver, World world, EntityPlayer player) {
        if (!world.isRemote) {
            if (player.isSneaking() || revolver.getItemDamage() == 1) {
                player.openGui((Object)ImmersiveEngineering.instance, 2, world, (int)player.posX, (int)player.posY, (int)player.posZ);
            } else if (this.getUpgrades(revolver).getBoolean("nerf")) {
                world.playSoundAtEntity((Entity)player, "random.pop", 1.0f, 0.6f);
            } else {
                ItemStack[] bullets = this.getBullets(revolver);
                if (this.isEmpty(revolver)) {
                    for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
                        ItemStack loader = player.inventory.getStackInSlot(i);
                        if (loader == null || loader.getItem() != this || loader.getItemDamage() != 1 || this.isEmpty(loader)) continue;
                        int dc = 0;
                        for (ItemStack b : bullets) {
                            if (b == null) continue;
                            world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, b));
                            ++dc;
                        }
                        world.playSoundAtEntity((Entity)player, "fire.ignite", 0.5f, 3.0f);
                        ItemNBTHelper.setDelayedSoundsForStack(revolver, "casings", "random.successful_hit", 0.05f, 5.0f, dc / 2, 8, 2);
                        this.setBullets(revolver, this.getBullets(loader));
                        this.setBullets(loader, new ItemStack[8]);
                        player.inventory.setInventorySlotContents(i, loader);
                        player.inventory.markDirty();
                        if (player instanceof EntityPlayerMP) {
                            ImmersiveEngineering.packetHandler.sendTo((IMessage)new MessageSpeedloaderSync(i), (EntityPlayerMP)player);
                        }
                        ItemNBTHelper.setBoolean(revolver, "blocked", true);
                        return revolver;
                    }
                }
                if (!ItemNBTHelper.getBoolean(revolver, "blocked")) {
                    if (bullets[0] != null && bullets[0].getItem() instanceof IBullet && ((IBullet)bullets[0].getItem()).canSpawnBullet(bullets[0])) {
                        ((IBullet)bullets[0].getItem()).spawnBullet(player, bullets[0], this.getUpgrades(revolver).getBoolean("electro"));
                        bullets[0] = ((IBullet)bullets[0].getItem()).getCasing(bullets[0]);
                        world.playSoundAtEntity((Entity)player, "fireworks.blast", 0.6f, 1.0f);
                        world.playSoundAtEntity((Entity)player, "mob.wither.shoot", 0.3f, 5.0f);
                    } else {
                        world.playSoundAtEntity((Entity)player, "note.hat", 0.6f, 3.0f);
                    }
                    ItemStack[] cycled = new ItemStack[this.getBulletSlotAmount(revolver)];
                    for (int i = 1; i < cycled.length; ++i) {
                        cycled[i - 1] = bullets[i];
                    }
                    cycled[cycled.length - 1] = bullets[0];
                    this.setBullets(revolver, cycled);
                }
            }
        }
        return revolver;
    }

    public boolean isEmpty(ItemStack stack) {
        ItemStack[] bullets = this.getBullets(stack);
        boolean empty = true;
        for (ItemStack b : bullets) {
            if (b == null || !(b.getItem() instanceof IBullet) || !((IBullet)b.getItem()).canSpawnBullet(b)) continue;
            empty = false;
        }
        return empty;
    }

    public ItemStack[] getBullets(ItemStack revolver) {
        ItemStack[] stackList = this.getContainedItems(revolver);
        ItemStack[] bullets = new ItemStack[this.getBulletSlotAmount(revolver)];
        System.arraycopy(stackList, 0, bullets, 0, bullets.length);
        return bullets;
    }

    public void setBullets(ItemStack revolver, ItemStack[] bullets) {
        ItemStack[] stackList = this.getContainedItems(revolver);
        for (int i = 0; i < bullets.length; ++i) {
            stackList[i] = bullets[i];
        }
        this.setContainedItems(revolver, stackList);
    }

    public int getBulletSlotAmount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).getInteger("bullets");
    }

    @Override
    public NBTTagCompound getUpgradeBase(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "baseUpgrades");
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    public IIcon getRevolverIcon(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            return this.revolverIcons.get(tag);
        }
        return this.revolverDefaultTexture;
    }

    public String[] compileRender(ItemStack revolver) {
        NBTTagCompound upgrades;
        SpecialRevolver r;
        HashSet<String> render = new HashSet<String>();
        render.add("revolver_frame");
        render.add("barrel");
        render.add("cosmetic_compensator");
        String tag = ItemNBTHelper.getString(revolver, "elite");
        String flavour = ItemNBTHelper.getString(revolver, "flavour");
        if (tag != null && !tag.isEmpty() && specialRevolversByTag.containsKey(tag)) {
            r = specialRevolversByTag.get(tag);
            if (r != null && r.renderAdditions != null) {
                for (String ss : r.renderAdditions) {
                    render.add(ss);
                }
            }
        } else if (flavour != null && !flavour.isEmpty() && specialRevolversByTag.containsKey(flavour) && (r = specialRevolversByTag.get(flavour)) != null && r.renderAdditions != null) {
            for (String ss : r.renderAdditions) {
                render.add(ss);
            }
        }
        if ((upgrades = this.getUpgrades(revolver)).getInteger("bullets") > 0 && !render.contains("dev_mag")) {
            render.add("player_mag");
        }
        if (upgrades.getDouble("melee") > 0.0 && !render.contains("dev_bayonet")) {
            render.add("bayonet_attachment");
            render.add("player_bayonet");
        }
        if (upgrades.getBoolean("electro")) {
            render.add("player_electro_0");
            render.add("player_electro_1");
        }
        return render.toArray(new String[render.size()]);
    }

    public void onCreated(ItemStack stack, World world, EntityPlayer player) {
        ArrayList list;
        if (stack == null || player == null) {
            return;
        }
        if (stack.getItemDamage() == 1) {
            return;
        }
        String uuid = player.getUniqueID().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = ItemNBTHelper.getString(stack, "elite");
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            ItemNBTHelper.remove(stack, "elite");
            ItemNBTHelper.remove(stack, "flavour");
            ItemNBTHelper.remove(stack, "baseUpgrades");
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            ItemNBTHelper.setString(stack, "elite", r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            ItemNBTHelper.setString(stack, "flavour", r.flavour);
        }
        NBTTagCompound baseUpgrades = new NBTTagCompound();
        for (Map.Entry<String, Object> e : r.baseUpgrades.entrySet()) {
            if (e.getValue() instanceof Boolean) {
                baseUpgrades.setBoolean(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                baseUpgrades.setInteger(e.getKey(), ((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof Float) {
                baseUpgrades.setDouble(e.getKey(), (double)((Float)e.getValue()).floatValue());
                continue;
            }
            if (e.getValue() instanceof Double) {
                baseUpgrades.setDouble(e.getKey(), ((Double)e.getValue()).doubleValue());
                continue;
            }
            if (!(e.getValue() instanceof String)) continue;
            baseUpgrades.setString(e.getKey(), (String)e.getValue());
        }
        ItemNBTHelper.setTagCompound(stack, "baseUpgrades", baseUpgrades);
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
        ItemStack[] contents = this.getContainedItems(stack);
        if (contents[18] != null && contents[19] != null) {
            player.triggerAchievement((StatBase)IEAchievements.upgradeRevolver);
        }
    }

    @Override
    public boolean isTool(ItemStack item) {
        return item.getItemDamage() != 1;
    }

    public static class SpecialRevolver {
        public final String[] uuid;
        public final String tag;
        public final String flavour;
        public final HashMap<String, Object> baseUpgrades;
        public final String[] renderAdditions;

        public SpecialRevolver(String[] uuid, String tag, String flavour, HashMap<String, Object> baseUpgrades, String[] renderAdditions) {
            this.uuid = uuid;
            this.tag = tag;
            this.flavour = flavour;
            this.baseUpgrades = baseUpgrades;
            this.renderAdditions = renderAdditions;
        }
    }
}

