/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.IEnergyContainerItem;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ItemRailgun
extends ItemUpgradeableTool
implements IShaderEquipableItem,
IEnergyContainerItem,
ZoomHandler.IZoomTool,
ITool {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public ItemRailgun() {
        super("railgun", 1, "RAILGUN", new String[0]);
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 0, 80, 32, "RAILGUN", stack, true), new IESlot.Upgrades(container, invItem, 1, 100, 32, "RAILGUN", stack, true), new IESlot.Shader(container, invItem, 2, 130, 32, stack)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack) {
        super.recalculateUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        if (this.getEnergyStored(stack) > this.getMaxEnergyStored(stack)) {
            ItemNBTHelper.setInt(stack, "energy", this.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void setShaderItem(ItemStack stack, ItemStack shader) {
        ItemStack[] contained = this.getContainedItems(stack);
        contained[2] = shader;
        this.setContainedItems(stack, contained);
    }

    @Override
    public ItemStack getShaderItem(ItemStack stack) {
        ItemStack[] contained = this.getContainedItems(stack);
        return contained[2];
    }

    @Override
    public String getShaderType() {
        return "railgun";
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        ItemStack shader = this.getShaderItem(stack);
        if (shader != null) {
            list.add(EnumChatFormatting.DARK_GRAY + shader.getDisplayName());
        }
        String stored = this.getEnergyStored(stack) + "/" + this.getMaxEnergyStored(stack);
        list.add(StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{stored}));
    }

    @Override
    public String getUnlocalizedName(ItemStack stack) {
        return super.getUnlocalizedName(stack);
    }

    public boolean isFull3D() {
        return true;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean inHand) {
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        int energy = Config.getInt("railgun_consumption");
        float energyMod = 1.0f + this.getUpgrades(stack).getFloat("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && ItemRailgun.findAmmo(player) != null) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
            String sound = "chargeSlow";
            if (this.getChargeTime(stack) <= 20) {
                sound = "chargeFast";
            }
            player.playSound("immersiveengineering:" + sound, 1.5f, 1.0f);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int inUse = this.getMaxItemUseDuration(stack) - count;
        if (inUse > this.getChargeTime(stack) && inUse % 20 == player.getRNG().nextInt(20)) {
            player.playSound("immersiveengineering:spark", 0.8f + 0.2f * player.getRNG().nextFloat(), 0.5f + 0.5f * player.getRNG().nextFloat());
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        int ammoSlot;
        int inUse = this.getMaxItemUseDuration(stack) - timeLeft;
        if (inUse < this.getChargeTime(stack)) {
            return;
        }
        int energy = Config.getInt("railgun_consumption");
        float energyMod = 1.0f + this.getUpgrades(stack).getFloat("consumption");
        if (this.extractEnergy(stack, energy = (int)((float)energy * energyMod), true) == energy && (ammoSlot = ItemRailgun.findAmmoSlot(player)) >= 0) {
            ItemStack ammo = player.inventory.mainInventory[ammoSlot];
            Vec3 vec = player.getLookVec();
            float speed = 20.0f;
            EntityRailgunShot shot = new EntityRailgunShot(player.worldObj, (EntityLivingBase)player, vec.xCoord * (double)speed, vec.yCoord * (double)speed, vec.zCoord * (double)speed, Utils.copyStackWithAmount(ammo, 1));
            player.inventory.decrStackSize(ammoSlot, 1);
            player.playSound("immersiveengineering:railgunFire", 1.0f, 0.5f + 0.5f * player.getRNG().nextFloat());
            this.extractEnergy(stack, energy, false);
            if (!world.isRemote) {
                player.worldObj.spawnEntityInWorld((Entity)shot);
            }
        }
    }

    public static ItemStack findAmmo(EntityPlayer player) {
        int slot = ItemRailgun.findAmmoSlot(player);
        return slot >= 0 ? player.inventory.mainInventory[slot] : null;
    }

    public static int findAmmoSlot(EntityPlayer player) {
        ItemStack[] inventory = player.inventory.mainInventory;
        for (int i = 0; i < inventory.length; ++i) {
            RailgunHandler.RailgunProjectileProperties prop;
            ItemStack stack = inventory[i];
            if (stack == null || (prop = RailgunHandler.getProjectileProperties(stack)) == null) continue;
            return i;
        }
        return -1;
    }

    public int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + this.getUpgrades(railgun).getFloat("speed")));
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int accepted = Math.min(maxReceive, this.getMaxEnergyStored(container) - stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored += accepted);
        }
        return accepted;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = this.getEnergyStored(container);
        int extracted = Math.min(maxExtract, stored);
        if (!simulate) {
            ItemNBTHelper.setInt(container, "energy", stored -= extracted);
        }
        return extracted;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInt(container, "energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return 8000 + this.getUpgrades(container).getInteger("capacity");
    }

    public String[] compileRender(ItemStack stack) {
        HashSet<String> render = new HashSet<String>();
        render.add("frame");
        render.add("barrel");
        render.add("grip");
        render.add("capacitors");
        render.add("sled");
        render.add("wires");
        NBTTagCompound upgrades = this.getUpgrades(stack);
        if (upgrades.getDouble("speed") > 0.0) {
            render.add("upgrade_speed");
        }
        if (upgrades.getBoolean("scope")) {
            render.add("upgrade_scope");
        }
        return render.toArray(new String[render.size()]);
    }

    @Override
    public boolean canZoom(ItemStack stack, EntityPlayer player) {
        return this.getUpgrades(stack).getBoolean("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, EntityPlayer player) {
        return this.zoomSteps;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }
}

