/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.item.IToolHammer;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.Optional;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.item.IToolHammer", modid="CoFHAPI|item")
public class ItemIETool
extends ItemIEBase
implements IToolHammer,
ITool {
    static int hammerMaxDamage;

    public ItemIETool() {
        super("tool", 1, "hammer", "wirecutter", "voltmeter", "manual");
        hammerMaxDamage = Config.getInt("hammerDurabiliy");
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        int[] link;
        if (adv && stack.getItemDamage() == 0) {
            int nbtDamage = ItemNBTHelper.getInt(stack, "hammerDmg");
            list.add("Durability: " + (hammerMaxDamage - nbtDamage) + " / " + hammerMaxDamage);
        }
        if (ItemNBTHelper.hasKey(stack, "linkingPos") && (link = ItemNBTHelper.getIntArray(stack, "linkingPos")) != null && link.length > 3) {
            list.add(StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.getItemDamage() == 0;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        int nbtDamage;
        if (stack.getItemDamage() == 0 && (nbtDamage = ItemNBTHelper.getInt(stack, "hammerDmg") + 1) < hammerMaxDamage) {
            ItemStack container = stack.copy();
            ItemNBTHelper.setInt(container, "hammerDmg", nbtDamage);
            return container;
        }
        return null;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack stack) {
        return stack.getItemDamage() != 0;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.isRemote) {
            TileEntity tileEntity = world.getTileEntity(x, y, z);
            if (stack.getItemDamage() == 0) {
                int meta;
                String[] interdictedMultiblocks = null;
                if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction")) {
                    NBTTagList list = stack.getTagCompound().getTagList("multiblockInterdiction", 8);
                    interdictedMultiblocks = new String[list.tagCount()];
                    for (int i = 0; i < interdictedMultiblocks.length; ++i) {
                        interdictedMultiblocks[i] = list.getStringTagAt(i);
                    }
                }
                for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
                    if (!mb.isBlockTrigger(world.getBlock(x, y, z), world.getBlockMetadata(x, y, z))) continue;
                    boolean allowed = true;
                    if (interdictedMultiblocks != null) {
                        for (String s : interdictedMultiblocks) {
                            if (!mb.getUniqueName().equalsIgnoreCase(s)) continue;
                            allowed = false;
                            break;
                        }
                    }
                    if (!allowed || !mb.createStructure(world, x, y, z, side, player)) continue;
                    return true;
                }
                if (world.getBlock(x, y, z) == Blocks.piston && !BlockPistonBase.isExtended((int)(meta = world.getBlockMetadata(x, y, z)))) {
                    int dir = BlockPistonBase.getPistonOrientation((int)meta);
                    dir = (dir + 1) % 6;
                    world.setBlockMetadataWithNotify(x, y, z, meta - (meta & 7) + dir, 3);
                }
                return false;
            }
            if (stack.getItemDamage() == 1 && tileEntity instanceof IImmersiveConnectable) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(nodeHere), world, new TargetingInfo(side, hitX, hitY, hitZ));
                IESaveData.setDirty(world.provider.dimensionId);
                return true;
            }
            if (stack.getItemDamage() == 2) {
                if (!player.isSneaking() && (tileEntity instanceof IEnergyReceiver || tileEntity instanceof IEnergyProvider)) {
                    int max = 0;
                    int stored = 0;
                    if (tileEntity instanceof IEnergyReceiver) {
                        max = ((IEnergyReceiver)tileEntity).getMaxEnergyStored(ForgeDirection.getOrientation((int)side));
                        stored = ((IEnergyReceiver)tileEntity).getEnergyStored(ForgeDirection.getOrientation((int)side));
                    } else {
                        max = ((IEnergyProvider)tileEntity).getMaxEnergyStored(ForgeDirection.getOrientation((int)side));
                        stored = ((IEnergyProvider)tileEntity).getEnergyStored(ForgeDirection.getOrientation((int)side));
                    }
                    if (max > 0) {
                        player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.energyStorage", new Object[]{stored, max}));
                    }
                    return true;
                }
                if (player.isSneaking() && tileEntity instanceof IImmersiveConnectable) {
                    if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                        ItemNBTHelper.setIntArray(stack, "linkingPos", new int[]{world.provider.dimensionId, x, y, z});
                    } else {
                        int[] pos = ItemNBTHelper.getIntArray(stack, "linkingPos");
                        if (pos[0] == world.provider.dimensionId) {
                            IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                            TileEntity te2 = world.getTileEntity(pos[1], pos[2], pos[3]);
                            if (!(te2 instanceof IImmersiveConnectable)) {
                                player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.warning.invalidPoint", new Object[0]));
                                return true;
                            }
                            IImmersiveConnectable nodeLink = (IImmersiveConnectable)te2;
                            Set<ImmersiveNetHandler.AbstractConnection> connections = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(nodeLink), world);
                            for (ImmersiveNetHandler.AbstractConnection con : connections) {
                                if (!Utils.toCC(nodeHere).equals((Object)con.end)) continue;
                                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.averageLoss", new Object[]{Utils.formatDouble(con.getAverageLossRate() * 100.0f, "###.000")}));
                            }
                        }
                        ItemNBTHelper.remove(stack, "linkingPos");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        if (player.getCurrentEquippedItem() != null && this.equals(player.getCurrentEquippedItem().getItem())) {
            return player.getCurrentEquippedItem().getItemDamage() == 0;
        }
        return false;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (stack.getItemDamage() == 3) {
            player.triggerAchievement((StatBase)IEAchievements.openManual);
            if (world.isRemote) {
                player.openGui((Object)ImmersiveEngineering.instance, 3, world, (int)player.posX, (int)player.posY, (int)player.posZ);
            }
        }
        return stack;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.getToolClasses(stack).contains(toolClass)) {
            return 2;
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.getItemDamage() == 0 && ItemNBTHelper.getInt(stack, "hammerDmg") > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemNBTHelper.getInt(stack, "hammerDmg") / (double)hammerMaxDamage;
    }

    public int getMaxDamage(ItemStack stack) {
        return hammerMaxDamage;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        int meta = stack.getItemDamage();
        return (Set)(meta == 0 ? ImmutableSet.of((Object)"IE_HAMMER") : (meta == 1 ? ImmutableSet.of((Object)"IE_WIRECUTTER") : new HashSet()));
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            return 6.0f;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    @Override
    @Optional.Method(modid="CoFHAPI|item")
    public boolean isUsable(ItemStack stack, EntityLivingBase living, int x, int y, int z) {
        return stack != null && stack.getItemDamage() == 0;
    }

    @Override
    @Optional.Method(modid="CoFHAPI|item")
    public void toolUsed(ItemStack stack, EntityLivingBase living, int x, int y, int z) {
    }

    @Override
    public boolean isTool(ItemStack item) {
        return item.getItemDamage() != 3;
    }
}

