/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemGraphiteElectrode
extends ItemIEBase {
    static int electrodeMaxDamage;

    public ItemGraphiteElectrode() {
        super("graphiteElectrode", 1, new String[0]);
        electrodeMaxDamage = Config.getInt("arcfurnace_electrodeDamage");
    }

    @Override
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        super.getSubItems(item, tab, list);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        float integrity = 100.0f - (float)this.getDurabilityForDisplay(stack) * 100.0f;
        list.add(String.format("%s %.2f %%", StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.info.electrodeIntegrity"), Float.valueOf(integrity)));
        if (super.getDamage(stack) != 0) {
            list.add("This item is deprecated. Hold it in your inventory to update it.");
        }
    }

    public void onUpdate(ItemStack stack, World world, Entity ent, int slot, boolean hand) {
        if (ent instanceof EntityPlayer && super.getDamage(stack) != 0) {
            ItemStack fixed = new ItemStack((Item)this);
            ItemNBTHelper.setInt(fixed, "graphDmg", stack.getItemDamage());
            ((EntityPlayer)ent).inventory.setInventorySlotContents(slot, fixed);
        }
    }

    public boolean isItemTool(ItemStack stack) {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)ItemNBTHelper.getInt(stack, "graphDmg") / (double)electrodeMaxDamage;
    }

    public int getMaxDamage(ItemStack stack) {
        return electrodeMaxDamage;
    }

    public boolean isDamaged(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, "graphDmg") > 0;
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public void setDamage(ItemStack stack, int damage) {
        ItemNBTHelper.setInt(stack, "graphDmg", damage);
    }

    public void damage(ItemStack s, int dmg) {
        ItemNBTHelper.setInt(s, "graphDmg", dmg + ItemNBTHelper.getInt(s, "graphDmg"));
    }
}

