/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemChemthrower
extends ItemUpgradeableTool
implements IShaderEquipableItem,
IFluidContainerItem,
ITool {
    public ItemChemthrower() {
        super("chemthrower", 1, "CHEMTHROWER", new String[0]);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        FluidStack fs;
        ItemStack shader = this.getShaderItem(stack);
        if (shader != null) {
            list.add(EnumChatFormatting.DARK_GRAY + shader.getDisplayName());
        }
        if ((fs = this.getFluid(stack)) != null) {
            EnumChatFormatting rarity = fs.getFluid().getRarity() == EnumRarity.common ? EnumChatFormatting.GRAY : fs.getFluid().getRarity().rarityColor;
            list.add(rarity + fs.getLocalizedName() + EnumChatFormatting.GRAY + ": " + fs.amount + "/" + this.getCapacity(stack) + "mB");
        } else {
            list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.drill.empty"));
        }
    }

    public boolean isFull3D() {
        return true;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (player.isSneaking()) {
            if (!world.isRemote) {
                ItemNBTHelper.setBoolean(stack, "ignite", !ItemNBTHelper.getBoolean(stack, "ignite"));
            }
        } else {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getFluid() != null) {
            int duration = this.getMaxItemUseDuration(stack) - count;
            int consumed = Config.getInt("chemthrower_consumption");
            if (consumed * duration <= fs.amount) {
                float range;
                Vec3 v = player.getLookVec();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas(fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).getBoolean("focus")) {
                    range += 0.25f;
                    scatter -= 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ItemNBTHelper.getBoolean(stack, "ignite");
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.addVector(player.getRNG().nextGaussian() * (double)scatter, player.getRNG().nextGaussian() * (double)scatter, player.getRNG().nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(player.worldObj, (EntityLivingBase)player, vecDir.xCoord * 0.25, vecDir.yCoord * 0.25, vecDir.zCoord * 0.25, fs.getFluid());
                    chem.motionX = vecDir.xCoord * (double)range;
                    chem.motionY = vecDir.yCoord * (double)range;
                    chem.motionZ = vecDir.zCoord * (double)range;
                    if (ignite) {
                        chem.setFire(10);
                    }
                    if (player.worldObj.isRemote) continue;
                    player.worldObj.spawnEntityInWorld((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        player.playSound("immersiveengineering:spray_fire", 0.5f, 1.5f);
                    } else {
                        player.playSound("immersiveengineering:spray", 0.5f, 0.75f);
                    }
                }
            } else {
                player.stopUsingItem();
            }
        } else {
            player.stopUsingItem();
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            int duration = this.getMaxItemUseDuration(stack) - timeLeft;
            int consumed = Config.getInt("chemthrower_consumption");
            fs.amount -= consumed * duration;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(stack, "fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "fluid", fs);
            }
        }
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public FluidStack getFluid(ItemStack container) {
        return ItemNBTHelper.getFluidStack(container, "fluid");
    }

    public int getCapacity(ItemStack container) {
        return 2000 + this.getUpgrades(container).getInteger("capacity");
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        FluidStack fs;
        if (resource != null && ((fs = this.getFluid(container)) == null || fs.amount < 0 || fs.isFluidEqual(resource))) {
            int space = fs == null ? this.getCapacity(container) : this.getCapacity(container) - fs.amount;
            int accepted = Math.min(space, resource.amount);
            if (fs == null) {
                fs = new FluidStack(resource, accepted);
            } else {
                fs.amount += accepted;
            }
            if (doFill) {
                ItemNBTHelper.setFluidStack(container, "fluid", fs);
            }
            return accepted;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack fs = this.getFluid(container);
        if (fs == null) {
            return null;
        }
        int drained = Math.min(maxDrain, fs.amount);
        FluidStack stack = new FluidStack(fs, drained);
        if (doDrain) {
            fs.amount -= drained;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(container, "fluid");
            } else {
                ItemNBTHelper.setFluidStack(container, "fluid", fs);
            }
        }
        return stack;
    }

    @Override
    public void setShaderItem(ItemStack stack, ItemStack shader) {
        ItemStack[] contained = this.getContainedItems(stack);
        contained[3] = shader;
        this.setContainedItems(stack, contained);
    }

    @Override
    public ItemStack getShaderItem(ItemStack stack) {
        ItemStack[] contained = this.getContainedItems(stack);
        return contained[3];
    }

    @Override
    public String getShaderType() {
        return "chemthrower";
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 0, 80, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, invItem, 1, 100, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, invItem, 2, 120, 32, "CHEMTHROWER", stack, true), new IESlot.Shader(container, invItem, 3, 150, 32, stack)};
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 4;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack)) {
            fs.amount = this.getCapacity(stack);
            ItemNBTHelper.setFluidStack(stack, "fluid", fs);
        }
    }
}

