/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IBullet;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershotHoming;
import blusunrize.immersiveengineering.common.items.ItemIEBase;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;

public class ItemBullet
extends ItemIEBase
implements IBullet {
    IIcon iconPotion;

    public ItemBullet() {
        super("bullet", 64, "emptyCasing", "emptyShell", "casull", "armorPiercing", "buckshot", "HE", "dragonsbreath", "homing", "wolfpack", "silver", "potion");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getSubNames().length; ++i) {
            if ((i == 7 || i == 8) && (!Loader.isModLoaded((String)"Botania") || !Config.getBoolean("compat_Botania"))) continue;
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        ItemStack pot;
        if (stack.getItemDamage() == 10 && (pot = ItemNBTHelper.getItemStack(stack, "potion")) != null && pot.getItem() instanceof ItemPotion) {
            List effects = ((ItemPotion)pot.getItem()).getEffects(pot);
            HashMultimap hashmultimap = HashMultimap.create();
            if (effects != null && !effects.isEmpty()) {
                for (PotionEffect potioneffect : effects) {
                    String s1 = StatCollector.translateToLocal((String)potioneffect.getEffectName()).trim();
                    Potion potion = Potion.potionTypes[potioneffect.getPotionID()];
                    Map map = potion.func_111186_k();
                    if (map != null && map.size() > 0) {
                        for (Map.Entry entry : map.entrySet()) {
                            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                            AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.getName(), potion.func_111183_a(potioneffect.getAmplifier(), attributemodifier), attributemodifier.getOperation());
                            hashmultimap.put((Object)((IAttribute)entry.getKey()).getAttributeUnlocalizedName(), (Object)attributemodifier1);
                        }
                    }
                    if (potioneffect.getAmplifier() > 0) {
                        s1 = s1 + " " + StatCollector.translateToLocal((String)("potion.potency." + potioneffect.getAmplifier())).trim();
                    }
                    if (potioneffect.getDuration() > 20) {
                        s1 = s1 + " (" + Potion.getDurationString((PotionEffect)potioneffect) + ")";
                    }
                    if (potion.isBadEffect()) {
                        list.add(EnumChatFormatting.RED + s1);
                        continue;
                    }
                    list.add(EnumChatFormatting.GRAY + s1);
                }
            } else {
                String s = StatCollector.translateToLocal((String)"potion.empty").trim();
                list.add(EnumChatFormatting.GRAY + s);
            }
            if (!hashmultimap.isEmpty()) {
                list.add("");
                list.add(EnumChatFormatting.DARK_PURPLE + StatCollector.translateToLocal((String)"potion.effects.whenDrank"));
                for (Map.Entry entry1 : hashmultimap.entries()) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)entry1.getValue();
                    double d0 = attributemodifier2.getAmount();
                    double d1 = attributemodifier2.getOperation() != 1 && attributemodifier2.getOperation() != 2 ? attributemodifier2.getAmount() : attributemodifier2.getAmount() * 100.0;
                    if (d0 > 0.0) {
                        list.add(EnumChatFormatting.BLUE + StatCollector.translateToLocalFormatted((String)("attribute.modifier.plus." + attributemodifier2.getOperation()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), StatCollector.translateToLocal((String)("attribute.name." + (String)entry1.getKey()))}));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    list.add(EnumChatFormatting.RED + StatCollector.translateToLocalFormatted((String)("attribute.modifier.take." + attributemodifier2.getOperation()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), StatCollector.translateToLocal((String)("attribute.name." + (String)entry1.getKey()))}));
                }
            }
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        if (stack.getItemDamage() == 10) {
            String s = this.getUnlocalizedNameInefficiently(stack);
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            if (pot != null) {
                if (pot.getItem().getClass().getName().equalsIgnoreCase("ganymedes01.etfuturum.items.LingeringPotion")) {
                    s = s + ".linger";
                } else if (ItemPotion.isSplash((int)pot.getItemDamage())) {
                    s = s + ".splash";
                }
            }
            return StatCollector.translateToLocal((String)(s + ".name")).trim();
        }
        return super.getItemStackDisplayName(stack);
    }

    @Override
    public void registerIcons(IIconRegister ir) {
        super.registerIcons(ir);
        this.iconPotion = ir.registerIcon("immersiveengineering:bullet_potion_layer");
    }

    public IIcon getIconFromDamageForRenderPass(int meta, int pass) {
        if (meta == 10 && pass == 0) {
            return this.iconPotion;
        }
        return super.getIconFromDamageForRenderPass(meta, pass);
    }

    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return metadata == 10 ? 2 : 1;
    }

    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (stack.getItemDamage() == 10 && pass == 0) {
            ItemStack pot = ItemNBTHelper.getItemStack(stack, "potion");
            return PotionHelper.func_77915_a((int)(pot != null ? pot.getItemDamage() : 0), (boolean)false);
        }
        return super.getColorFromItemStack(stack, pass);
    }

    @Override
    public ItemStack getCasing(ItemStack stack) {
        return new ItemStack((Item)this, 1, stack.getItemDamage() == 1 || stack.getItemDamage() == 4 || stack.getItemDamage() == 6 ? 1 : 0);
    }

    @Override
    public boolean canSpawnBullet(ItemStack bulletStack) {
        return bulletStack != null && bulletStack.getItemDamage() > 1 && (bulletStack.getItemDamage() != 10 || ItemNBTHelper.getItemStack(bulletStack, "potion") != null);
    }

    @Override
    public void spawnBullet(EntityPlayer player, ItemStack bulletStack, boolean electro) {
        Vec3 vec = player.getLookVec();
        int type = bulletStack.getItemDamage() - 2;
        switch (type) {
            case 0: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 1: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 2: {
                for (int i = 0; i < 10; ++i) {
                    Vec3 vecDir = vec.addVector(player.getRNG().nextGaussian() * 0.1, player.getRNG().nextGaussian() * 0.1, player.getRNG().nextGaussian() * 0.1);
                    this.doSpawnBullet(player, vec, vecDir, type, bulletStack, electro);
                }
                break;
            }
            case 3: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 4: {
                for (int i = 0; i < 30; ++i) {
                    Vec3 vecDir = vec.addVector(player.getRNG().nextGaussian() * 0.1, player.getRNG().nextGaussian() * 0.1, player.getRNG().nextGaussian() * 0.1);
                    EntityRevolvershot shot = this.doSpawnBullet(player, vec, vecDir, type, bulletStack, electro);
                    shot.setTickLimit(10);
                    shot.setFire(3);
                }
                break;
            }
            case 5: {
                EntityRevolvershotHoming bullet = new EntityRevolvershotHoming(player.worldObj, (EntityLivingBase)player, vec.xCoord * 1.5, vec.yCoord * 1.5, vec.zCoord * 1.5, type, bulletStack);
                bullet.motionX = vec.xCoord;
                bullet.motionY = vec.yCoord;
                bullet.motionZ = vec.zCoord;
                bullet.bulletElectro = electro;
                player.worldObj.spawnEntityInWorld((Entity)bullet);
                break;
            }
            case 6: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 7: {
                this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                break;
            }
            case 8: {
                EntityRevolvershot shot = this.doSpawnBullet(player, vec, vec, type, bulletStack, electro);
                shot.bulletPotion = ItemNBTHelper.getItemStack(bulletStack, "potion");
            }
        }
    }

    EntityRevolvershot doSpawnBullet(EntityPlayer player, Vec3 vecSpawn, Vec3 vecDir, int type, ItemStack stack, boolean electro) {
        EntityRevolvershot bullet = new EntityRevolvershot(player.worldObj, (EntityLivingBase)player, vecDir.xCoord * 1.5, vecDir.yCoord * 1.5, vecDir.zCoord * 1.5, type, stack);
        bullet.motionX = vecDir.xCoord;
        bullet.motionY = vecDir.yCoord;
        bullet.motionZ = vecDir.zCoord;
        bullet.bulletElectro = electro;
        player.worldObj.spawnEntityInWorld((Entity)bullet);
        return bullet;
    }
}

