/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.tool.IBullet;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.gui.ContainerArcFurnace;
import blusunrize.immersiveengineering.common.gui.ContainerBlastFurnace;
import blusunrize.immersiveengineering.common.gui.ContainerModWorkbench;
import blusunrize.immersiveengineering.common.items.ItemEngineersBlueprint;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public abstract class IESlot
extends Slot {
    final Container container;

    public IESlot(Container container, IInventory inv, int id, int x, int y) {
        super(inv, id, x, y);
        this.container = container;
    }

    public boolean isItemValid(ItemStack itemStack) {
        return true;
    }

    public static interface ICallbackContainer {
        public boolean canInsert(ItemStack var1, int var2, Slot var3);

        public boolean canTake(ItemStack var1, int var2, Slot var3);
    }

    public static class ContainerCallback
    extends IESlot {
        public ContainerCallback(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canInsert(itemStack, this.slotNumber, this);
            }
            return true;
        }

        public boolean canTakeStack(EntityPlayer player) {
            if (this.container instanceof ICallbackContainer) {
                return ((ICallbackContainer)this.container).canTake(this.getStack(), this.slotNumber, this);
            }
            return true;
        }
    }

    public static class ArcElectrode
    extends IESlot {
        public ArcElectrode(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return itemStack != null && ((Object)((Object)IEContent.itemGraphiteElectrode)).equals(itemStack.getItem());
        }
    }

    public static class ArcAdditive
    extends IESlot {
        public ArcAdditive(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return itemStack != null && ArcFurnaceRecipe.isValidRecipeAdditive(itemStack);
        }
    }

    public static class ArcInput
    extends IESlot {
        public ArcInput(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return itemStack != null && ArcFurnaceRecipe.isValidRecipeInput(itemStack);
        }
    }

    public static class BlueprintOutput
    extends IESlot {
        public BlueprintCraftingRecipe recipe;
        ItemStack upgradeableTool;

        public BlueprintOutput(Container container, IInventory inv, int id, int x, int y, ItemStack upgradeableTool, BlueprintCraftingRecipe recipe) {
            super(container, inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
            this.recipe = recipe;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            return this.getHasStack();
        }

        public void onPickupFromSlot(EntityPlayer player, ItemStack stack) {
            if (this.upgradeableTool != null && this.upgradeableTool.getItem() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.getItem()).reduceInputs(this.recipe, this.upgradeableTool, stack, this.container);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
                ((ContainerModWorkbench)this.container).tile.markDirty();
            }
            block0: for (IEAchievements.AchievementIE achievement : IEAchievements.blueprintCraftingAchievements) {
                if (achievement.triggerItems != null && achievement.triggerItems.length > 0) {
                    for (ItemStack trigger : achievement.triggerItems) {
                        if (!OreDictionary.itemMatches((ItemStack)trigger, (ItemStack)stack, (boolean)true)) continue;
                        player.triggerAchievement((StatBase)achievement);
                        continue block0;
                    }
                    continue;
                }
                if (!OreDictionary.itemMatches((ItemStack)achievement.theItemStack, (ItemStack)stack, (boolean)true)) continue;
                player.triggerAchievement((StatBase)achievement);
            }
            this.inventory.markDirty();
            super.onPickupFromSlot(player, stack);
        }
    }

    public static class BlueprintInput
    extends IESlot {
        ItemStack upgradeableTool;

        public BlueprintInput(Container container, IInventory inv, int id, int x, int y, ItemStack upgradeableTool) {
            super(container, inv, id, x, y);
            this.upgradeableTool = upgradeableTool;
        }

        public void onSlotChanged() {
            this.inventory.markDirty();
            if (this.upgradeableTool != null && this.upgradeableTool.getItem() instanceof ItemEngineersBlueprint) {
                ((ItemEngineersBlueprint)this.upgradeableTool.getItem()).updateOutputs(this.upgradeableTool);
            }
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
            super.onSlotChanged();
        }

        public int getSlotStackLimit() {
            return 64;
        }
    }

    public static class ItemDisplay
    extends IESlot {
        public ItemDisplay(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        public boolean canTakeStack(EntityPlayer player) {
            return false;
        }
    }

    public static class Ghost
    extends IESlot {
        public Ghost(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        public void putStack(ItemStack itemStack) {
            super.putStack(itemStack);
        }

        public boolean canTakeStack(EntityPlayer player) {
            return false;
        }

        public int getSlotStackLimit() {
            return 1;
        }
    }

    public static class UpgradeableItem
    extends IESlot {
        int size;

        public UpgradeableItem(Container container, IInventory inv, int id, int x, int y, int size) {
            super(container, inv, id, x, y);
            this.size = size;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return itemStack != null && itemStack.getItem() instanceof IUpgradeableTool && ((IUpgradeableTool)itemStack.getItem()).canModify(itemStack);
        }

        public int getSlotStackLimit() {
            return this.size;
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (this.container instanceof ContainerModWorkbench) {
                ((ContainerModWorkbench)this.container).rebindSlots();
            }
        }

        public boolean canTakeStack(EntityPlayer player) {
            return this.getStack() == null || !(this.getStack().getItem() instanceof IUpgradeableTool) || ((IUpgradeableTool)this.getStack().getItem()).canTakeFromWorkbench(this.getStack());
        }

        public void onPickupFromSlot(EntityPlayer player, ItemStack stack) {
            super.onPickupFromSlot(player, stack);
            if (stack != null && stack.getItem() instanceof IUpgradeableTool) {
                ((IUpgradeableTool)stack.getItem()).removeFromWorkbench(player, stack);
            }
        }
    }

    public static class Shader
    extends IESlot {
        ItemStack tool;

        public Shader(Container container, IInventory inv, int id, int x, int y, ItemStack tool) {
            super(container, inv, id, x, y);
            this.tool = tool;
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.setBackgroundIcon(IEContent.itemShader.icons[3]);
            }
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            if (itemStack == null || !(itemStack.getItem() instanceof IShaderItem) || this.tool == null || !(this.tool.getItem() instanceof IShaderEquipableItem)) {
                return false;
            }
            return ((IShaderItem)itemStack.getItem()).getShaderCase(itemStack, this.tool, ((IShaderEquipableItem)this.tool.getItem()).getShaderType()) != null;
        }

        public int getSlotStackLimit() {
            return 1;
        }
    }

    public static class Upgrades
    extends IESlot {
        ItemStack upgradeableTool;
        String type;
        boolean preventDoubles;

        public Upgrades(Container container, IInventory inv, int id, int x, int y, String type, ItemStack upgradeableTool, boolean preventDoubles) {
            super(container, inv, id, x, y);
            this.type = type;
            this.upgradeableTool = upgradeableTool;
            this.preventDoubles = preventDoubles;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            if (this.preventDoubles) {
                for (Slot slot : this.container.inventorySlots) {
                    if (!(slot instanceof Upgrades) || !((Upgrades)slot).preventDoubles || !OreDictionary.itemMatches((ItemStack)slot.getStack(), (ItemStack)itemStack, (boolean)true)) continue;
                    return false;
                }
            }
            return itemStack != null && itemStack.getItem() instanceof IUpgrade && ((IUpgrade)itemStack.getItem()).getUpgradeTypes(itemStack).contains(this.type) && ((IUpgrade)itemStack.getItem()).canApplyUpgrades(this.upgradeableTool, itemStack);
        }

        public int getSlotStackLimit() {
            return 64;
        }
    }

    public static class DrillHead
    extends IESlot {
        public DrillHead(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return itemStack != null && itemStack.getItem() instanceof IDrillHead;
        }

        public int getSlotStackLimit() {
            return 1;
        }
    }

    public static class Bullet
    extends IESlot {
        int limit;

        public Bullet(Container container, IInventory inv, int id, int x, int y, int limit) {
            super(container, inv, id, x, y);
            this.limit = limit;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return itemStack != null && itemStack.getItem() instanceof IBullet;
        }

        public int getSlotStackLimit() {
            return this.limit;
        }
    }

    public static class BlastFuel
    extends IESlot {
        public BlastFuel(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return BlastFurnaceRecipe.isValidBlastFuel(itemStack);
        }
    }

    public static class FluidContainer
    extends IESlot {
        boolean empty;

        public FluidContainer(Container container, IInventory inv, int id, int x, int y, boolean empty) {
            super(container, inv, id, x, y);
            this.empty = empty;
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            if (this.empty) {
                return FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
            }
            return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
        }
    }

    public static class Output
    extends IESlot {
        public Output(Container container, IInventory inv, int id, int x, int y) {
            super(container, inv, id, x, y);
        }

        @Override
        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        public void onPickupFromSlot(EntityPlayer player, ItemStack stack) {
            super.onPickupFromSlot(player, stack);
            if (player != null && (this.container instanceof ContainerBlastFurnace || this.container instanceof ContainerArcFurnace) && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemMetal, 1, 7), (ItemStack)stack, (boolean)true)) {
                player.triggerAchievement((StatBase)IEAchievements.makeSteel);
            }
        }
    }
}

