/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.entities.EntitySkylineHook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntitySkycrate
extends EntitySkylineHook {
    public ItemStack[] inventory = new ItemStack[27];

    public EntitySkycrate(World world) {
        super(world);
        this.setSize(1.0f, 1.5f);
        this.width = 0.05f;
        this.height = 0.05f;
        this.renderDistanceWeight = 100.0;
        this.ignoreFrustumCheck = true;
    }

    public EntitySkycrate(World world, double x, double y, double z, ImmersiveNetHandler.Connection connection, ChunkCoordinates target, Vec3[] subPoints) {
        super(world, x, y, z, connection, target, subPoints);
        this.setSize(1.0f, 1.5f);
        this.width = 0.05f;
        this.height = 0.05f;
        this.ignoreFrustumCheck = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double distance) {
        double d1 = 16.0;
        return distance < (d1 *= 64.0 * this.renderDistanceWeight) * d1;
    }

    public void setDead() {
        if (!this.worldObj.isRemote) {
            ItemStack stack = new ItemStack((Block)IEContent.blockWoodenDevice, 1, 4);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList invList = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.setByte("Slot", (byte)i);
                this.inventory[i].writeToNBT(itemTag);
                invList.appendTag((NBTBase)itemTag);
            }
            nbt.setTag("inventory", (NBTBase)invList);
            if (!nbt.hasNoTags()) {
                stack.setTagCompound(nbt);
            }
            EntityItem crate = new EntityItem(this.worldObj, this.posX, this.posY - 0.5, this.posZ, stack);
            crate.motionX = 0.0;
            crate.motionY = -0.25;
            crate.motionZ = 0.0;
            this.worldObj.spawnEntityInWorld((Entity)crate);
        }
        super.setDead();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void reachedTarget(TileEntity end) {
        Iterator<ImmersiveNetHandler.Connection> iterator;
        ImmersiveNetHandler.Connection line;
        Vec3 vec;
        IELogger.info("last tick at " + System.currentTimeMillis());
        IELogger.info("killing Skycrate!");
        if (!(this.worldObj.getTileEntity(this.target.posX, this.target.posY, this.target.posZ) instanceof IImmersiveConnectable)) {
            this.setDead();
            return;
        }
        Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(this.worldObj, this.target);
        if (outputs != null && outputs.size() > 0) {
            vec = Vec3.createVectorHelper((double)(this.connection.end.posX - this.connection.start.posX), (double)(this.connection.end.posY - this.connection.start.posY), (double)(this.connection.end.posZ - this.connection.start.posZ));
            vec = vec.normalize();
            line = null;
            iterator = outputs.iterator();
        } else {
            this.setDead();
            return;
        }
        while (iterator.hasNext()) {
            ImmersiveNetHandler.Connection c = iterator.next();
            if (c == null || c.hasSameConnectors(this.connection)) continue;
            if (line == null) {
                line = c;
                continue;
            }
            Vec3 lineVec = Vec3.createVectorHelper((double)(line.end.posX - line.start.posX), (double)(line.end.posY - line.start.posY), (double)(line.end.posZ - line.start.posZ)).normalize();
            Vec3 conVec = Vec3.createVectorHelper((double)(c.end.posX - c.start.posX), (double)(c.end.posY - c.start.posY), (double)(c.end.posZ - c.start.posZ)).normalize();
            if (!(conVec.distanceTo(vec) < lineVec.distanceTo(vec))) continue;
            line = c;
        }
        if (line == null) {
            this.setDead();
            return;
        }
        ChunkCoordinates cc0 = line.end == this.target ? line.start : line.end;
        ChunkCoordinates cc1 = line.end == this.target ? line.end : line.start;
        IImmersiveConnectable iicStart = Utils.toIIC(cc1, this.worldObj);
        IImmersiveConnectable iicEnd = Utils.toIIC(cc0, this.worldObj);
        Vec3 vStart = Vec3.createVectorHelper((double)cc1.posX, (double)cc1.posY, (double)cc1.posZ);
        Vec3 vEnd = Vec3.createVectorHelper((double)cc0.posX, (double)cc0.posY, (double)cc0.posZ);
        if (iicStart != null) {
            vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(this.connection));
        }
        if (iicEnd != null) {
            vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(this.connection));
        }
        Vec3[] steps = SkylineHelper.getConnectionCatenary(this.connection, vStart, vEnd);
        Vec3 moveVec = SkylineHelper.getSubMovementVector(vStart, steps[0], 3.0f);
        this.setPosition(vStart.xCoord, vStart.yCoord, vStart.zCoord);
        this.connection = line;
        this.target = cc0;
        this.subPoints = steps;
        this.targetPoint = 0;
        this.motionX = moveVec.xCoord;
        this.motionY = moveVec.yCoord;
        this.motionZ = moveVec.zCoord;
    }
}

