/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityRevolvershotHoming
extends EntityRevolvershot {
    public int trackCountdown = 5;
    public double redirectionSpeed = 0.25;
    EntityLivingBase targetOverride;

    public EntityRevolvershotHoming(World world) {
        super(world);
    }

    public EntityRevolvershotHoming(World world, double x, double y, double z, double ax, double ay, double az, int type) {
        super(world, x, y, z, ax, ay, az, type);
    }

    public EntityRevolvershotHoming(World world, EntityLivingBase living, double ax, double ay, double az, int type, ItemStack stack) {
        super(world, living, ax, ay, az, type, stack);
    }

    @Override
    public void onUpdate() {
        EntityLivingBase target;
        super.onUpdate();
        if (!this.worldObj.isRemote && this.ticksExisted > this.trackCountdown && (target = this.getTarget()) != null) {
            Vec3 newMotion = Vec3.createVectorHelper((double)(this.motionX * (1.0 - this.redirectionSpeed) + (target.posX - this.posX) * this.redirectionSpeed), (double)(this.motionY * (1.0 - this.redirectionSpeed) + (target.posY + (double)(target.height / 2.0f) - this.posY) * this.redirectionSpeed), (double)(this.motionZ * (1.0 - this.redirectionSpeed) + (target.posZ - this.posZ) * this.redirectionSpeed)).normalize();
            this.motionX = newMotion.xCoord;
            this.motionY = newMotion.yCoord;
            this.motionZ = newMotion.zCoord;
        }
    }

    public EntityLivingBase getTarget() {
        if (this.targetOverride != null && !this.targetOverride.isDead) {
            return this.targetOverride;
        }
        double r = 20.0;
        AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)(this.posX - r), (double)(this.posY - r), (double)(this.posZ - r), (double)(this.posX + r), (double)(this.posY + r), (double)(this.posZ + r));
        EntityLivingBase target = null;
        for (Object o : this.worldObj.getEntitiesWithinAABB(EntityLivingBase.class, aabb)) {
            if (!(o instanceof EntityLivingBase) || o.equals(this.shootingEntity) || target != null && !(((EntityLivingBase)o).getDistanceSqToEntity((Entity)this) < target.getDistanceSqToEntity((Entity)this))) continue;
            target = (EntityLivingBase)o;
        }
        return target;
    }
}

