/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityIEProjectile;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityRailgunShot
extends EntityIEProjectile {
    private ItemStack ammo;
    static final int dataMarker_ammo = 13;
    private RailgunHandler.RailgunProjectileProperties ammoProperties;

    public EntityRailgunShot(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
    }

    public EntityRailgunShot(World world, double x, double y, double z, double ax, double ay, double az, ItemStack ammo) {
        super(world, x, y, z, ax, ay, az);
        this.setSize(0.5f, 0.5f);
        this.ammo = ammo;
        this.setAmmoSynced();
    }

    public EntityRailgunShot(World world, EntityLivingBase living, double ax, double ay, double az, ItemStack ammo) {
        super(world, living, ax, ay, az);
        this.setSize(0.5f, 0.5f);
        this.ammo = ammo;
        this.setAmmoSynced();
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObjectByDataType(13, 5);
    }

    public void setAmmoSynced() {
        if (this.getAmmo() != null) {
            this.dataWatcher.updateObject(13, (Object)this.getAmmo());
        }
    }

    public ItemStack getAmmoSynced() {
        return this.dataWatcher.getWatchableObjectItemStack(13);
    }

    public ItemStack getAmmo() {
        return this.ammo;
    }

    public RailgunHandler.RailgunProjectileProperties getAmmoProperties() {
        if (this.ammoProperties == null && this.ammo != null) {
            this.ammoProperties = RailgunHandler.getProjectileProperties(this.ammo);
        }
        return this.ammoProperties;
    }

    @Override
    public double getGravity() {
        return 0.005 * (this.getAmmoProperties() != null ? this.getAmmoProperties().gravity : 1.0);
    }

    @Override
    public int getMaxTicksInGround() {
        return 500;
    }

    public void onEntityUpdate() {
        if (this.getAmmo() == null && this.worldObj.isRemote) {
            this.ammo = this.getAmmoSynced();
        }
        super.onEntityUpdate();
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote && this.getAmmo() != null && mop.entityHit != null && this.getAmmoProperties() != null && !this.getAmmoProperties().overrideHitEntity(mop.entityHit, this.getShooter())) {
            mop.entityHit.attackEntityFrom(IEDamageSources.causeRailgunDamage(this, this.getShooter()), (float)(this.getAmmoProperties().damage * Config.getDouble("railgun_damage_multiplier")));
        }
    }

    @Override
    public void onCollideWithPlayer(EntityPlayer player) {
        if (!this.worldObj.isRemote && this.inGround && this.getAmmo() != null && player.inventory.addItemStackToInventory(this.getAmmo().copy())) {
            this.playSound("random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.setDead();
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        if (this.ammo != null) {
            nbt.setTag("ammo", (NBTBase)this.ammo.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.ammo = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("ammo"));
    }
}

