/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class EntityIEProjectile
extends EntityArrow {
    protected int blockX = -1;
    protected int blockY = -1;
    protected int blockZ = -1;
    protected Block inBlock;
    protected int inMeta;
    protected boolean inGround;
    protected int ticksInGround;
    protected int ticksInAir;
    private int tickLimit = 40;
    static final int dataMarker_shooter = 12;

    public EntityIEProjectile(World world) {
        super(world);
        this.renderDistanceWeight = 10.0;
        this.setSize(0.125f, 0.125f);
    }

    public EntityIEProjectile(World world, double x, double y, double z, double ax, double ay, double az) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(x, y, z, this.rotationYaw, this.rotationPitch);
        this.setPosition(x, y, z);
    }

    public EntityIEProjectile(World world, EntityLivingBase living, double ax, double ay, double az) {
        super(world);
        this.setSize(0.125f, 0.125f);
        this.setLocationAndAngles(living.posX, living.posY + (double)living.getEyeHeight(), living.posZ, living.rotationYaw, living.rotationPitch);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionZ = 0.0;
        this.motionY = 0.0;
        this.motionX = 0.0;
        this.motionX = ax;
        this.motionY = ay;
        this.motionZ = az;
        this.shootingEntity = living;
        this.setShooterSynced();
        this.yOffset = 0.0f;
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, 3.0f, 1.0f);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(12, (Object)"");
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.dataWatcher.updateObject(12, (Object)this.shootingEntity.getCommandSenderName());
    }

    public EntityLivingBase getShooterSynced() {
        return this.worldObj.getPlayerEntityByName(this.dataWatcher.getWatchableObjectString(12));
    }

    public Entity getShooter() {
        return this.shootingEntity;
    }

    public void onUpdate() {
        if (this.getShooter() == null && this.worldObj.isRemote) {
            this.shootingEntity = this.getShooterSynced();
        }
        this.onEntityUpdate();
        Block block = this.worldObj.getBlock(this.blockX, this.blockY, this.blockZ);
        if (block.getMaterial() != Material.air) {
            block.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.blockX, this.blockY, this.blockZ);
            AxisAlignedBB aabb = block.getCollisionBoundingBoxFromPool(this.worldObj, this.blockX, this.blockY, this.blockZ);
            if (aabb != null && aabb.isVecInside(Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            if (this.worldObj.getBlock(this.blockX, this.blockY, this.blockZ) == this.inBlock && this.worldObj.getBlockMetadata(this.blockX, this.blockY, this.blockZ) == this.inMeta) {
                ++this.ticksInGround;
                if (this.ticksInGround >= this.getMaxTicksInGround()) {
                    this.setDead();
                }
            } else {
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            ++this.ticksInAir;
            if (this.ticksInAir >= this.tickLimit) {
                this.setDead();
                return;
            }
            Vec3 currentPos = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            Vec3 nextPos = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            MovingObjectPosition movingobjectposition = this.worldObj.func_147447_a(currentPos, nextPos, false, true, false);
            currentPos = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
            nextPos = movingobjectposition != null ? Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord) : Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
            if (movingobjectposition == null || movingobjectposition.entityHit == null) {
                Entity entity = null;
                List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
                double d0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double d1;
                    float f;
                    AxisAlignedBB axisalignedbb;
                    MovingObjectPosition movingobjectposition1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.canBeCollidedWith() || entity1.isEntityEqual(this.shootingEntity) && this.ticksInAir <= 5 || (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand((double)(f = 0.3f), (double)f, (double)f)).calculateIntercept(currentPos, nextPos)) == null || !((d1 = currentPos.distanceTo(movingobjectposition1.hitVec)) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    movingobjectposition = new MovingObjectPosition(entity);
                }
            }
            if (movingobjectposition != null) {
                if (!this.isBurning() && this.canIgnite() && movingobjectposition.entityHit != null && movingobjectposition.entityHit.isBurning()) {
                    this.setFire(3);
                }
                if (movingobjectposition.entityHit instanceof EntityLivingBase) {
                    this.onImpact(movingobjectposition);
                    this.setDead();
                } else if (movingobjectposition.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
                    this.onImpact(movingobjectposition);
                    this.blockX = movingobjectposition.blockX;
                    this.blockY = movingobjectposition.blockY;
                    this.blockZ = movingobjectposition.blockZ;
                    this.inBlock = this.worldObj.getBlock(this.blockX, this.blockY, this.blockZ);
                    this.inMeta = this.worldObj.getBlockMetadata(this.blockX, this.blockY, this.blockZ);
                    this.motionX = movingobjectposition.hitVec.xCoord - this.posX;
                    this.motionY = movingobjectposition.hitVec.yCoord - this.posY;
                    this.motionZ = movingobjectposition.hitVec.zCoord - this.posZ;
                    float f2 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ));
                    this.posX -= this.motionX / (double)f2 * (double)0.05f;
                    this.posY -= this.motionY / (double)f2 * (double)0.05f;
                    this.posZ -= this.motionZ / (double)f2 * (double)0.05f;
                    this.inGround = true;
                    if (this.inBlock.getMaterial() != Material.air) {
                        this.inBlock.onEntityCollidedWithBlock(this.worldObj, this.blockX, this.blockY, this.blockZ, (Entity)this);
                    }
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float motion = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, motion) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float movementDecay = this.getMotionDecayFactor();
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f3, this.posY - this.motionY * (double)f3, this.posZ - this.motionZ * (double)f3, this.motionX, this.motionY, this.motionZ);
                }
                movementDecay *= 0.8f;
            }
            this.motionX *= (double)movementDecay;
            this.motionY *= (double)movementDecay;
            this.motionZ *= (double)movementDecay;
            this.motionY -= this.getGravity();
            this.setPosition(this.posX, this.posY, this.posZ);
            this.func_145775_I();
        }
    }

    public void onCollideWithPlayer(EntityPlayer p_70100_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double p_70112_1_) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    public abstract void onImpact(MovingObjectPosition var1);

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setShort("xTile", (short)this.blockX);
        nbt.setShort("yTile", (short)this.blockY);
        nbt.setShort("zTile", (short)this.blockZ);
        nbt.setByte("inTile", (byte)Block.getIdFromBlock((Block)this.inBlock));
        nbt.setByte("inMeta", (byte)this.inMeta);
        nbt.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        if (this.shootingEntity != null) {
            nbt.setString("shootingEntity", this.shootingEntity.getCommandSenderName());
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.blockX = nbt.getShort("xTile");
        this.blockY = nbt.getShort("yTile");
        this.blockZ = nbt.getShort("zTile");
        this.inBlock = Block.getBlockById((int)(nbt.getByte("inTile") & 0xFF));
        boolean bl = this.inGround = nbt.getByte("inGround") == 1;
        if (this.worldObj != null) {
            this.shootingEntity = this.worldObj.getPlayerEntityByName(nbt.getString("shootingEntity"));
        }
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }
}

