/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDynamo;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWindmill
extends TileEntityIEBase {
    public int facing = 2;
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;
    public float turnSpeed = 0.0f;
    public boolean canTurn = false;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void updateEntity() {
        if (this.worldObj.getTotalWorldTime() % 128L == (long)((this.xCoord ^ this.zCoord) & 0x7F)) {
            this.canTurn = this.checkArea();
        }
        if (!this.canTurn) {
            return;
        }
        double mod = 5.0E-5;
        if (!this.worldObj.isRaining()) {
            mod *= 0.75;
        }
        if (!this.worldObj.isThundering()) {
            mod *= 0.66;
        }
        if (this.yCoord > 200) {
            mod *= 2.0;
        } else if (this.yCoord > 150) {
            mod *= 1.5;
        } else if (this.yCoord > 100) {
            mod *= 1.25;
        } else if (this.yCoord < 70) {
            mod *= 0.33;
        }
        this.prevRotation = (float)((double)this.turnSpeed * (mod *= (double)this.getSpeedModifier()));
        this.rotation = (float)((double)this.rotation + (double)this.turnSpeed * mod);
        this.rotation %= 1.0f;
        if (!this.worldObj.isRemote) {
            ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
            TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord - fd.offsetX, this.yCoord - fd.offsetY, this.zCoord - fd.offsetZ);
            if (tileEntity instanceof TileEntityDynamo) {
                TileEntityDynamo dynamo = (TileEntityDynamo)tileEntity;
                if ((this.facing == 2 || this.facing == 3) && dynamo.facing != 2 && dynamo.facing != 3) {
                    return;
                }
                if ((this.facing == 4 || this.facing == 5) && dynamo.facing != 4 && dynamo.facing != 5) {
                    return;
                }
                double power = (double)this.turnSpeed * mod * 400.0;
                dynamo.inputRotation(Math.abs(power), ForgeDirection.OPPOSITES[this.facing]);
            }
        }
    }

    protected float getSpeedModifier() {
        return 0.5f;
    }

    public boolean checkArea() {
        this.turnSpeed = 0.0f;
        for (int hh = -6; hh <= 6; ++hh) {
            int r = Math.abs(hh) == 6 ? 1 : (Math.abs(hh) == 5 ? 3 : (Math.abs(hh) == 4 ? 4 : (Math.abs(hh) > 1 ? 5 : 6)));
            for (int ww = -r; ww <= r; ++ww) {
                if (hh == 0 && ww == 0 || this.worldObj.isAirBlock(this.xCoord + (this.facing <= 3 ? ww : 0), this.yCoord + hh, this.zCoord + (this.facing <= 3 ? 0 : ww))) continue;
                return false;
            }
        }
        int blocked = 0;
        for (int hh = -6; hh <= 6; ++hh) {
            int r = Math.abs(hh) == 6 ? 1 : (Math.abs(hh) == 5 ? 3 : (Math.abs(hh) == 4 ? 4 : (Math.abs(hh) > 1 ? 5 : 6)));
            for (int ww = -r; ww <= r; ++ww) {
                for (int dd = 1; dd < 8; ++dd) {
                    int zz;
                    int yy;
                    int xx = this.xCoord + (this.facing <= 3 ? ww : 0) + (this.facing == 4 ? -dd : (this.facing == 5 ? dd : 0));
                    if (this.worldObj.isAirBlock(xx, yy = this.yCoord + hh, zz = this.zCoord + (this.facing <= 3 ? 0 : ww) + (this.facing == 2 ? -dd : (this.facing == 3 ? dd : 0)))) {
                        this.turnSpeed += 1.0f;
                        continue;
                    }
                    if (this.worldObj.getTileEntity(xx, yy, zz) instanceof TileEntityWindmill) {
                        blocked += 20;
                        this.turnSpeed -= 179.0f;
                        continue;
                    }
                    ++blocked;
                    this.turnSpeed -= 2.0f;
                }
            }
            if (blocked <= 100) continue;
            return false;
        }
        return !(this.turnSpeed <= 0.0f);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = nbt.getInteger("facing");
        this.rotation = nbt.getFloat("rotation");
        this.turnSpeed = nbt.getFloat("turnSpeed");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing);
        nbt.setFloat("rotation", this.rotation);
        nbt.setFloat("turnSpeed", this.turnSpeed);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing <= 3 ? 6 : 0)), (double)(this.yCoord - 6), (double)(this.zCoord - (this.facing <= 3 ? 0 : 6)), (double)(this.xCoord + (this.facing <= 3 ? 7 : 0)), (double)(this.yCoord + 7), (double)(this.zCoord + (this.facing <= 3 ? 0 : 7)));
        }
        return this.renderAABB;
    }

    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }
}

