/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDynamo;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityWatermill
extends TileEntityIEBase {
    public int facing = 2;
    public int[] offset = new int[]{0, 0};
    public float rotation = 0.0f;
    private Vec3 rotationVec = null;
    public boolean canTurn = false;
    public boolean multiblock = false;
    public float prevRotation = 0.0f;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void updateEntity() {
        if (this.offset[0] != 0 || this.offset[1] != 0) {
            return;
        }
        if (this.isBlocked()) {
            this.canTurn = false;
            return;
        }
        boolean bl = this.canTurn = this.getRotationVec().lengthVector() != 0.0;
        if (!this.multiblock && this.worldObj.getTotalWorldTime() % 256L == (long)((this.xCoord ^ this.zCoord) & 0xFF)) {
            this.rotationVec = null;
        }
        this.prevRotation = this.rotation;
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        if (this.worldObj.getTileEntity(this.xCoord - fd.offsetX, this.yCoord, this.zCoord - fd.offsetZ) instanceof TileEntityDynamo && !this.multiblock) {
            double power = this.getPower();
            int l = 1;
            TileEntity tileEntity = this.worldObj.getTileEntity(this.xCoord + fd.offsetX * l, this.yCoord, this.zCoord + fd.offsetZ * l);
            while (l < 3 && this.canUse(tileEntity)) {
                power += ((TileEntityWatermill)tileEntity).getPower();
                tileEntity = this.worldObj.getTileEntity(this.xCoord + fd.offsetX * ++l, this.yCoord, this.zCoord + fd.offsetZ * l);
            }
            double perTick = 6.944444612599909E-4 * power / (double)l;
            this.canTurn = perTick != 0.0;
            this.rotation = (float)((double)this.rotation + perTick);
            this.rotation %= 1.0f;
            for (int l2 = 1; l2 < l; ++l2) {
                tileEntity = this.worldObj.getTileEntity(this.xCoord + fd.offsetX * l2, this.yCoord, this.zCoord + fd.offsetZ * l2);
                if (!(tileEntity instanceof TileEntityWatermill)) continue;
                ((TileEntityWatermill)tileEntity).rotation = this.rotation;
                ((TileEntityWatermill)tileEntity).canTurn = this.canTurn;
                ((TileEntityWatermill)tileEntity).multiblock = true;
            }
            if (!this.worldObj.isRemote) {
                TileEntityDynamo dynamo = (TileEntityDynamo)this.worldObj.getTileEntity(this.xCoord - fd.offsetX, this.yCoord - fd.offsetY, this.zCoord - fd.offsetZ);
                if ((this.facing == 2 || this.facing == 3) && dynamo.facing != 2 && dynamo.facing != 3) {
                    return;
                }
                if ((this.facing == 4 || this.facing == 5) && dynamo.facing != 4 && dynamo.facing != 5) {
                    return;
                }
                dynamo.inputRotation(Math.abs(power * 0.75), ForgeDirection.OPPOSITES[this.facing]);
            }
        } else if (!this.multiblock) {
            double perTick = 6.944444612599909E-4 * this.getPower();
            this.canTurn = perTick != 0.0;
            this.rotation = (float)((double)this.rotation + perTick);
            this.rotation %= 1.0f;
        }
        if (this.multiblock) {
            this.multiblock = false;
        }
    }

    private boolean canUse(TileEntity tileEntity) {
        if (!(tileEntity instanceof TileEntityWatermill)) {
            return false;
        }
        TileEntityWatermill wm = (TileEntityWatermill)tileEntity;
        return wm.offset[0] == 0 && wm.offset[1] == 0 && (wm.facing == this.facing || wm.facing == ForgeDirection.OPPOSITES[this.facing]) && !wm.isBlocked() && !wm.multiblock;
    }

    public boolean isBlocked() {
        for (ForgeDirection fdY : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN}) {
            ForgeDirection[] forgeDirectionArray;
            if (this.facing <= 3) {
                ForgeDirection[] forgeDirectionArray2 = new ForgeDirection[2];
                forgeDirectionArray2[0] = ForgeDirection.EAST;
                forgeDirectionArray = forgeDirectionArray2;
                forgeDirectionArray2[1] = ForgeDirection.WEST;
            } else {
                ForgeDirection[] forgeDirectionArray3 = new ForgeDirection[2];
                forgeDirectionArray3[0] = ForgeDirection.SOUTH;
                forgeDirectionArray = forgeDirectionArray3;
                forgeDirectionArray3[1] = ForgeDirection.NORTH;
            }
            for (ForgeDirection fdW : forgeDirectionArray) {
                Block b = this.worldObj.getBlock(this.xCoord + fdW.offsetX * 2, this.yCoord + fdY.offsetY * 2, this.zCoord + fdW.offsetZ * 2);
                if (b.isSideSolid((IBlockAccess)this.worldObj, this.xCoord + fdW.offsetX * 2, this.yCoord + fdY.offsetY * 2, this.zCoord + fdW.offsetZ * 2, fdW.getOpposite())) {
                    return true;
                }
                if (!b.isSideSolid((IBlockAccess)this.worldObj, this.xCoord + fdW.offsetX * 2, this.yCoord + fdY.offsetY * 2, this.zCoord + fdW.offsetZ * 2, fdY.getOpposite())) continue;
                return true;
            }
        }
        return false;
    }

    public double getPower() {
        return this.facing <= 3 ? -this.getRotationVec().xCoord : this.getRotationVec().zCoord;
    }

    public void resetRotationVec() {
        this.rotationVec = null;
    }

    public Vec3 getRotationVec() {
        if (this.rotationVec == null) {
            this.rotationVec = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
            this.rotationVec = Utils.addVectors(this.rotationVec, this.getHorizontalVec());
            this.rotationVec = Utils.addVectors(this.rotationVec, this.getVerticalVec());
        }
        return this.rotationVec;
    }

    Vec3 getHorizontalVec() {
        Vec3 dir = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 1 : 0), this.yCoord + 3, this.zCoord - (this.facing <= 3 ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.worldObj, this.xCoord, this.yCoord + 3, this.zCoord));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 1 : 0), this.yCoord + 3, this.zCoord + (this.facing <= 3 ? 0 : 1)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 2 : 0), this.yCoord + 2, this.zCoord - (this.facing <= 3 ? 0 : 2)));
        dir = Utils.addVectors(dir, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 2 : 0), this.yCoord + 2, this.zCoord + (this.facing <= 3 ? 0 : 2)));
        dir = Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 2 : 0), this.yCoord - 2, this.zCoord - (this.facing <= 3 ? 0 : 2)).subtract(dir);
        dir = Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 2 : 0), this.yCoord - 2, this.zCoord + (this.facing <= 3 ? 0 : 2)).subtract(dir);
        dir = Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 1 : 0), this.yCoord - 3, this.zCoord - (this.facing <= 3 ? 0 : 1)).subtract(dir);
        dir = Utils.getFlowVector(this.worldObj, this.xCoord, this.yCoord - 3, this.zCoord).subtract(dir);
        dir = Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 1 : 0), this.yCoord - 3, this.zCoord + (this.facing <= 3 ? 0 : 1)).subtract(dir);
        return dir;
    }

    Vec3 getVerticalVec() {
        Vec3 dir = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        Vec3 dirNeg = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 2 : 0), this.yCoord + 2, this.zCoord - (this.facing <= 3 ? 0 : 2)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 3 : 0), this.yCoord + 1, this.zCoord - (this.facing <= 3 ? 0 : 3)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 3 : 0), this.yCoord + 0, this.zCoord - (this.facing <= 3 ? 0 : 3)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 3 : 0), this.yCoord - 1, this.zCoord - (this.facing <= 3 ? 0 : 3)));
        dirNeg = Utils.addVectors(dirNeg, Utils.getFlowVector(this.worldObj, this.xCoord - (this.facing <= 3 ? 2 : 0), this.yCoord - 2, this.zCoord - (this.facing <= 3 ? 0 : 2)));
        Vec3 dirPos = Vec3.createVectorHelper((double)0.0, (double)0.0, (double)0.0);
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 2 : 0), this.yCoord + 2, this.zCoord + (this.facing <= 3 ? 0 : 2)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 3 : 0), this.yCoord + 1, this.zCoord + (this.facing <= 3 ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 3 : 0), this.yCoord + 0, this.zCoord + (this.facing <= 3 ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 3 : 0), this.yCoord - 1, this.zCoord + (this.facing <= 3 ? 0 : 3)));
        dirPos = Utils.addVectors(dirPos, Utils.getFlowVector(this.worldObj, this.xCoord + (this.facing <= 3 ? 2 : 0), this.yCoord - 2, this.zCoord + (this.facing <= 3 ? 0 : 2)));
        if (this.facing <= 3) {
            dir.xCoord += dirNeg.yCoord;
            dir.xCoord -= dirPos.yCoord;
        } else {
            dir.zCoord += dirNeg.yCoord;
            dir.zCoord -= dirPos.yCoord;
        }
        return dir;
    }

    public static boolean _Immovable() {
        return true;
    }

    public boolean receiveClientEvent(int id, int arg) {
        this.rotationVec = Vec3.createVectorHelper((double)((float)id / 10000.0f), (double)0.0, (double)((float)arg / 10000.0f));
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.facing = nbt.getInteger("facing");
        this.prevRotation = nbt.getFloat("prevRotation");
        this.offset = nbt.getIntArray("offset");
        this.rotation = nbt.getFloat("rotation");
        if (this.offset == null || this.offset.length < 2) {
            this.offset = new int[]{0, 0};
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setInteger("facing", this.facing);
        nbt.setFloat("prevRotation", this.prevRotation);
        nbt.setIntArray("offset", this.offset);
        nbt.setFloat("rotation", this.rotation);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.offset[0] == 0 && this.offset[1] == 0 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing <= 3 ? 2 : 0)), (double)(this.yCoord - 2), (double)(this.zCoord - (this.facing <= 3 ? 0 : 2)), (double)(this.xCoord + (this.facing <= 3 ? 3 : 0)), (double)(this.yCoord + 3), (double)(this.zCoord + (this.facing <= 3 ? 0 : 3))) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }
}

