/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBlastFurnacePreheater;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBlastFurnaceAdvanced
extends TileEntityBlastFurnace {
    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote && this.worldObj.getTotalWorldTime() % 8L == 0L && this.master() == null) {
            TileEntity inventoryFront = this.worldObj.getTileEntity(this.xCoord + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : 0)), this.yCoord - 1, this.zCoord + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : 0)));
            if (this.getStackInSlot(2) != null) {
                ItemStack stack = this.getStackInSlot(2);
                if (inventoryFront instanceof ISidedInventory && ((ISidedInventory)inventoryFront).getAccessibleSlotsFromSide(ForgeDirection.OPPOSITES[this.facing]).length > 0 || inventoryFront instanceof IInventory && ((IInventory)inventoryFront).getSizeInventory() > 0) {
                    stack = Utils.insertStackIntoInventory((IInventory)inventoryFront, stack, ForgeDirection.OPPOSITES[this.facing]);
                }
                this.setInventorySlotContents(2, stack);
            }
            TileEntity inventoryBack = this.worldObj.getTileEntity(this.xCoord + (this.facing == 4 ? 3 : (this.facing == 5 ? -3 : 0)), this.yCoord - 1, this.zCoord + (this.facing == 2 ? 3 : (this.facing == 3 ? -3 : 0)));
            if (this.getStackInSlot(3) != null) {
                ItemStack stack = this.getStackInSlot(3);
                if (inventoryBack instanceof ISidedInventory && ((ISidedInventory)inventoryBack).getAccessibleSlotsFromSide(this.facing).length > 0 || inventoryBack instanceof IInventory && ((IInventory)inventoryBack).getSizeInventory() > 0) {
                    stack = Utils.insertStackIntoInventory((IInventory)inventoryBack, stack, this.facing);
                }
                this.setInventorySlotContents(3, stack);
            }
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos % 9 == 4 || this.pos == 1 || this.pos == 10 || this.pos == 31) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos == 7) {
            xMin = this.facing < 4 ? 0.1875f : 0.0f;
            xMax = this.facing < 4 ? 0.8125f : 1.0f;
            zMin = this.facing > 3 ? 0.1875f : 0.0f;
            zMax = this.facing > 3 ? 0.8125f : 1.0f;
            yMax = 0.8125f;
        } else {
            float indent = 1.0f;
            if (this.pos < 9) {
                indent = this.pos > 2 && this.pos < 6 ? 0.5f : 0.3125f;
            } else if (this.pos < 18) {
                indent = 0.5f;
            } else if (this.pos < 27) {
                indent = 0.375f;
            }
            if (this.pos % 9 < 3 && this.facing == 4 || this.pos % 9 > 5 && this.facing == 5 || this.pos % 3 == 2 && this.facing == 2 || this.pos % 3 == 0 && this.facing == 3) {
                xMin = 1.0f - indent;
            }
            if (this.pos % 9 < 3 && this.facing == 5 || this.pos % 9 > 5 && this.facing == 4 || this.pos % 3 == 2 && this.facing == 3 || this.pos % 3 == 0 && this.facing == 2) {
                xMax = indent;
            }
            if (this.pos % 9 < 3 && this.facing == 2 || this.pos % 9 > 5 && this.facing == 3 || this.pos % 3 == 2 && this.facing == 5 || this.pos % 3 == 0 && this.facing == 4) {
                zMin = 1.0f - indent;
            }
            if (this.pos % 9 < 3 && this.facing == 3 || this.pos % 9 > 5 && this.facing == 2 || this.pos % 3 == 2 && this.facing == 4 || this.pos % 3 == 0 && this.facing == 5) {
                zMax = indent;
            }
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos == 31) {
            return new ItemStack((Block)Blocks.hopper);
        }
        return new ItemStack((Block)IEContent.blockStoneDecoration, 1, 6);
    }

    @Override
    protected int getProcessSpeed() {
        int i = 1;
        TileEntityBlastFurnacePreheater heater = this.getHeater(false);
        if (heater != null) {
            i += heater.doSpeedup();
        }
        if ((heater = this.getHeater(true)) != null) {
            i += heater.doSpeedup();
        }
        return i;
    }

    private TileEntityBlastFurnacePreheater getHeater(boolean first) {
        int zz;
        int xx;
        int w;
        int n = w = first ? -2 : 2;
        int n2 = this.facing == 4 ? 1 : (this.facing == 5 ? -1 : (xx = this.facing == 2 ? -w : w));
        int n3 = this.facing == 2 ? 1 : (this.facing == 3 ? -1 : (zz = this.facing == 4 ? w : -w));
        int phf = this.facing < 4 ? (xx < 0 ? 4 : 5) : (zz < 0 ? 2 : 3);
        TileEntity te = this.worldObj.getTileEntity(this.xCoord + xx, this.yCoord - 1, this.zCoord + zz);
        if (te instanceof TileEntityBlastFurnacePreheater && ((TileEntityBlastFurnacePreheater)te).facing == phf) {
            return (TileEntityBlastFurnacePreheater)te;
        }
        return null;
    }

    @Override
    public String getInventoryName() {
        return "IEBlastFurnaceAdvanced";
    }

    @Override
    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.pos == 31 && side == 1) {
            return new int[]{0, 1};
        }
        if (this.pos == 1 && side == ForgeDirection.OPPOSITES[this.facing]) {
            return new int[]{2};
        }
        if (this.pos == 7 && side == this.facing) {
            return new int[]{3};
        }
        return new int[0];
    }

    @Override
    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.canInsertItem(slot, stack, side);
        }
        return (slot == 0 || slot == 1) && this.isItemValidForSlot(slot, stack);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntityBlastFurnace master = this.master();
        if (master != null) {
            return master.canExtractItem(slot, stack, side);
        }
        return slot == 2 || slot == 3;
    }

    @Override
    public void disassemble() {
        if (this.formed && !this.worldObj.isRemote) {
            int zMin;
            int xMax;
            int xMin;
            int startX = this.xCoord - this.offset[0];
            int startY = this.yCoord - this.offset[1];
            int startZ = this.zCoord - this.offset[2];
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.worldObj.getTileEntity(startX, startY, startZ) instanceof TileEntityBlastFurnaceAdvanced)) {
                return;
            }
            int n = this.facing == 5 ? -2 : (xMin = this.facing == 4 ? 0 : -1);
            int n2 = this.facing == 5 ? 0 : (xMax = this.facing == 4 ? 2 : 1);
            int n3 = this.facing == 3 ? -2 : (zMin = this.facing == 2 ? 0 : -1);
            int zMax = this.facing == 3 ? 0 : (this.facing == 2 ? 2 : 1);
            for (int yy = -1; yy <= 2; ++yy) {
                for (int xx = xMin; xx <= xMax; ++xx) {
                    for (int zz = zMin; zz <= zMax; ++zz) {
                        if (yy == 2 && (xx <= xMin || xx >= xMax || zz <= zMin || zz >= zMax)) continue;
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityBlastFurnaceAdvanced) {
                            s = ((TileEntityBlastFurnaceAdvanced)te).getOriginalBlock();
                            ((TileEntityBlastFurnaceAdvanced)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockStoneDevice) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    @Override
    protected void turnOff() {
        super.turnOff();
        TileEntityBlastFurnacePreheater heater = this.getHeater(false);
        if (heater != null) {
            heater.turnOff();
        }
        if ((heater = this.getHeater(true)) != null) {
            heater.turnOff();
        }
    }
}

