/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.render.BlockRenderStoneDevices;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.stone.ItemBlockStoneDevices;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnace;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityBlastFurnaceAdvanced;
import blusunrize.immersiveengineering.common.blocks.stone.TileEntityCokeOven;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockStoneDevices
extends BlockIEBase {
    IIcon[] iconsCokeOven = new IIcon[10];
    IIcon[] iconsBlastFurnace = new IIcon[2];

    public BlockStoneDevices() {
        super("stoneDevice", Material.rock, 1, ItemBlockStoneDevices.class, "hempcrete", "cokeOven", "blastFurnace", "coalCoke", "insulatorGlass", "blastFurnaceAdvanced");
        this.setHardness(2.0f);
        this.setResistance(20.0f);
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 4));
    }

    public int getRenderType() {
        return BlockRenderStoneDevices.renderID;
    }

    public boolean canRenderInPass(int pass) {
        BlockRenderStoneDevices.renderPass = pass;
        return true;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (metadata == 1 || metadata == 2 || metadata == 5) {
            return new ArrayList<ItemStack>();
        }
        return super.getDrops(world, x, y, z, metadata, fortune);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getOriginalBlock(world, x, y, z);
    }

    public ItemStack getOriginalBlock(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityMultiblockPart) {
            return ((TileEntityMultiblockPart)te).getOriginalBlock();
        }
        return new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z));
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityMultiblockPart) {
            float[] bounds = ((TileEntityMultiblockPart)te).getBlockBounds();
            if (bounds != null && bounds.length > 5) {
                this.setBlockBounds(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
            } else {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        int i;
        for (i = 0; i < this.icons.length; ++i) {
            this.icons[i][0] = iconRegister.registerIcon("immersiveengineering:" + this.name + "_" + this.subNames[i]);
        }
        for (i = 0; i < 9; ++i) {
            this.iconsCokeOven[i] = iconRegister.registerIcon("immersiveengineering:" + this.name + "_cokeOven" + i + (i == 4 ? "off" : ""));
        }
        this.iconsCokeOven[9] = iconRegister.registerIcon("immersiveengineering:" + this.name + "_cokeOven4on");
        this.iconsBlastFurnace[0] = iconRegister.registerIcon("immersiveengineering:" + this.name + "_blastFurnace_off");
        this.iconsBlastFurnace[1] = iconRegister.registerIcon("immersiveengineering:" + this.name + "_blastFurnace_on");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityCokeOven && ((TileEntityCokeOven)te).formed) {
            TileEntityCokeOven teco = (TileEntityCokeOven)te;
            if (teco.master() == null) {
                return this.iconsCokeOven[teco.active ? 9 : 4];
            }
            if (side != teco.facing) {
                return super.getIcon(world, x, y, z, side);
            }
            int[] off = teco.offset;
            int pos = (1 - off[1]) * 3 + (teco.facing == 2 ? 1 - off[0] : (teco.facing == 3 ? off[0] + 1 : (teco.facing == 5 ? 1 - off[2] : off[2] + 1)));
            return this.iconsCokeOven[pos];
        }
        if (te instanceof TileEntityBlastFurnace && ((TileEntityBlastFurnace)te).formed) {
            int[] off = ((TileEntityBlastFurnace)te).offset;
            if (off[1] != 0) {
                return super.getIcon(world, x, y, z, side);
            }
            TileEntityBlastFurnace tebf = (TileEntityBlastFurnace)te;
            if (tebf.master() == null) {
                return this.iconsBlastFurnace[tebf.active ? 1 : 0];
            }
        }
        return super.getIcon(world, x, y, z, side);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity curr = world.getTileEntity(x, y, z);
        if (curr instanceof TileEntityCokeOven && !player.isSneaking() && ((TileEntityCokeOven)curr).formed) {
            TileEntityCokeOven te = ((TileEntityCokeOven)curr).master();
            if (te == null) {
                te = (TileEntityCokeOven)curr;
            }
            if (!world.isRemote) {
                player.openGui((Object)ImmersiveEngineering.instance, 0, world, te.xCoord, te.yCoord, te.zCoord);
            }
            return true;
        }
        if (curr instanceof TileEntityBlastFurnace && !player.isSneaking() && ((TileEntityBlastFurnace)curr).formed) {
            TileEntityBlastFurnace te = ((TileEntityBlastFurnace)curr).master();
            if (te == null) {
                te = (TileEntityBlastFurnace)curr;
            }
            if (!world.isRemote) {
                player.openGui((Object)ImmersiveEngineering.instance, 1, world, te.xCoord, te.yCoord, te.zCoord);
            }
            return true;
        }
        return false;
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityMultiblockPart && tileEntity instanceof IInventory && world.getGameRules().getGameRuleBooleanValue("doTileDrops") && !world.isRemote && ((TileEntityMultiblockPart)tileEntity).formed) {
            TileEntityMultiblockPart master = ((TileEntityMultiblockPart)tileEntity).master();
            if (master == null) {
                master = tileEntity;
            }
            for (int i = 0; i < ((IInventory)master).getSizeInventory(); ++i) {
                ItemStack stack = ((IInventory)master).getStackInSlot(i);
                if (stack == null) continue;
                float fx = world.rand.nextFloat() * 0.8f + 0.1f;
                float fz = world.rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)x + fx), (double)y + 0.5, (double)((float)z + fz), stack);
                entityitem.motionX = world.rand.nextGaussian() * 0.05;
                entityitem.motionY = world.rand.nextGaussian() * 0.05 + 0.2;
                entityitem.motionZ = world.rand.nextGaussian() * 0.05;
                if (stack.hasTagCompound()) {
                    entityitem.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                }
                world.spawnEntityInWorld((Entity)entityitem);
            }
        }
    }

    public boolean hasTileEntity(int meta) {
        return meta == 1 || meta == 2 || meta == 5;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 1: {
                return new TileEntityCokeOven();
            }
            case 2: {
                return new TileEntityBlastFurnace();
            }
            case 5: {
                return new TileEntityBlastFurnaceAdvanced();
            }
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(int metadata) {
        return false;
    }
}

