/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySqueezer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MultiblockSqueezer
implements MultiblockHandler.IMultiblock {
    public static MultiblockSqueezer instance = new MultiblockSqueezer();
    static ItemStack[][][] structure = new ItemStack[3][3][3];

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        RenderBlocks rb = RenderBlocks.getInstance();
        Tessellator.instance.startDrawingQuads();
        rb.setRenderBounds(-1.5, -1.5, -1.5, 1.5, 1.5, 1.5);
        BlockIEBase b = IEContent.blockMetalMultiblocks;
        ClientUtils.bindAtlas(0);
        rb.renderFaceYNeg((Block)b, 0.0, 0.0, 0.0, b.icons[2][1]);
        rb.renderFaceYPos((Block)b, 0.0, 0.0, 0.0, b.icons[2][1]);
        rb.renderFaceXNeg((Block)b, 0.0, 0.0, 0.0, b.icons[2][2]);
        rb.renderFaceXPos((Block)b, 0.0, 0.0, 0.0, b.icons[2][2]);
        rb.renderFaceZNeg((Block)b, 0.0, 0.0, 0.0, b.icons[2][3]);
        rb.renderFaceZPos((Block)b, 0.0, 0.0, 0.0, b.icons[2][3]);
        Tessellator.instance.draw();
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public String getUniqueName() {
        return "IE:Squeezer";
    }

    @Override
    public boolean isBlockTrigger(Block b, int meta) {
        return b == IEContent.blockMetalMultiblocks && meta == 2;
    }

    @Override
    public boolean createStructure(World world, int x, int y, int z, int side, EntityPlayer player) {
        int zz;
        int yy;
        int xx;
        int h;
        int w;
        int l;
        if (side == 0 || side == 1) {
            return false;
        }
        int startX = x;
        int startY = y;
        int startZ = z;
        for (l = 0; l < 3; ++l) {
            for (w = -1; w <= 1; ++w) {
                for (h = -1; h <= 1; ++h) {
                    xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -w : w)));
                    yy = startY + h;
                    zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -w : w)));
                    if (!(h == 0 && (w != 0 || l != 1) ? !world.getBlock(xx, yy, zz).equals((Object)IEContent.blockMetalMultiblocks) || world.getBlockMetadata(xx, yy, zz) != 2 : !world.getBlock(xx, yy, zz).equals((Object)IEContent.blockMetalDecoration) || world.getBlockMetadata(xx, yy, zz) != 7)) continue;
                    return false;
                }
            }
        }
        for (l = 0; l < 3; ++l) {
            for (w = -1; w <= 1; ++w) {
                for (h = -1; h <= 1; ++h) {
                    xx = side == 4 ? l : (side == 5 ? -l : (side == 2 ? -w : w));
                    yy = h;
                    int n = side == 2 ? l : (side == 3 ? -l : (zz = side == 5 ? -w : w));
                    if (h == 0 && (w != 0 || l != 1)) {
                        world.markBlockForUpdate(startX + xx, startY + yy, startZ + zz);
                    } else {
                        world.setBlock(startX + xx, startY + yy, startZ + zz, (Block)IEContent.blockMetalMultiblocks, 2, 3);
                    }
                    TileEntity curr = world.getTileEntity(startX + xx, startY + yy, startZ + zz);
                    if (!(curr instanceof TileEntitySqueezer)) continue;
                    TileEntitySqueezer tile = (TileEntitySqueezer)curr;
                    tile.facing = side;
                    tile.formed = true;
                    tile.pos = l * 9 + (h + 1) * 3 + (w + 1);
                    tile.offset = new int[]{side == 4 ? l - 1 : (side == 5 ? 1 - l : (side == 2 ? -w : w)), h, side == 2 ? l - 1 : (side == 3 ? 1 - l : (side == 5 ? -w : w))};
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack((Block)IEContent.blockMetalDecoration, 19, 7), new ItemStack((Block)IEContent.blockMetalMultiblocks, 8, 2)};
    }

    static {
        for (int h = 0; h < 3; ++h) {
            for (int l = 0; l < 3; ++l) {
                for (int w = 0; w < 3; ++w) {
                    MultiblockSqueezer.structure[h][l][w] = h == 1 && (w != 1 || l != 1) ? new ItemStack((Block)IEContent.blockMetalMultiblocks, 1, 2) : new ItemStack((Block)IEContent.blockMetalDecoration, 1, 7);
                }
            }
        }
    }
}

