/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MultiblockRefinery
implements MultiblockHandler.IMultiblock {
    public static MultiblockRefinery instance = new MultiblockRefinery();
    static ItemStack[][][] structure = new ItemStack[3][5][3];
    private static final TileEntityRefinery ref = new TileEntityRefinery();

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        ClientUtils.bindAtlas(0);
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setTranslation(-0.5, -1.5, -0.5);
        ClientUtils.handleStaticTileRenderer(ref, false);
        ClientUtils.tes().setTranslation(0.0, 0.0, 0.0);
        ClientUtils.tes().draw();
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    @Override
    public String getUniqueName() {
        return "IE:Refinery";
    }

    @Override
    public boolean isBlockTrigger(Block b, int meta) {
        return b == IEContent.blockMetalDecoration && meta == 5;
    }

    @Override
    public boolean createStructure(World world, int x, int y, int z, int side, EntityPlayer player) {
        int h;
        int w;
        int l;
        if (side == 0 || side == 1) {
            return false;
        }
        int startX = x;
        int startY = y;
        int startZ = z;
        for (l = 0; l < 3; ++l) {
            for (w = -2; w <= 2; ++w) {
                for (h = -1; h <= 1; ++h) {
                    if (w == 0 && (h == 1 || h == 0 && l == 1)) continue;
                    int m = 5;
                    if (h == -1) {
                        if (l != 1 && w != 0) {
                            m = 1;
                        } else if (w > -2 && w < 2) {
                            m = 7;
                        }
                    } else if (h == 0 && w == 0 && l == 2) {
                        m = 7;
                    } else if (h > -1 && w != 0) {
                        m = 10;
                    }
                    int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -w : w)));
                    int yy = startY + h;
                    int zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -w : w)));
                    if (world.getBlock(xx, yy, zz).equals((Object)IEContent.blockMetalDecoration) && world.getBlockMetadata(xx, yy, zz) == m) continue;
                    return false;
                }
            }
        }
        for (l = 0; l < 3; ++l) {
            for (w = -2; w <= 2; ++w) {
                for (h = -1; h <= 1; ++h) {
                    if (w == 0 && (h == 1 || h == 0 && l == 1)) continue;
                    int xx = side == 4 ? l : (side == 5 ? -l : (side == 2 ? -w : w));
                    int yy = h;
                    int zz = side == 2 ? l : (side == 3 ? -l : (side == 5 ? -w : w));
                    world.setBlock(startX + xx, startY + yy, startZ + zz, (Block)IEContent.blockMetalMultiblocks, 4, 3);
                    TileEntity curr = world.getTileEntity(startX + xx, startY + yy, startZ + zz);
                    if (!(curr instanceof TileEntityRefinery)) continue;
                    TileEntityRefinery tile = (TileEntityRefinery)curr;
                    tile.facing = side;
                    tile.formed = true;
                    tile.pos = l * 15 + (h + 1) * 5 + (w + 2);
                    tile.offset = new int[]{side == 4 ? l - 1 : (side == 5 ? 1 - l : (side == 2 ? -w : w)), h + 1, side == 2 ? l - 1 : (side == 3 ? 1 - l : (side == 5 ? -w : w))};
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack((Block)IEContent.blockMetalDecoration, 8, 1), new ItemStack((Block)IEContent.blockMetalDecoration, 6, 7), new ItemStack((Block)IEContent.blockMetalDecoration, 24, 10), new ItemStack((Block)IEContent.blockMetalDecoration, 3, 5)};
    }

    static {
        MultiblockRefinery.ref.formed = true;
        MultiblockRefinery.ref.pos = 17;
        MultiblockRefinery.ref.facing = 4;
        for (int w = 0; w < 5; ++w) {
            for (int l = 0; l < 3; ++l) {
                for (int h = 0; h < 3; ++h) {
                    if (w == 2 && (h == 2 || h == 1 && l == 1)) continue;
                    int m = 5;
                    if (h == 0) {
                        if (l != 1 && w != 2) {
                            m = 1;
                        } else if (w > 0 && w < 4) {
                            m = 7;
                        }
                    } else if (h == 1 && w == 2 && l == 2) {
                        m = 7;
                    } else if (h > 0 && w != 2) {
                        m = 10;
                    }
                    MultiblockRefinery.structure[h][w][l] = new ItemStack((Block)IEContent.blockMetalDecoration, 1, m);
                }
            }
        }
    }
}

