/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.MultiblockHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.util.IEAchievements;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.RailcraftHelper;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MultiblockArcFurnace
implements MultiblockHandler.IMultiblock {
    public static MultiblockArcFurnace instance = new MultiblockArcFurnace();
    private static final TileEntityArcFurnace furn = new TileEntityArcFurnace();
    static ItemStack[][][] structure = new ItemStack[5][5][5];

    @Override
    public ItemStack[][][] getStructureManual() {
        return structure;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overwriteBlockRender(ItemStack stack, int iterator) {
        if (stack.getItem() == Items.cauldron) {
            ImmersiveEngineering.proxy.draw3DBlockCauldron();
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canRenderFormedStructure() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderFormedStructure() {
        ClientUtils.bindAtlas(0);
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setTranslation(-0.5, -0.5, -0.5);
        ClientUtils.handleStaticTileRenderer(furn, false);
        ClientUtils.tes().setTranslation(0.0, 0.0, 0.0);
        ClientUtils.tes().draw();
    }

    @Override
    public String getUniqueName() {
        return "IE:ArcFurnace";
    }

    @Override
    public boolean isBlockTrigger(Block b, int meta) {
        return b == Blocks.cauldron;
    }

    @Override
    public boolean createStructure(World world, int x, int y, int z, int side, EntityPlayer player) {
        boolean mirrored;
        int startZ;
        int startY;
        int startX;
        boolean b;
        if (side == 0 || side == 1) {
            int f;
            int playerViewQuarter = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
            side = f = playerViewQuarter == 0 ? 2 : (playerViewQuarter == 1 ? 5 : (playerViewQuarter == 2 ? 3 : 4));
        }
        if (!(b = this.structureCheck(world, startX = x + (side == 4 ? 2 : (side == 5 ? -2 : 0)), startY = y + 2, startZ = z + (side == 2 ? 2 : (side == 3 ? -2 : 0)), side, mirrored = false))) {
            mirrored = true;
            b = this.structureCheck(world, startX, startY, startZ, side, mirrored);
        }
        if (b) {
            for (int h = -2; h <= 2; ++h) {
                for (int l = -2; l <= 2; ++l) {
                    for (int w = -2; w <= 2; ++w) {
                        int ww;
                        if (structure[h + 2][w + 2][l + 2] == null) continue;
                        int n = ww = mirrored ? -w : w;
                        int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)));
                        int yy = startY + h;
                        int zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww)));
                        world.setBlock(xx, yy, zz, (Block)IEContent.blockMetalMultiblocks, 8, 3);
                        TileEntity curr = world.getTileEntity(xx, yy, zz);
                        if (!(curr instanceof TileEntityArcFurnace)) continue;
                        TileEntityArcFurnace tile = (TileEntityArcFurnace)curr;
                        tile.facing = side;
                        tile.formed = true;
                        tile.pos = (h + 2) * 25 + (l + 2) * 5 + (w + 2);
                        tile.offset = new int[]{side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)), h, side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww))};
                        tile.mirrored = mirrored;
                    }
                }
            }
            player.triggerAchievement((StatBase)IEAchievements.mbArcFurnace);
        }
        return b;
    }

    boolean structureCheck(World world, int startX, int startY, int startZ, int side, boolean mirror) {
        for (int h = -2; h <= 2; ++h) {
            for (int l = -2; l <= 2; ++l) {
                for (int w = -2; w <= 2; ++w) {
                    int zz;
                    int yy;
                    int ww;
                    if (structure[h + 2][w + 2][l + 2] == null) continue;
                    int n = ww = mirror ? -w : w;
                    int xx = startX + (side == 4 ? l : (side == 5 ? -l : (side == 2 ? -ww : ww)));
                    if (world.isAirBlock(xx, yy = startY + h, zz = startZ + (side == 2 ? l : (side == 3 ? -l : (side == 5 ? -ww : ww))))) {
                        return false;
                    }
                    ItemStack checkStack = new ItemStack(world.getBlock(xx, yy, zz), 1, world.getBlockMetadata(xx, yy, zz));
                    if (OreDictionary.itemMatches((ItemStack)structure[h + 2][w + 2][l + 2], (ItemStack)new ItemStack(Items.cauldron), (boolean)true)) {
                        if (Blocks.cauldron.equals(world.getBlock(xx, yy, zz))) continue;
                        return false;
                    }
                    if (OreDictionary.itemMatches((ItemStack)structure[h + 2][w + 2][l + 2], (ItemStack)new ItemStack((Block)IEContent.blockStorage, 1, 7), (boolean)true)) {
                        if (Utils.compareToOreName(checkStack, "blockSteel")) continue;
                        return false;
                    }
                    if (OreDictionary.itemMatches((ItemStack)structure[h + 2][w + 2][l + 2], (ItemStack)new ItemStack((Block)IEContent.blockStorageSlabs, 1, 7), (boolean)true)) {
                        TileEntity te = world.getTileEntity(xx, yy, zz);
                        if (Loader.isModLoaded((String)"Railcraft") && RailcraftHelper.isRCSlab(te)) {
                            return RailcraftHelper.isSteelSlab(te);
                        }
                        if (Utils.compareToOreName(checkStack, "slabSteel")) continue;
                        return false;
                    }
                    if (OreDictionary.itemMatches((ItemStack)structure[h + 2][w + 2][l + 2], (ItemStack)checkStack, (boolean)true)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ItemStack[] getTotalMaterials() {
        return new ItemStack[]{new ItemStack(Items.cauldron), new ItemStack((Block)IEContent.blockStorageSlabs, 14, 7), new ItemStack((Block)IEContent.blockStorage, 4, 7), new ItemStack((Block)IEContent.blockStoneDecoration, 27, 6), new ItemStack((Block)IEContent.blockMetalDecoration, 14, 7), new ItemStack((Block)IEContent.blockMetalDecoration, 7, 5), new ItemStack((Block)IEContent.blockMetalDecoration, 10, 1)};
    }

    @Override
    public float getManualScale() {
        return 12.0f;
    }

    static {
        MultiblockArcFurnace.furn.formed = true;
        MultiblockArcFurnace.furn.pos = 62;
        MultiblockArcFurnace.furn.facing = 4;
        for (int h = 0; h < 5; ++h) {
            for (int l = 0; l < 5; ++l) {
                for (int w = 0; w < 5; ++w) {
                    int m = -1;
                    if (h == 0) {
                        if (l == 0 && w == 2) {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack(Items.cauldron);
                        } else if (l == 2 && (w == 0 || w == 4)) {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockStorage, 1, 7);
                        } else if (l == 0 && w == 0) {
                            m = 7;
                        } else if (l > 2 && (w == 0 || w == 4)) {
                            m = 1;
                        } else if (l == 4) {
                            m = 5;
                        } else {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockStorageSlabs, 1, 7);
                        }
                    } else if (h == 1) {
                        if (l == 0 && w == 0 || l == 4 && w > 0 && w < 4) {
                            m = 7;
                        } else if (!(w != 0 && w != 4 || l != 2 && l != 4)) {
                            m = 5;
                        } else if ((w == 0 || w == 4) && l == 3) {
                            m = 1;
                        } else if (w > 0 && w < 4 && (l == 2 || l == 3)) {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockStoneDecoration, 1, 6);
                        }
                    } else if (h == 2) {
                        if (l == 4) {
                            m = 7;
                        } else if (l == 2 && (w == 0 || w == 4)) {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockStorage, 1, 7);
                        } else if (w > 0 && w < 4) {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockStoneDecoration, 1, 6);
                        }
                    } else if (h == 3) {
                        if (l == 4 && w == 2) {
                            m = 7;
                        } else if (l == 4 && (w == 1 || w == 3)) {
                            m = 1;
                        } else if (l > 0 && w > 0 && w < 4) {
                            MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockStoneDecoration, 1, 6);
                        }
                    } else if (h == 4) {
                        if (l == 4 && (w == 1 || w == 3)) {
                            m = 1;
                        } else if (l > 1 && w == 2) {
                            m = 7;
                        }
                    }
                    if (m < 0) continue;
                    MultiblockArcFurnace.structure[h][w][l] = new ItemStack((Block)IEContent.blockMetalDecoration, 1, m);
                }
            }
        }
    }
}

