/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityThermoelectricGen
extends TileEntityIEBase
implements IEnergyConnection {
    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            int energy = 0;
            for (ForgeDirection fd : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}) {
                if (this.worldObj.isAirBlock(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ) || this.worldObj.isAirBlock(this.xCoord + fd.getOpposite().offsetX, this.yCoord + fd.getOpposite().offsetY, this.zCoord + fd.getOpposite().offsetZ)) continue;
                int temp0 = this.getTemperature(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
                int temp1 = this.getTemperature(this.xCoord + fd.getOpposite().offsetX, this.yCoord + fd.getOpposite().offsetY, this.zCoord + fd.getOpposite().offsetZ);
                if (temp0 <= -1 || temp1 <= -1) continue;
                int diff = Math.abs(temp0 - temp1);
                energy += (int)(Math.sqrt(diff) / 2.0 * Config.getDouble("thermoelectric_output"));
            }
            this.outputEnergy(energy);
        }
    }

    public void outputEnergy(int amount) {
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
            if (!(te instanceof IEnergyReceiver)) continue;
            amount -= ((IEnergyReceiver)te).receiveEnergy(fd.getOpposite(), amount, false);
        }
    }

    int getTemperature(int x, int y, int z) {
        Fluid f = this.getFluid(x, y, z);
        if (f != null) {
            return f.getTemperature(this.worldObj, x, y, z);
        }
        return ThermoelectricHandler.getTemperature(this.worldObj.getBlock(x, y, z), this.worldObj.getBlockMetadata(x, y, z));
    }

    Fluid getFluid(int x, int y, int z) {
        Block b = this.worldObj.getBlock(x, y, z);
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)b);
        if (f == null && b instanceof BlockDynamicLiquid && this.worldObj.getBlockMetadata(x, y, z) == 0) {
            if (b.getMaterial().equals(Material.water)) {
                f = FluidRegistry.WATER;
            } else if (b.getMaterial().equals(Material.lava)) {
                f = FluidRegistry.LAVA;
            }
        }
        if (b instanceof IFluidBlock && !((IFluidBlock)b).canDrain(this.worldObj, x, y, z)) {
            return null;
        }
        if (b instanceof BlockStaticLiquid && this.worldObj.getBlockMetadata(x, y, z) != 0) {
            return null;
        }
        if (f == null) {
            return null;
        }
        return f;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

