/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockSqueezer;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntitySqueezer
extends TileEntityMultiblockPart
implements IFluidHandler,
ISidedInventory,
IEnergyReceiver {
    public int facing = 2;
    public FluidTank tank = new FluidTank(12000);
    public EnergyStorage energyStorage = new EnergyStorage(32000, Math.max(256, Config.getInt("squeezer_consumption")));
    ItemStack[] inventory = new ItemStack[12];
    public int tick = 0;
    int processMaxTime = 0;

    @Override
    public TileEntitySqueezer master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntitySqueezer ? (TileEntitySqueezer)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (!this.formed) {
            return new ItemStack((Block)IEContent.blockMetalMultiblocks, 1, 2);
        }
        return MultiblockSqueezer.instance.getStructureManual()[this.pos % 9 / 3][this.pos / 9][this.pos % 3].copy();
    }

    @Override
    public float[] getBlockBounds() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 13) {
            return;
        }
        if (!this.worldObj.isRemote) {
            boolean update = false;
            int[] valid = this.getValidInputs();
            int inputs = Math.min(9, valid[0]);
            this.processMaxTime = valid[1];
            if (inputs > 0) {
                int consumed = Config.getInt("squeezer_consumption");
                if (this.energyStorage.extractEnergy(consumed, true) == consumed) {
                    this.energyStorage.extractEnergy(consumed, false);
                    ++this.tick;
                    update = true;
                }
                if (this.tick >= valid[1]) {
                    DieselHandler.SqueezerRecipe recipe = null;
                    for (int i = 0; i < 9; ++i) {
                        DieselHandler.SqueezerRecipe rr;
                        ItemStack stack = this.getStackInSlot(i);
                        if (stack == null || (rr = this.getRecipe(stack)) == null || recipe != null && rr != recipe && !(rr.fluid != null ? rr.fluid.isFluidEqual(recipe.fluid) : recipe.fluid != null && recipe.fluid.isFluidEqual(rr.fluid))) continue;
                        recipe = rr;
                        if (recipe != null) {
                            int recipeInputSize;
                            int n = recipeInputSize = recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).stackSize : 1;
                            int outLimit = recipe.output == null ? 9 : (64 - (this.inventory[11] != null ? this.inventory[11].stackSize : 0)) / recipe.output.stackSize;
                            int fluidLimit = recipe.fluid == null ? 9 : (this.tank.getCapacity() - this.tank.getFluidAmount()) / recipe.fluid.amount;
                            int taken = Math.min(Math.min(inputs, stack.stackSize / recipeInputSize), Math.min(outLimit, fluidLimit));
                            if (taken > 0) {
                                this.decrStackSize(i, taken * recipeInputSize);
                                if (recipe.output != null) {
                                    if (this.inventory[11] != null) {
                                        this.inventory[11].stackSize += taken * recipe.output.copy().stackSize;
                                    } else if (this.inventory[11] == null) {
                                        this.inventory[11] = Utils.copyStackWithAmount(recipe.output, taken * recipe.output.stackSize);
                                    }
                                }
                                if (recipe.fluid != null) {
                                    this.tank.fill(new FluidStack(recipe.fluid, taken * recipe.fluid.amount), true);
                                }
                                inputs -= taken;
                                update = true;
                            }
                        }
                        if (inputs <= 0 || this.tank.getFluidAmount() >= this.tank.getCapacity()) break;
                    }
                    this.tick = 0;
                }
            } else if (this.tick > 0) {
                this.tick = 0;
            }
            if (this.tank.getFluidAmount() > 0 && this.tank.getFluid() != null && (this.inventory[10] == null || this.inventory[10].stackSize + 1 < this.inventory[10].getMaxStackSize())) {
                ItemStack filledContainer = Utils.fillFluidContainer(this.tank, this.inventory[9], this.inventory[10]);
                if (filledContainer != null) {
                    if (this.inventory[10] != null && OreDictionary.itemMatches((ItemStack)this.inventory[10], (ItemStack)filledContainer, (boolean)true)) {
                        this.inventory[10].stackSize += filledContainer.stackSize;
                    } else if (this.inventory[10] == null) {
                        this.inventory[10] = filledContainer.copy();
                    }
                    this.decrStackSize(9, filledContainer.stackSize);
                    update = true;
                }
                if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0) {
                    HashMap<ForgeDirection, IFluidHandler> targets = new HashMap<ForgeDirection, IFluidHandler>(4);
                    for (int f = 2; f < 6; ++f) {
                        ForgeDirection direction = ForgeDirection.getOrientation((int)f);
                        TileEntity te = Utils.getExistingTileEntity(this.worldObj, this.xCoord + direction.offsetX * 2, this.yCoord - 1, this.zCoord + direction.offsetZ * 2);
                        if (!(te instanceof IFluidHandler) || !((IFluidHandler)te).canFill(direction.getOpposite(), this.tank.getFluid().getFluid())) continue;
                        targets.put(direction, (IFluidHandler)te);
                    }
                    if (targets.size() > 0) {
                        int out = (int)Math.ceil((float)Math.min(144, this.tank.getFluidAmount()) / (float)targets.size());
                        for (ForgeDirection targetDirection : targets.keySet()) {
                            if (this.tank.getFluid() == null || this.tank.getFluidAmount() < 1) break;
                            IFluidHandler fluidHandler = (IFluidHandler)targets.get(targetDirection);
                            int accepted = fluidHandler.fill(targetDirection.getOpposite(), new FluidStack(this.tank.getFluid().getFluid(), out), false);
                            if (accepted <= 0) continue;
                            FluidStack drained = this.tank.drain(accepted, true);
                            fluidHandler.fill(targetDirection.getOpposite(), drained, true);
                            update = true;
                        }
                    }
                }
            }
            if (update) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public DieselHandler.SqueezerRecipe getRecipe(ItemStack input) {
        DieselHandler.SqueezerRecipe recipe = DieselHandler.findSqueezerRecipe(input);
        if (recipe == null) {
            return null;
        }
        if ((this.inventory[11] == null || recipe.output == null || OreDictionary.itemMatches((ItemStack)this.inventory[11], (ItemStack)recipe.output, (boolean)false) && this.inventory[11].stackSize + recipe.output.stackSize <= recipe.output.getMaxStackSize()) && (this.tank.getFluid() == null || recipe.fluid == null || this.tank.getFluid().isFluidEqual(recipe.fluid) && this.tank.getFluidAmount() + recipe.fluid.amount <= this.tank.getCapacity())) {
            return recipe;
        }
        return null;
    }

    int[] getValidInputs() {
        int in = 0;
        int time = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            DieselHandler.SqueezerRecipe r = this.getRecipe(stack);
            if (r == null) continue;
            in += stack.stackSize;
            if (r.time <= time) continue;
            time = r.time;
        }
        return new int[]{in, time};
    }

    public int getScaledProgress(int scale) {
        if (this.processMaxTime <= 0) {
            return 0;
        }
        return (int)((float)scale * ((float)this.tick / (float)this.processMaxTime));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        this.energyStorage.readFromNBT(nbt);
        this.tick = nbt.getInteger("tick");
        this.processMaxTime = nbt.getInteger("processMaxTime");
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 12);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
        this.energyStorage.writeToNBT(nbt);
        nbt.setInteger("tick", this.tick);
        nbt.setInteger("processMaxTime", this.processMaxTime);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            if (this.pos != 1 && this.pos != 9 && this.pos != 11 && this.pos != 19) {
                return null;
            }
            return master.drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            if (this.pos != 1 && this.pos != 9 && this.pos != 11 && this.pos != 19) {
                return null;
            }
            return master.drain(from, maxDrain, doDrain);
        }
        FluidStack fs = this.tank.drain(maxDrain, doDrain);
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        return fs;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.formed) {
            return false;
        }
        return this.pos == 1 || this.pos == 9 || this.pos == 11 || this.pos == 19;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if ((this.pos == 1 || this.pos == 9 || this.pos == 11 || this.pos == 19) && from.ordinal() > 1) {
            TileEntitySqueezer master = this.master();
            return new FluidTankInfo[]{master != null ? master.tank.getInfo() : this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int f = this.facing;
            int il = this.pos / 9;
            int ih = this.pos % 9 / 3 - 1;
            int iw = this.pos % 3 - 1;
            int startX = this.xCoord - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)));
            int startY = this.yCoord - ih;
            int startZ = this.zCoord - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)));
            for (int l = 0; l < 3; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -w : w));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -w : w));
                        ItemStack s = null;
                        TileEntity tileEntity = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (tileEntity instanceof TileEntitySqueezer) {
                            s = ((TileEntitySqueezer)tileEntity).getOriginalBlock();
                            ((TileEntitySqueezer)tileEntity).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    public int getSizeInventory() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.getStackInSlot(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.decrStackSize(slot, amount);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.getStackInSlotOnClosing(slot);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            master.setInventorySlotContents(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return "IE:squeezer";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : this.formed && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed) {
            return false;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.isItemValidForSlot(slot, stack);
        }
        return slot < 9 ? DieselHandler.findSqueezerRecipe(stack) != null : slot == 9 && FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.formed) {
            return new int[0];
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.getAccessibleSlotsFromSide(side);
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.canInsertItem(slot, stack, side);
        }
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.canExtractItem(slot, stack, side);
        }
        return slot == 10 || slot == 11;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && (this.pos == 10 && from == ForgeDirection.DOWN || this.pos == 16 && from == ForgeDirection.UP);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntitySqueezer master = this.master();
        if (this.formed && master != null && (this.pos == 10 && from == ForgeDirection.DOWN || this.pos == 16 && from == ForgeDirection.UP)) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.markDirty();
            if (rec > 0) {
                this.worldObj.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntitySqueezer master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

