/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.entities.EntitySkycrate;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class TileEntitySkycrateDispenser
extends TileEntityIEBase
implements ISidedInventory {
    public void updateEntity() {
        if (this.worldObj.getTotalWorldTime() % 100L == 0L) {
            ChunkCoordinates cc = new ChunkCoordinates(this.xCoord, this.yCoord + 1, this.zCoord);
            ++cc.posY;
            if (!(this.worldObj.getTileEntity(cc.posX, cc.posY, cc.posZ) instanceof IImmersiveConnectable)) {
                return;
            }
            Set<ImmersiveNetHandler.Connection> outputs = ImmersiveNetHandler.INSTANCE.getConnections(this.worldObj, cc);
            if (outputs != null && outputs.size() > 0) {
                ImmersiveNetHandler.Connection connection = outputs.iterator().next();
                ChunkCoordinates cc0 = connection.end == cc ? connection.start : connection.end;
                ChunkCoordinates cc1 = connection.end == cc ? connection.end : connection.start;
                IImmersiveConnectable iicStart = Utils.toIIC(cc1, this.worldObj);
                IImmersiveConnectable iicEnd = Utils.toIIC(cc0, this.worldObj);
                Vec3 vStart = Vec3.createVectorHelper((double)cc1.posX, (double)cc1.posY, (double)cc1.posZ);
                Vec3 vEnd = Vec3.createVectorHelper((double)cc0.posX, (double)cc0.posY, (double)cc0.posZ);
                if (iicStart != null) {
                    vStart = Utils.addVectors(vStart, iicStart.getConnectionOffset(connection));
                }
                if (iicEnd != null) {
                    vEnd = Utils.addVectors(vEnd, iicEnd.getConnectionOffset(connection));
                }
                Vec3[] steps = SkylineHelper.getConnectionCatenary(connection, vStart, vEnd);
                double dx = steps[0].xCoord - vStart.xCoord;
                double dy = steps[0].yCoord - vStart.yCoord;
                double dz = steps[0].zCoord - vStart.zCoord;
                Vec3 moveVec = Vec3.createVectorHelper((double)dx, (double)dy, (double)dz);
                EntitySkycrate crate = new EntitySkycrate(this.worldObj, vStart.xCoord, vStart.yCoord, vStart.zCoord, connection, cc0, steps);
                float speed = 0.2f;
                crate.motionX = moveVec.xCoord * (double)speed;
                crate.motionY = moveVec.yCoord * (double)speed;
                crate.motionZ = moveVec.zCoord * (double)speed;
                crate.inventory[0] = new ItemStack(Items.apple);
                if (!this.worldObj.isRemote) {
                    IELogger.info("Spawn!");
                    this.worldObj.spawnEntityInWorld((Entity)crate);
                }
            }
        }
    }

    public int getSizeInventory() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
    }

    public String getInventoryName() {
        return "IESkycrateDispenser";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[0];
    }

    public boolean canInsertItem(int slot, ItemStack item, int side) {
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack item, int side) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    public boolean receiveClientEvent(int id, int arg) {
        return id == 0;
    }
}

