/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConveyorBelt;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockMetalPress;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityMetalPress
extends TileEntityMultiblockPart
implements ISidedInventory,
IEnergyReceiver {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(16000);
    public ItemStack[] inventory = new ItemStack[3];
    public MetalPressRecipe[] curRecipes = new MetalPressRecipe[3];
    public int[] process = new int[3];
    public ItemStack mold = null;
    public boolean active;
    public static final int MAX_PROCESS = 120;
    public int stopped = -1;
    private int stoppedReqSize = -1;
    public static HashMap<ComparableItemStack, Integer> minSizePerMold;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityMetalPress master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityMetalPress ? (TileEntityMetalPress)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = null;
        try {
            s = MultiblockMetalPress.instance.getStructureManual()[this.pos / 3][this.pos % 3][0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s != null ? s.copy() : null;
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 4) {
            return;
        }
        if (this.worldObj.isRemote) {
            if (!this.active) {
                return;
            }
            for (int i = 0; i < this.process.length; ++i) {
                if (this.process[i] < 0 || this.stopped == i) continue;
                int n = i;
                this.process[n] = this.process[n] + 1;
                if (this.process[i] <= 120) continue;
                this.inventory[i] = null;
                this.process[i] = -1;
            }
            return;
        }
        boolean update = false;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.stopped != i && this.inventory[i] != null) {
                int perTick;
                if (this.process[i] >= 120) {
                    ItemStack output = this.inventory[i].copy();
                    TileEntity inventoryTile = this.worldObj.getTileEntity(this.xCoord + (this.facing == 4 ? -2 : (this.facing == 5 ? 2 : 0)), this.yCoord, this.zCoord + (this.facing == 2 ? -2 : (this.facing == 3 ? 2 : 0)));
                    if (inventoryTile instanceof IInventory) {
                        output = Utils.insertStackIntoInventory((IInventory)inventoryTile, output, ForgeDirection.OPPOSITES[this.facing]);
                    }
                    if (output != null) {
                        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
                        EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)(this.facing == 4 ? -2 : (this.facing == 5 ? 2 : 0)), (double)this.yCoord, (double)this.zCoord + 0.5 + (double)(this.facing == 2 ? -2 : (this.facing == 3 ? 2 : 0)), output.copy());
                        ei.motionX = 0.075f * (float)fd.offsetX;
                        ei.motionY = 0.025000000372529;
                        ei.motionZ = 0.075f * (float)fd.offsetZ;
                        this.worldObj.spawnEntityInWorld((Entity)ei);
                    }
                    this.curRecipes[i] = null;
                    this.process[i] = -1;
                    this.inventory[i] = null;
                    update = true;
                }
                if (this.curRecipes[i] == null) {
                    this.curRecipes[i] = MetalPressRecipe.findRecipe(this.mold, this.inventory[i], true);
                }
                int n = perTick = this.curRecipes[i] != null ? this.curRecipes[i].energy / 120 : 0;
                if ((perTick == 0 || this.energyStorage.extractEnergy(perTick, true) == perTick) && this.process[i] >= 0) {
                    this.energyStorage.extractEnergy(perTick, false);
                    int n2 = i;
                    int n3 = this.process[n2];
                    this.process[n2] = n3 + 1;
                    if (n3 == 60 && this.curRecipes[i] != null) {
                        this.inventory[i] = this.curRecipes[i].output.copy();
                        update = true;
                    } else if (this.process[i] == 61 && this.mold != null && this.inventory[i].getItem() == Item.getItemFromBlock((Block)Blocks.tnt)) {
                        this.worldObj.createExplosion(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 5.0f, false);
                        this.inventory[i] = null;
                        this.process[i] = -1;
                        update = true;
                    }
                    if (this.active) continue;
                    this.active = true;
                    update = true;
                    continue;
                }
                if (!this.active) continue;
                this.active = false;
                update = true;
                continue;
            }
            if (this.stopped != i) continue;
            if (this.stoppedReqSize < 0) {
                MetalPressRecipe recipe = MetalPressRecipe.findRecipe(this.mold, this.inventory[i], false);
                if (recipe != null) {
                    this.stoppedReqSize = recipe.inputSize;
                } else {
                    this.stopped = -1;
                    update = true;
                    continue;
                }
            }
            if (this.stoppedReqSize > this.inventory[i].stackSize) continue;
            this.stopped = -1;
        }
        if (update) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public int getNextProcessID() {
        if (this.master() != null) {
            return this.master().getNextProcessID();
        }
        int lowestProcess = Integer.MAX_VALUE;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] != null) continue;
            if (lowestProcess == Integer.MAX_VALUE) {
                lowestProcess = 200;
                for (int j = 0; j < this.inventory.length; ++j) {
                    if (this.inventory[j] == null || this.process[j] >= lowestProcess || this.process[j] < 0) continue;
                    lowestProcess = this.process[j];
                }
            }
            if (lowestProcess > 40) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        int[] processTmp = nbt.getIntArray("process");
        this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 3);
        for (int i = 0; i < processTmp.length; ++i) {
            if (!(this.process[i] < 0 ^ processTmp[i] < 0) && descPacket) continue;
            this.process[i] = processTmp[i];
        }
        this.energyStorage.readFromNBT(nbt);
        this.mold = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("mold"));
        if (descPacket) {
            this.active = nbt.getBoolean("active");
        }
        if (nbt.hasKey("stoppedSlot")) {
            this.stopped = nbt.getInteger("stoppedSlot");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setIntArray("process", this.process);
        this.energyStorage.writeToNBT(nbt);
        nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
        if (this.mold != null) {
            nbt.setTag("mold", (NBTBase)this.mold.writeToNBT(new NBTTagCompound()));
        }
        if (descPacket) {
            nbt.setBoolean("active", this.active);
        }
        nbt.setInteger("stoppedSlot", this.stopped);
    }

    public boolean receiveClientEvent(int id, int arg) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (!this.formed) {
            return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)(this.yCoord - 1), (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 2), (double)(this.zCoord + 2)) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos < 3) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos % 3 == 0 || this.pos % 3 == 2) {
            yMax = 0.125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    public void invalidate() {
        super.invalidate();
        if (!this.worldObj.isRemote && this.pos == 4 && this.mold != null) {
            EntityItem moldDrop = new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, this.mold);
            this.worldObj.spawnEntityInWorld((Entity)moldDrop);
        }
        if (this.formed && !this.worldObj.isRemote) {
            int f = this.facing;
            TileEntityMetalPress master = this.master();
            if (master == null) {
                master = this;
            }
            int startX = master.xCoord;
            int startY = master.yCoord;
            int startZ = master.zCoord;
            for (int yy = -1; yy <= 1; ++yy) {
                for (int l = -1; l <= 1; ++l) {
                    int xx = f > 3 ? l : 0;
                    int zz = f < 4 ? l : 0;
                    ItemStack s = null;
                    TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                    if (te instanceof TileEntityMetalPress) {
                        s = ((TileEntityMetalPress)te).getOriginalBlock();
                        ((TileEntityMetalPress)te).formed = false;
                    }
                    if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                        s = this.getOriginalBlock();
                    }
                    if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                    if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                        this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                    } else {
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        int meta = s.getItemDamage();
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), meta, 3);
                    }
                    TileEntity tile = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                    if (!(tile instanceof TileEntityConveyorBelt)) continue;
                    ((TileEntityConveyorBelt)tile).facing = ForgeDirection.OPPOSITES[f];
                }
            }
        }
    }

    public int getSizeInventory() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.getStackInSlot(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.decrStackSize(slot, amount);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        this.markDirty();
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.getStackInSlotOnClosing(slot);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        MetalPressRecipe recipe;
        if (!this.formed) {
            return;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            master.setInventorySlotContents(slot, stack);
            return;
        }
        int stackLimit = this.getInventoryStackLimit();
        this.inventory[slot] = stack;
        int n = this.process[slot] = stack != null ? 0 : -1;
        if (stack != null && stack.stackSize > stackLimit) {
            stack.stackSize = stackLimit;
        }
        if ((recipe = MetalPressRecipe.findRecipe(this.mold, stack, false)) != null && recipe.inputSize > this.inventory[slot].stackSize) {
            this.stopped = slot;
            this.stoppedReqSize = recipe.inputSize;
        }
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public String getInventoryName() {
        return "IEMetalPress";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.getInventoryStackLimit();
        }
        if (this.stopped >= 0) {
            ItemStack input = this.inventory[this.stopped];
            MetalPressRecipe metalPressRecipe = MetalPressRecipe.findRecipe(this.mold, input, false);
            if (metalPressRecipe != null) {
                return metalPressRecipe.inputSize;
            }
            this.stopped = -1;
            this.stoppedReqSize = -1;
        }
        if (minSizePerMold == null || minSizePerMold.isEmpty()) {
            minSizePerMold = new HashMap(MetalPressRecipe.recipeList.size());
            for (Map.Entry entry : MetalPressRecipe.recipeList.asMap().entrySet()) {
                int min = Integer.MAX_VALUE;
                for (MetalPressRecipe p : (Collection)entry.getValue()) {
                    if (p.inputSize >= min) continue;
                    min = p.inputSize;
                }
                minSizePerMold.put((ComparableItemStack)entry.getKey(), min);
            }
        }
        if (this.mold == null) {
            return 1;
        }
        ComparableItemStack compStack = new ComparableItemStack(this.mold);
        return minSizePerMold.containsKey(compStack) ? minSizePerMold.get(compStack) : 1;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : this.formed && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed || stack == null) {
            return false;
        }
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.isItemValidForSlot(slot, stack);
        }
        if (this.mold != null) {
            return this.inventory[slot] == null || OreDictionary.itemMatches((ItemStack)stack, (ItemStack)this.inventory[slot], (boolean)true);
        }
        return true;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.pos == 3) {
            TileEntityMetalPress master = this.master();
            if (master.stopped >= 0) {
                return new int[]{master.stopped};
            }
            int next = this.getNextProcessID();
            if (next == -1) {
                return new int[0];
            }
            return new int[]{next};
        }
        return new int[0];
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return false;
        }
        if (this.pos == 3 && side == ForgeDirection.OPPOSITES[this.facing]) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return false;
            }
            TileEntityMetalPress master = this.master();
            if (master.inventory[slot] == null) {
                return stack.stackSize <= master.getInventoryStackLimit();
            }
            return master.inventory[slot].stackSize + stack.stackSize <= master.getInventoryStackLimit();
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 7 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityMetalPress master = this.master();
        if (this.formed && this.pos == 7 && from == ForgeDirection.UP && master != null) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.markDirty();
            if (rec > 0) {
                this.worldObj.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityMetalPress master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

