/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidPump
extends TileEntityIEBase
implements IFluidHandler,
IEnergyReceiver {
    public int[] sideConfig = new int[]{0, -1, -1, -1, -1, -1};
    public boolean dummy = true;
    public FluidTank tank = new FluidTank(4000);
    public EnergyStorage energyStorage = new EnergyStorage(8000);
    public boolean placeCobble = true;
    boolean checkingArea = false;
    Fluid searchFluid = null;
    ArrayList<ChunkCoordinates> openList = new ArrayList();
    ArrayList<ChunkCoordinates> closedList = new ArrayList();
    ArrayList<ChunkCoordinates> checked = new ArrayList();

    public void updateEntity() {
        int i;
        if (this.dummy || this.worldObj.isRemote) {
            return;
        }
        if (this.tank.getFluidAmount() > 0) {
            i = this.outputFluid(this.tank.getFluid(), false);
            this.tank.drain(i, true);
        }
        if (this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord) || this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord + 1, this.zCoord)) {
            for (i = 0; i < 6; ++i) {
                if (this.sideConfig[i] != 0) continue;
                ForgeDirection fd = ForgeDirection.getOrientation((int)i);
                TileEntity tile = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
                if (tile instanceof IFluidHandler) {
                    FluidStack drain = ((IFluidHandler)tile).drain(fd.getOpposite(), 500, false);
                    if (drain == null || drain.amount <= 0 || !((IFluidHandler)tile).canDrain(fd.getOpposite(), drain.getFluid())) continue;
                    int out = this.outputFluid(drain, false);
                    ((IFluidHandler)tile).drain(fd.getOpposite(), out, true);
                    continue;
                }
                if (this.worldObj.getTotalWorldTime() % 20L != (long)((this.xCoord ^ this.zCoord) & 0x13) || this.worldObj.getBlock(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ) != Blocks.water || !Config.getBoolean("pump_infiniteWater") || this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), false) != 1000 || this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), true) < Config.getInt("pump_consumption")) continue;
                int connectedSources = 0;
                for (int j = 2; j < 6; ++j) {
                    if (this.worldObj.getBlock(this.xCoord + fd.offsetX + (j == 4 ? -1 : (j == 5 ? 1 : 0)), this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ + (j == 2 ? -1 : (j == 3 ? 1 : 0))) != Blocks.water || this.worldObj.getBlockMetadata(this.xCoord + fd.offsetX + (j == 4 ? -1 : (j == 5 ? 1 : 0)), this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ + (j == 2 ? -1 : (j == 3 ? 1 : 0))) != 0) continue;
                    ++connectedSources;
                }
                if (connectedSources <= true) continue;
                this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), false);
                this.tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
            }
            if (this.worldObj.getTotalWorldTime() % 40L == (long)((this.xCoord ^ this.zCoord) & 0x27)) {
                if (this.closedList.isEmpty()) {
                    this.prepareAreaCheck();
                } else {
                    int target = this.closedList.size() - 1;
                    ChunkCoordinates cc = this.closedList.get(target);
                    FluidStack fs = Utils.drainFluidBlock(this.worldObj, cc.posX, cc.posY, cc.posZ, false);
                    if (fs == null) {
                        this.closedList.remove(target);
                    } else if (this.tank.fill(fs, false) == fs.amount && this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), true) >= Config.getInt("pump_consumption")) {
                        this.energyStorage.extractEnergy(Config.getInt("pump_consumption"), false);
                        fs = Utils.drainFluidBlock(this.worldObj, cc.posX, cc.posY, cc.posZ, true);
                        if (Config.getBoolean("pump_placeCobble") && this.placeCobble) {
                            this.worldObj.setBlock(cc.posX, cc.posY, cc.posZ, Blocks.cobblestone);
                        }
                        this.tank.fill(fs, true);
                        this.closedList.remove(target);
                    }
                }
            }
        }
        if (this.checkingArea) {
            this.checkAreaTick();
        }
    }

    public void prepareAreaCheck() {
        this.openList.clear();
        this.closedList.clear();
        this.checked.clear();
        for (int i = 0; i < 6; ++i) {
            if (this.sideConfig[i] != 0) continue;
            ForgeDirection fd = ForgeDirection.getOrientation((int)i);
            this.openList.add(new ChunkCoordinates(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ));
            this.checkingArea = true;
        }
    }

    public void checkAreaTick() {
        ChunkCoordinates next = null;
        int closedListMax = 2048;
        int timeout = 0;
        while (timeout < 64 && this.closedList.size() < 2048 && !this.openList.isEmpty()) {
            ++timeout;
            next = this.openList.get(0);
            if (!this.checked.contains(next)) {
                FluidStack fs = Utils.drainFluidBlock(this.worldObj, next.posX, next.posY, next.posZ, false);
                if (!(fs == null || fs.getFluid() == FluidRegistry.WATER && Config.getBoolean("pump_infiniteWater") || this.searchFluid != null && fs.getFluid() != this.searchFluid)) {
                    if (this.searchFluid == null) {
                        this.searchFluid = fs.getFluid();
                    }
                    this.closedList.add(next);
                    for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                        ChunkCoordinates cc2 = new ChunkCoordinates(next.posX + fd.offsetX, next.posY + fd.offsetY, next.posZ + fd.offsetZ);
                        FluidStack fs2 = Utils.drainFluidBlock(this.worldObj, cc2.posX, cc2.posY, cc2.posZ, false);
                        if (this.checked.contains(cc2) || this.closedList.contains(cc2) || this.openList.contains(cc2) || fs2 == null || fs2.getFluid() == FluidRegistry.WATER && Config.getBoolean("pump_infiniteWater") || this.searchFluid != null && fs2.getFluid() != this.searchFluid) continue;
                        this.openList.add(cc2);
                    }
                }
                this.checked.add(next);
            }
            this.openList.remove(0);
        }
        if (this.closedList.size() >= 2048 || this.openList.isEmpty()) {
            this.checkingArea = false;
        }
    }

    public int outputFluid(FluidStack fs, boolean simulate) {
        if (fs == null) {
            return 0;
        }
        int canAccept = fs.amount;
        if (canAccept <= 0) {
            return 0;
        }
        int accelPower = Config.getInt("pump_consumption_accelerate");
        int fluidForSort = canAccept;
        int sum = 0;
        HashMap<TileEntityFluidPipe.DirectionalFluidOutput, Integer> sorting = new HashMap<TileEntityFluidPipe.DirectionalFluidOutput, Integer>();
        for (int i = 0; i < 6; ++i) {
            int temp;
            if (this.sideConfig[i] != 1) continue;
            ForgeDirection fd = ForgeDirection.getOrientation((int)i);
            TileEntity tile = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
            if (!(tile instanceof IFluidHandler) || !((IFluidHandler)tile).canFill(ForgeDirection.getOrientation((int)i).getOpposite(), fs.getFluid())) continue;
            FluidStack insertResource = new FluidStack(fs.getFluid(), fs.amount);
            if (tile instanceof TileEntityFluidPipe && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                insertResource.tag = new NBTTagCompound();
                insertResource.tag.setBoolean("pressurized", true);
            }
            if ((temp = ((IFluidHandler)tile).fill(fd.getOpposite(), insertResource, false)) <= 0) continue;
            sorting.put(new TileEntityFluidPipe.DirectionalFluidOutput((IFluidHandler)tile, fd), temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            int i = 0;
            for (TileEntityFluidPipe.DirectionalFluidOutput output : sorting.keySet()) {
                float prio = (float)((Integer)sorting.get(output)).intValue() / (float)sum;
                int amount = (int)((float)fluidForSort * prio);
                if (i++ == sorting.size() - 1) {
                    amount = canAccept;
                }
                FluidStack insertResource = new FluidStack(fs.getFluid(), amount);
                if (output.output instanceof TileEntityFluidPipe && this.energyStorage.extractEnergy(accelPower, true) >= accelPower) {
                    this.energyStorage.extractEnergy(accelPower, false);
                    insertResource.tag = new NBTTagCompound();
                    insertResource.tag.setBoolean("pressurized", true);
                }
                int r = output.output.fill(output.direction.getOpposite(), insertResource, !simulate);
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, -1, -1, -1, -1, -1};
        }
        this.dummy = nbt.getBoolean("dummy");
        if (nbt.hasKey("placeCobble")) {
            this.placeCobble = nbt.getBoolean("placeCobble");
        }
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
        this.energyStorage.readFromNBT(nbt);
        if (descPacket) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        nbt.setBoolean("dummy", this.dummy);
        nbt.setBoolean("placeCobble", this.placeCobble);
        nbt.setTag("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        this.energyStorage.writeToNBT(nbt);
    }

    public void toggleSide(int side) {
        if (side != 1) {
            int n = side;
            this.sideConfig[n] = this.sideConfig[n] + 1;
            if (this.sideConfig[side] > 1) {
                this.sideConfig[side] = -1;
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || this.dummy || from == null || from == ForgeDirection.UNKNOWN || this.sideConfig[from.ordinal()] != 0) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.dummy || from == null || from == ForgeDirection.UNKNOWN || this.sideConfig[from.ordinal()] != 1) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return !this.dummy && from != null && from != ForgeDirection.UNKNOWN && this.sideConfig[from.ordinal()] == 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return !this.dummy && from != null && from != ForgeDirection.UNKNOWN && this.sideConfig[from.ordinal()] == 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.dummy && from != ForgeDirection.UNKNOWN && this.sideConfig[from.ordinal()] != -1) {
            return new FluidTankInfo[]{this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from == ForgeDirection.UP || !this.dummy && from != ForgeDirection.UNKNOWN && this.sideConfig[from.ordinal()] == -1;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.dummy) {
            TileEntity te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            if (te instanceof TileEntityFluidPump) {
                return ((TileEntityFluidPump)te).receiveEnergy(from, maxReceive, simulate);
            }
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (this.dummy) {
            TileEntity te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            if (te instanceof TileEntityFluidPump) {
                return ((TileEntityFluidPump)te).getEnergyStored(from);
            }
            return 0;
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.dummy) {
            TileEntity te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            if (te instanceof TileEntityFluidPump) {
                return ((TileEntityFluidPump)te).getMaxEnergyStored(from);
            }
            return 0;
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

