/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidPipe
extends TileEntityIEBase
implements IFluidHandler,
IEBlockInterfaces.IColouredTile {
    static ConcurrentHashMap<ChunkCoordinates, Set<DirectionalFluidOutput>> indirectConnections = new ConcurrentHashMap();
    public static ArrayList<ItemStack> validScaffoldCoverings = new ArrayList();
    public int[] sideConfig = new int[]{0, 0, 0, 0, 0, 0};
    public ItemStack scaffoldCovering = null;
    public int colour = 0xFFFFFF;

    public boolean canUpdate() {
        return false;
    }

    public static Set<DirectionalFluidOutput> getConnectedFluidHandlers(ChunkCoordinates node, World world) {
        if (indirectConnections.containsKey(node)) {
            return indirectConnections.get(node);
        }
        ArrayList<ChunkCoordinates> openList = new ArrayList<ChunkCoordinates>();
        ArrayList<ChunkCoordinates> closedList = new ArrayList<ChunkCoordinates>();
        Set<DirectionalFluidOutput> fluidHandlers = Collections.newSetFromMap(new ConcurrentHashMap());
        openList.add(node);
        while (!openList.isEmpty() && closedList.size() < 1024) {
            ChunkCoordinates next = (ChunkCoordinates)openList.get(0);
            if (world.blockExists(next.posX, next.posY, next.posZ)) {
                TileEntity te = world.getTileEntity(next.posX, next.posY, next.posZ);
                if (!closedList.contains(next) && (te instanceof TileEntityFluidPipe || te instanceof TileEntityFluidPump)) {
                    if (te instanceof TileEntityFluidPipe) {
                        closedList.add(next);
                    }
                    for (int i = 0; i < 6; ++i) {
                        FluidTankInfo[] tankInfo;
                        boolean b;
                        boolean bl = te instanceof TileEntityFluidPipe ? ((TileEntityFluidPipe)te).sideConfig[i] == 0 : (b = ((TileEntityFluidPump)te).sideConfig[i] == 1);
                        if (!b) continue;
                        ForgeDirection fd = ForgeDirection.getOrientation((int)i);
                        if (!world.blockExists(next.posX + fd.offsetX, next.posY + fd.offsetY, next.posZ + fd.offsetZ)) continue;
                        TileEntity te2 = world.getTileEntity(next.posX + fd.offsetX, next.posY + fd.offsetY, next.posZ + fd.offsetZ);
                        if (te2 instanceof TileEntityFluidPipe) {
                            openList.add(new ChunkCoordinates(next.posX + fd.offsetX, next.posY + fd.offsetY, next.posZ + fd.offsetZ));
                            continue;
                        }
                        if (!(te2 instanceof IFluidHandler) || (tankInfo = ((IFluidHandler)te2).getTankInfo(fd.getOpposite())) == null || tankInfo.length <= 0) continue;
                        IFluidHandler handler = (IFluidHandler)te2;
                        fluidHandlers.add(new DirectionalFluidOutput(handler, fd));
                    }
                }
            }
            openList.remove(0);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !indirectConnections.containsKey(node)) {
            indirectConnections.put(node, Collections.newSetFromMap(new ConcurrentHashMap()));
            indirectConnections.get(node).addAll(fluidHandlers);
        }
        return fluidHandlers;
    }

    public void invalidate() {
        super.invalidate();
        if (!this.worldObj.isRemote) {
            indirectConnections.clear();
        }
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public void setColour(int colour) {
        this.colour = colour;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideConfig = nbt.getIntArray("sideConfig");
        if (this.sideConfig == null || this.sideConfig.length != 6) {
            this.sideConfig = new int[]{0, 0, 0, 0, 0, 0};
        }
        this.scaffoldCovering = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("scaffold"));
        if (nbt.hasKey("colour")) {
            this.colour = nbt.getInteger("colour");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideConfig", this.sideConfig);
        if (this.scaffoldCovering != null) {
            nbt.setTag("scaffold", (NBTBase)this.scaffoldCovering.writeToNBT(new NBTTagCompound()));
        }
        nbt.setInteger("colour", this.colour);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || from == null || from == ForgeDirection.UNKNOWN || this.sideConfig[from.ordinal()] != 0 || this.worldObj.isRemote) {
            return 0;
        }
        int canAccept = resource.amount;
        if (canAccept <= 0) {
            return 0;
        }
        ArrayList<DirectionalFluidOutput> outputList = new ArrayList<DirectionalFluidOutput>(TileEntityFluidPipe.getConnectedFluidHandlers(new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord), this.worldObj));
        if (outputList.size() < 1) {
            return 0;
        }
        ChunkCoordinates ccFrom = new ChunkCoordinates(this.xCoord + from.offsetX, this.yCoord + from.offsetY, this.zCoord + from.offsetZ);
        int sum = 0;
        HashMap<DirectionalFluidOutput, Integer> sorting = new HashMap<DirectionalFluidOutput, Integer>();
        for (DirectionalFluidOutput output : outputList) {
            ChunkCoordinates cc = Utils.toCC(output.output);
            if (cc.equals((Object)ccFrom) || !this.worldObj.blockExists(cc.posX, cc.posY, cc.posZ) || !output.output.canFill(output.direction.getOpposite(), resource.getFluid())) continue;
            int limit = resource.tag != null && resource.tag.hasKey("pressurized") || this.canOutputPressurized(output.output, false) ? 1000 : 50;
            int tileSpecificAcceptedFluid = Math.min(limit, canAccept);
            int temp = output.output.fill(output.direction.getOpposite(), Utils.copyFluidStackWithAmount(resource, tileSpecificAcceptedFluid, true), false);
            if (temp <= 0) continue;
            sorting.put(output, temp);
            sum += temp;
        }
        if (sum > 0) {
            int f = 0;
            for (DirectionalFluidOutput output : sorting.keySet()) {
                int amount = (Integer)sorting.get(output);
                int r = output.output.fill(output.direction.getOpposite(), Utils.copyFluidStackWithAmount(resource, amount, true), doFill);
                if (r > 50) {
                    this.canOutputPressurized(output.output, true);
                }
                f += r;
                if ((canAccept -= r) > 0) continue;
                break;
            }
            return f;
        }
        return 0;
    }

    boolean canOutputPressurized(IFluidHandler output, boolean consumePower) {
        int accelPower;
        if (output instanceof TileEntityFluidPump && ((TileEntityFluidPump)output).energyStorage.extractEnergy(accelPower = Config.getInt("pump_consumption_accelerate"), true) >= accelPower) {
            if (consumePower) {
                ((TileEntityFluidPump)output).energyStorage.extractEnergy(accelPower, false);
            }
            return true;
        }
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != null && from != ForgeDirection.UNKNOWN && this.sideConfig[from.ordinal()] == 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTank(1000).getInfo()};
    }

    public byte getConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            FluidTankInfo[] tankInfo;
            TileEntity con = this.worldObj.getTileEntity(this.xCoord + (i == 4 ? -1 : (i == 5 ? 1 : 0)), this.yCoord + (i == 0 ? -1 : (i == 1 ? 1 : 0)), this.zCoord + (i == 2 ? -1 : (i == 3 ? 1 : 0)));
            connections = (byte)(connections << 1);
            if (this.sideConfig[i] != 0 || !(con instanceof IFluidHandler) || (tankInfo = ((IFluidHandler)con).getTankInfo(ForgeDirection.getOrientation((int)i).getOpposite())) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public byte getAvailableConnectionByte() {
        byte connections = 0;
        for (int i = 5; i >= 0; --i) {
            FluidTankInfo[] tankInfo;
            TileEntity con = this.worldObj.getTileEntity(this.xCoord + (i == 4 ? -1 : (i == 5 ? 1 : 0)), this.yCoord + (i == 0 ? -1 : (i == 1 ? 1 : 0)), this.zCoord + (i == 2 ? -1 : (i == 3 ? 1 : 0)));
            connections = (byte)(connections << 1);
            if (!(con instanceof IFluidHandler) || (tankInfo = ((IFluidHandler)con).getTankInfo(ForgeDirection.getOrientation((int)i).getOpposite())) == null || tankInfo.length <= 0) continue;
            connections = (byte)(connections | 1);
        }
        return connections;
    }

    public int getConnectionStyle(int connection) {
        byte tileConnections;
        if (this.sideConfig[connection] == -1) {
            return 0;
        }
        byte thisConnections = this.getConnectionByte();
        if ((thisConnections & 1 << connection) == 0) {
            return 0;
        }
        if (thisConnections != 3 && thisConnections != 12 && thisConnections != 48) {
            return 1;
        }
        TileEntity con = this.worldObj.getTileEntity(this.xCoord + (connection == 4 ? -1 : (connection == 5 ? 1 : 0)), this.yCoord + (connection == 0 ? -1 : (connection == 1 ? 1 : 0)), this.zCoord + (connection == 2 ? -1 : (connection == 3 ? 1 : 0)));
        if (con instanceof TileEntityFluidPipe && thisConnections == (tileConnections = ((TileEntityFluidPipe)con).getConnectionByte())) {
            return 0;
        }
        return 1;
    }

    public void toggleSide(int side) {
        int n = side;
        this.sideConfig[n] = this.sideConfig[n] + 1;
        if (this.sideConfig[side] > 0) {
            this.sideConfig[side] = -1;
        }
        ForgeDirection fd = ForgeDirection.getOrientation((int)side);
        TileEntity connected = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
        if (connected instanceof TileEntityFluidPipe) {
            ((TileEntityFluidPipe)connected).sideConfig[ForgeDirection.OPPOSITES[side]] = this.sideConfig[side];
            this.worldObj.addBlockEvent(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ, this.getBlockType(), 0, 0);
        }
        this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 0, 0);
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    static {
        validScaffoldCoverings.add(new ItemStack((Block)IEContent.blockMetalDecoration, 1, 1));
        validScaffoldCoverings.add(new ItemStack((Block)IEContent.blockMetalDecoration, 1, 11));
        validScaffoldCoverings.add(new ItemStack((Block)IEContent.blockMetalDecoration, 1, 13));
        validScaffoldCoverings.add(new ItemStack((Block)IEContent.blockMetalDecoration, 1, 14));
        validScaffoldCoverings.add(new ItemStack((Block)IEContent.blockWoodenDecoration, 1, 5));
    }

    public static class DirectionalFluidOutput {
        IFluidHandler output;
        ForgeDirection direction;

        public DirectionalFluidOutput(IFluidHandler output, ForgeDirection direction) {
            this.output = output;
            this.direction = direction;
        }
    }
}

