/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumSkyBlock;

public class TileEntityElectricLantern
extends TileEntityImmersiveConnectable
implements IEBlockInterfaces.ISpawnInterdiction {
    public int energyStorage = 0;
    public boolean active = false;
    private boolean interdictionList = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntity() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.interdictionList && Config.getBoolean("lantern_spawnPrevent")) {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
            synchronized (arrayList) {
                if (!EventHandler.interdictionTiles.contains(this)) {
                    EventHandler.interdictionTiles.add(this);
                }
            }
            this.interdictionList = true;
        }
        boolean b = this.active;
        if (this.energyStorage > 0) {
            --this.energyStorage;
            if (!this.active) {
                this.active = true;
            }
        } else if (this.active) {
            this.active = false;
        }
        if (this.active != b) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, 0);
        }
    }

    @Override
    public double getInterdictionRangeSquared() {
        return this.active ? 1024.0 : 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
        synchronized (arrayList) {
            if (EventHandler.interdictionTiles.contains(this)) {
                EventHandler.interdictionTiles.remove(this);
            }
        }
        super.invalidate();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.active = nbt.getBoolean("active");
        this.energyStorage = nbt.getInteger("energyStorage");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setBoolean("active", this.active);
        nbt.setInteger("energyStorage", this.energyStorage);
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return true;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        if (amount > 0 && this.energyStorage < 10) {
            if (!simulate) {
                int rec = Math.min(10 - this.energyStorage, 2);
                this.energyStorage += rec;
                return rec;
            }
            return Math.min(10 - this.energyStorage, 2);
        }
        return 0;
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 1) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return super.receiveClientEvent(id, arg);
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        int xDif = this.xCoord - ((TileEntity)link).xCoord;
        int zDif = this.zCoord - ((TileEntity)link).zCoord;
        if (xDif == 0 && zDif == 0) {
            return Vec3.createVectorHelper((double)0.5, (double)0.0625, (double)0.5);
        }
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return Vec3.createVectorHelper((double)(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5)), (double)0.0625, (double)0.5);
        }
        return Vec3.createVectorHelper((double)0.5, (double)0.0625, (double)(zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5)));
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        int zDif;
        int xDif;
        ChunkCoordinates here = Utils.toCC(this);
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.posX - this.xCoord : (xDif = con.end.equals((Object)here) && con.start != null ? con.start.posX - this.xCoord : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)here) && con.end != null ? con.end.posZ - this.zCoord : (zDif = con.end.equals((Object)here) && con.start != null ? con.start.posZ - this.zCoord : 0));
        if (Math.abs(xDif) >= Math.abs(zDif)) {
            return Vec3.createVectorHelper((double)(xDif < 0 ? 0.25 : (xDif > 0 ? 0.75 : 0.5)), (double)0.0625, (double)0.5);
        }
        return Vec3.createVectorHelper((double)0.5, (double)0.0625, (double)(zDif < 0 ? 0.25 : (zDif > 0 ? 0.75 : 0.5)));
    }
}

