/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockDieselGenerator;
import blusunrize.immersiveengineering.common.util.IESound;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityDieselGenerator
extends TileEntityMultiblockPart
implements IFluidHandler,
IEBlockInterfaces.ISoundTile,
IEnergyConnection {
    public int facing = 2;
    public FluidTank tank = new FluidTank(8000);
    public boolean active = false;
    public float fanRotationStep = 0.0f;
    public float fanRotation = 0.0f;
    public int fanFadeIn = 0;
    public int fanFadeOut = 0;
    public boolean computerControlled = false;
    public boolean computerActivated = false;
    static IESound sound;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityDieselGenerator master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityDieselGenerator ? (TileEntityDieselGenerator)te : null;
    }

    public static boolean _Immovable() {
        return true;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockDieselGenerator.instance.getStructureManual()[this.pos % 9 / 3][4 - this.pos / 9][this.pos % 3];
        return s != null ? s.copy() : null;
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 31) {
            return;
        }
        if (this.active || this.fanFadeIn > 0 || this.fanFadeOut > 0) {
            float step;
            float base = 18.0f;
            float f = step = this.active ? base : 0.0f;
            if (this.fanFadeIn > 0) {
                step -= (float)this.fanFadeIn / 80.0f * base;
                --this.fanFadeIn;
            }
            if (this.fanFadeOut > 0) {
                step += (float)this.fanFadeOut / 80.0f * base;
                --this.fanFadeOut;
            }
            this.fanRotationStep = step;
            this.fanRotation += step;
            this.fanRotation %= 360.0f;
        }
        if (this.worldObj.isRemote) {
            ImmersiveEngineering.proxy.handleTileSound("dieselGenerator", this, this.active, 0.5f, 1.0f);
            if (this.active && this.worldObj.getTotalWorldTime() % 4L == 0L) {
                this.worldObj.spawnParticle("largesmoke", (double)this.xCoord + 0.5 + (this.facing == 4 ? 1.25 : (this.facing == 5 ? -1.25 : (this.facing == (this.mirrored ? 2 : 3) ? 0.625 : -0.625))), (double)this.yCoord + 2.25, (double)this.zCoord + 0.5 + (this.facing == 2 ? 1.25 : (this.facing == 3 ? -1.25 : (this.facing == (this.mirrored ? 5 : 4) ? 0.625 : -0.625))), 0.0, 0.0, 0.0);
            }
        } else {
            boolean run;
            boolean prevActive = this.active;
            if (this.computerControlled) {
                run = this.computerActivated;
            } else {
                boolean bl = run = !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord + (this.facing == 4 || this.facing == (this.mirrored ? 2 : 3) ? 1 : -1), this.yCoord, this.zCoord + (this.facing == 2 || this.facing == (this.mirrored ? 5 : 4) ? 1 : -1));
            }
            if (run && this.tank.getFluid() != null && this.tank.getFluid().getFluid() != null) {
                int burnTime = DieselHandler.getBurnTime(this.tank.getFluid().getFluid());
                int fluidConsumed = 1000 / burnTime;
                int output = Config.getInt("dieselGen_output");
                int connected = 0;
                IEnergyReceiver[] receivers = new IEnergyReceiver[3];
                for (int i = 0; i < 3; ++i) {
                    receivers[i] = this.getOutput(i == 1 ? -1 : (i == 2 ? 1 : 0));
                    if (receivers[i] == null || !receivers[i].canConnectEnergy(ForgeDirection.DOWN) || receivers[i].receiveEnergy(ForgeDirection.DOWN, 4096, true) <= 0) continue;
                    ++connected;
                }
                if (connected > 0 && this.tank.getFluidAmount() >= fluidConsumed) {
                    if (!this.active) {
                        this.active = true;
                        this.fanFadeIn = 80;
                    }
                    this.tank.drain(fluidConsumed, true);
                    int splitOutput = output / connected;
                    int leftover = output % connected;
                    for (int i = 0; i < 3; ++i) {
                        if (receivers[i] == null || !receivers[i].canConnectEnergy(ForgeDirection.DOWN)) continue;
                        receivers[i].receiveEnergy(ForgeDirection.DOWN, splitOutput + (leftover-- > 0 ? 1 : 0), false);
                    }
                } else if (this.active) {
                    this.active = false;
                    this.fanFadeOut = 80;
                }
            } else if (this.active) {
                this.active = false;
                this.fanFadeOut = 80;
            }
            if (prevActive != this.active) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    IEnergyReceiver getOutput(int w) {
        TileEntity eTile = this.worldObj.getTileEntity(this.xCoord + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : w)), this.yCoord + 1, this.zCoord + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : w)));
        if (eTile instanceof IEnergyReceiver) {
            return (IEnergyReceiver)eTile;
        }
        return null;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.active = nbt.getBoolean("active");
        this.fanRotation = nbt.getFloat("fanRotation");
        this.fanFadeIn = nbt.getInteger("fanFadeIn");
        this.fanFadeOut = nbt.getInteger("fanFadeOut");
        this.tank.readFromNBT(nbt.getCompoundTag("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setBoolean("active", this.active);
        nbt.setFloat("fanRotation", this.fanRotation);
        nbt.setInteger("fanFadeIn", this.fanFadeIn);
        nbt.setInteger("fanFadeOut", this.fanFadeOut);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.setTag("tank", (NBTBase)tankTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.formed) {
            return 0;
        }
        TileEntityDieselGenerator master = this.master();
        if (master != null) {
            if (this.pos != 36 && this.pos != 38) {
                return 0;
            }
            return master.fill(from, resource, doFill);
        }
        if (resource != null && DieselHandler.isValidFuel(resource.getFluid())) {
            int f = this.tank.fill(resource, doFill);
            return f;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from, resource != null ? resource.getFluid() : null)) {
            return null;
        }
        TileEntityDieselGenerator master = this.master();
        if (master != null) {
            if (this.pos != 36 && this.pos != 38) {
                return null;
            }
            return master.drain(from, resource, doDrain);
        }
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.formed) {
            return null;
        }
        TileEntityDieselGenerator master = this.master();
        if (master != null) {
            if (this.pos != 36 && this.pos != 38) {
                return null;
            }
            return master.drain(from, maxDrain, doDrain);
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.formed && (this.pos == 36 || this.pos == 38) && DieselHandler.isValidFuel(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.formed && (this.pos == 36 || this.pos == 38);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.pos == 36 && this.facing == from.getRotation(ForgeDirection.UP).ordinal() || this.pos == 38 && this.facing == from.getRotation(ForgeDirection.DOWN).ordinal()) {
            TileEntityDieselGenerator master = this.master();
            return new FluidTankInfo[]{master != null ? master.tank.getInfo() : this.tank.getInfo()};
        }
        return new FluidTankInfo[0];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 31 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing == 5 ? 3 : 1)), (double)(this.yCoord - 1), (double)(this.zCoord - (this.facing == 3 ? 3 : 1)), (double)(this.xCoord + (this.facing == 4 ? 4 : 2)), (double)(this.yCoord + 2), (double)(this.zCoord + (this.facing == 2 ? 4 : 2))) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        boolean mirror;
        TileEntityDieselGenerator master = this.master();
        boolean bl = mirror = master != null ? master.mirrored : this.mirrored;
        if (this.pos >= 3 && this.pos < 36) {
            float height;
            float f = this.pos == 24 || this.pos == 26 ? 1.0f : (height = this.pos % 9 >= 6 && this.pos > 9 ? 0.375f : 1.0f);
            if (this.pos == 9 || this.pos == 11 || this.pos == 27 || this.pos == 29) {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
            }
            if (this.pos == 34) {
                return new float[]{this.facing == 4 ? 0.375f : 0.0f, 0.0f, this.facing == 2 ? 0.375f : 0.0f, this.facing == 5 ? 0.625f : 1.0f, height, this.facing == 3 ? 0.625f : 1.0f};
            }
            if (this.pos % 9 == 0 || this.pos % 9 == 3 || this.pos % 9 == 6) {
                if (this.pos == 33) {
                    float[] fArray = new float[6];
                    fArray[0] = this.facing == 2 ? 0.5f : (this.facing == 4 ? 0.375f : 0.0f);
                    fArray[1] = 0.0f;
                    float f2 = this.facing == 5 ? 0.5f : (fArray[2] = this.facing == 2 ? 0.375f : 0.0f);
                    fArray[3] = this.facing == 3 ? 0.5f : (this.facing == 5 ? 0.625f : 1.0f);
                    fArray[4] = height;
                    fArray[5] = this.facing == 4 ? 0.5f : (this.facing == 3 ? 0.625f : 1.0f);
                    return fArray;
                }
                if (this.pos == 18) {
                    return new float[]{this.facing == 2 ? 0.4375f : 0.0f, 0.0f, this.facing == 5 ? 0.4375f : 0.0f, this.facing == 3 ? 0.5625f : 1.0f, height, this.facing == 4 ? 0.5625f : 1.0f};
                }
                if (this.pos == 21 && !mirror) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{this.facing == 2 ? 0.5f : 0.0f, 0.0f, this.facing == 5 ? 0.5f : 0.0f, this.facing == 3 ? 0.5f : 1.0f, height, this.facing == 4 ? 0.5f : 1.0f};
            }
            if (this.pos % 9 == 2 || this.pos % 9 == 5 || this.pos % 9 == 8) {
                if (this.pos == 35) {
                    float[] fArray = new float[6];
                    fArray[0] = this.facing == 3 ? 0.5f : (this.facing == 4 ? 0.375f : 0.0f);
                    fArray[1] = 0.0f;
                    float f3 = this.facing == 4 ? 0.5f : (fArray[2] = this.facing == 2 ? 0.375f : 0.0f);
                    fArray[3] = this.facing == 2 ? 0.5f : (this.facing == 5 ? 0.625f : 1.0f);
                    fArray[4] = height;
                    fArray[5] = this.facing == 5 ? 0.5f : (this.facing == 3 ? 0.625f : 1.0f);
                    return fArray;
                }
                if (this.pos == 20) {
                    return new float[]{this.facing == 3 ? 0.4375f : 0.0f, 0.0f, this.facing == 4 ? 0.4375f : 0.0f, this.facing == 2 ? 0.5625f : 1.0f, height, this.facing == 5 ? 0.5625f : 1.0f};
                }
                if (this.pos == 23 && mirror) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                return new float[]{this.facing == 3 ? 0.5f : 0.0f, 0.0f, this.facing == 4 ? 0.5f : 0.0f, this.facing == 2 ? 0.5f : 1.0f, height, this.facing == 5 ? 0.5f : 1.0f};
            }
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, height, 1.0f};
        }
        if (this.pos == 36 || this.pos == 38) {
            return new float[]{this.facing == (this.pos == 36 ? 3 : 2) ? 0.5f : 0.0f, 0.0f, this.facing == (this.pos == 36 ? 4 : 5) ? 0.5f : 0.0f, this.facing == (this.pos == 36 ? 2 : 3) ? 0.5f : 1.0f, 1.0f, this.facing == (this.pos == 36 ? 5 : 4) ? 0.5f : 1.0f};
        }
        if (this.pos == 37) {
            return new float[]{0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void invalidate() {
        super.invalidate();
        ImmersiveEngineering.proxy.stopTileSound("dieselGenerator", this);
        if (this.formed && !this.worldObj.isRemote) {
            int f = this.facing;
            int il = this.pos / 9;
            int ih = this.pos % 9 / 3 - 1;
            int iw = this.pos % 3 - 1;
            int startX = this.xCoord - (f == 5 ? il : (f == 4 ? -il : (f == 2 ? iw : -iw)));
            int startY = this.yCoord - ih;
            int startZ = this.zCoord - (f == 3 ? il : (f == 2 ? -il : (f == 5 ? iw : -iw)));
            for (int l = 0; l < 5; ++l) {
                for (int w = -1; w <= 1; ++w) {
                    for (int h = -1; h <= (l == 4 ? 0 : 1); ++h) {
                        int xx = f == 5 ? l : (f == 4 ? -l : (f == 2 ? -w : w));
                        int yy = h;
                        int zz = f == 3 ? l : (f == 2 ? -l : (f == 5 ? -w : w));
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityDieselGenerator) {
                            s = ((TileEntityDieselGenerator)te).getOriginalBlock();
                            ((TileEntityDieselGenerator)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.pos >= 38 && this.pos <= 41 && from == ForgeDirection.UP;
    }

    public void mirror() {
    }
}

