/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockCrusher;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESound;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrusher
extends TileEntityMultiblockPart
implements IEnergyReceiver,
ISidedInventory,
IEBlockInterfaces.ISoundTile {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(32000);
    public List<ItemStack> inputs = new ArrayList<ItemStack>();
    public int process = 0;
    public float barrelRotation = 0.0f;
    public boolean active = false;
    public boolean hasPower = false;
    public boolean mobGrinding = false;
    public int grindingTimer = 0;
    public boolean computerControlled;
    public boolean computerOn;
    @SideOnly(value=Side.CLIENT)
    ItemStack particleStack;
    public static final Map<ComparableItemStack, CrusherRecipe> recipeCache = new ConcurrentHashMap<ComparableItemStack, CrusherRecipe>();
    public static final CrusherRecipe CRUSHER_NULL = new CrusherRecipe(null, "", 0);
    static IESound sound;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityCrusher master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityCrusher ? (TileEntityCrusher)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockCrusher.instance.getStructureManual()[this.pos % 15 / 5][this.pos % 5][this.pos / 15];
        return s != null ? s.copy() : null;
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 17) {
            return;
        }
        if (this.hasPower && this.active && this.process > 0 || this.mobGrinding || this.grindingTimer > 0) {
            if (this.grindingTimer > 0) {
                --this.grindingTimer;
            }
            this.barrelRotation += 18.0f;
            this.barrelRotation %= 360.0f;
        }
        if (this.worldObj.isRemote) {
            ImmersiveEngineering.proxy.handleTileSound("crusher", this, this.hasPower && (this.active && this.process > 0 || this.mobGrinding || this.grindingTimer > 0), 1.0f, 1.0f);
            if (this.particleStack != null && this.active && this.hasPower && this.process > 0) {
                ImmersiveEngineering.proxy.spawnCrusherFX(this, this.particleStack);
            } else if (this.particleStack != null) {
                this.particleStack = null;
            }
        } else {
            boolean canWork;
            boolean update = false;
            if (this.hasPower != this.energyStorage.getEnergyStored() > 0) {
                this.hasPower = !this.hasPower;
                update = true;
            }
            if (this.computerControlled) {
                canWork = this.computerOn;
            } else {
                boolean bl = canWork = !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord + (this.facing == 4 ? -1 : (this.facing == 5 ? 1 : (this.facing == (this.mirrored ? 2 : 3) ? 2 : -2))), this.yCoord + 1, this.zCoord + (this.facing == 2 ? -1 : (this.facing == 3 ? 1 : (this.facing == (this.mirrored ? 5 : 4) ? 2 : -2))));
            }
            if (canWork) {
                int power = Config.getInt("crusher_consumption");
                AxisAlignedBB aabb = AxisAlignedBB.getBoundingBox((double)((double)this.xCoord - 0.5625), (double)((double)this.yCoord + 1.5), (double)((double)this.zCoord - 0.5625), (double)((double)this.xCoord + 1.5625), (double)((double)this.yCoord + 2.875), (double)((double)this.zCoord + 1.5625));
                List entityList = this.worldObj.getEntitiesWithinAABB(Entity.class, aabb);
                boolean hurtLiving = false;
                if (!entityList.isEmpty() && this.hasPower) {
                    for (Object o : entityList) {
                        EntityItem e;
                        if (o instanceof EntityItem) {
                            e = (EntityItem)o;
                            ItemStack input = e.getEntityItem();
                            if (!this.isValidInput(input)) {
                                e.setDead();
                                this.grindingTimer = 10;
                                update = true;
                                continue;
                            }
                            this.addStackToInputs(input);
                            update = true;
                            e.setDead();
                        }
                        if (!(o instanceof EntityLivingBase)) continue;
                        e = (EntityLivingBase)o;
                        if (!e.isDead && e.getHealth() > 0.0f) {
                            int consumed = this.energyStorage.extractEnergy(power, false);
                            if (consumed > 0) {
                                e.attackEntityFrom(IEDamageSources.causeCrusherDamage(), (float)consumed / 20.0f);
                                EventHandler.crusherMap.put(e.getUniqueID(), this);
                                this.mobGrinding = true;
                            }
                            update = true;
                        }
                        hurtLiving = true;
                    }
                }
                if (!hurtLiving && this.process <= 0 && this.mobGrinding) {
                    this.mobGrinding = false;
                    update = true;
                }
                if (this.process > 0) {
                    int consumed = this.energyStorage.extractEnergy(power, false);
                    if (consumed > 0) {
                        this.process -= consumed;
                        if (!this.active) {
                            this.active = true;
                            update = true;
                        }
                    } else if (this.active) {
                        this.active = false;
                        update = true;
                    }
                }
                if (this.process <= 0 && !this.inputs.isEmpty()) {
                    if (this.active) {
                        ItemStack inputStack = this.inputs.get(0);
                        CrusherRecipe recipe = this.getRecipe(inputStack);
                        if (recipe != null) {
                            if (inputStack.stackSize >= (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).stackSize : 1)) {
                                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                                ItemStack outputStack = recipe.output;
                                if (outputStack != null) {
                                    out.add(outputStack);
                                }
                                if (recipe.secondaryOutput != null) {
                                    for (int i = 0; i < recipe.secondaryOutput.length; ++i) {
                                        if (!(this.worldObj.rand.nextFloat() < recipe.secondaryChance[i])) continue;
                                        out.add(recipe.secondaryOutput[i]);
                                    }
                                }
                                this.outputItems(out);
                                inputStack.stackSize = inputStack.stackSize - (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).stackSize : 1);
                                if (inputStack.stackSize > 0) {
                                    this.inputs.set(0, inputStack);
                                } else {
                                    this.inputs.remove(0);
                                }
                                if (!this.startRecipe()) {
                                    this.active = false;
                                }
                                update = true;
                            } else {
                                this.active = false;
                                update = true;
                            }
                        }
                    } else if (this.startRecipe()) {
                        this.active = true;
                        update = true;
                    }
                }
            } else if (this.active) {
                this.active = false;
                this.mobGrinding = false;
                update = true;
            }
            if (update) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    boolean startRecipe() {
        if (this.inputs.isEmpty()) {
            return false;
        }
        ItemStack inputStack = this.inputs.get(0);
        int time = this.getRecipeTime(inputStack);
        if (time > 0) {
            this.process = time;
        }
        return time > 0;
    }

    public int getRecipeTime(ItemStack in) {
        CrusherRecipe recipe = this.getRecipe(in);
        if (recipe != null && in.stackSize >= (recipe.input instanceof ItemStack ? ((ItemStack)recipe.input).stackSize : 1)) {
            return recipe.energy;
        }
        return -1;
    }

    public CrusherRecipe getRecipe(ItemStack in) {
        IRockCrusherRecipe crush;
        ComparableItemStack comp = new ComparableItemStack(in.copy());
        comp.stack.stackTagCompound = null;
        comp.stack.stackSize = 1;
        comp.useNBT = false;
        comp.ignoreOreDict = true;
        if (recipeCache.containsKey(comp)) {
            CrusherRecipe r = recipeCache.get(comp);
            return r == CRUSHER_NULL ? null : r;
        }
        CrusherRecipe ret = CrusherRecipe.findRecipe(in);
        if (ret == null && RailcraftCraftingManager.rockCrusher != null && (crush = RailcraftCraftingManager.rockCrusher.getRecipe(in)) != null) {
            List<Map.Entry<ItemStack, Float>> out = crush.getOutputs();
            int outCount = out.size();
            float[] outProbabilities = new float[outCount];
            ItemStack[] outStacks = new ItemStack[outCount];
            for (int i = 0; i < outCount; ++i) {
                Map.Entry<ItemStack, Float> entry = out.get(i);
                outProbabilities[i] = entry.getValue().floatValue();
                outStacks[i] = entry.getKey();
            }
            ret = new CrusherRecipe(null, Utils.copyStackWithAmount(in, 1), 4000);
            ret.secondaryChance = outProbabilities;
            ret.secondaryOutput = outStacks;
        }
        if (ret == null) {
            ret = CRUSHER_NULL;
        }
        recipeCache.put(comp, ret);
        return ret == CRUSHER_NULL ? null : ret;
    }

    boolean isValidInput(ItemStack stack) {
        return this.getRecipe(stack) != null;
    }

    public boolean addStackToInputs(ItemStack stack) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (this.inputs.get(i) == null || !this.inputs.get(i).isItemEqual(stack) || this.inputs.get((int)i).stackSize + stack.stackSize > stack.getMaxStackSize()) continue;
            this.inputs.get((int)i).stackSize += stack.stackSize;
            return true;
        }
        this.inputs.add(stack);
        return true;
    }

    public void outputItems(List<ItemStack> stacks) {
        TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + (this.facing == 4 ? -2 : (this.facing == 5 ? 2 : 0)), this.yCoord, this.zCoord + (this.facing == 2 ? -2 : (this.facing == 3 ? 2 : 0)));
        boolean isInv = this.isInventory(inventory, ForgeDirection.OPPOSITES[this.facing]);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = stacks.get(i);
            if (stack == null) continue;
            if (isInv) {
                stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[this.facing]);
            }
            if (stack == null) continue;
            ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
            EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)(fd.offsetX * 2), (double)this.yCoord + 0.5, (double)this.zCoord + 0.5 + (double)(fd.offsetZ * 2), stack.copy());
            ei.motionX = 0.075f * (float)fd.offsetX;
            ei.motionY = 0.025000000372529;
            ei.motionZ = 0.075f * (float)fd.offsetZ;
            this.worldObj.spawnEntityInWorld((Entity)ei);
        }
    }

    boolean isInventory(TileEntity tile, int side) {
        if (tile instanceof ISidedInventory && ((ISidedInventory)tile).getAccessibleSlotsFromSide(side).length > 0) {
            return true;
        }
        return tile instanceof IInventory && ((IInventory)tile).getSizeInventory() > 0;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.hasPower = nbt.getBoolean("hasPower");
        if (this.hasPower) {
            this.barrelRotation = nbt.getFloat("barrelRotation");
        }
        this.active = nbt.getBoolean("active");
        this.mobGrinding = nbt.getBoolean("mobGrinding");
        this.grindingTimer = nbt.getInteger("grindingTimer");
        this.process = nbt.getInteger("process");
        this.energyStorage.readFromNBT(nbt);
        if (!descPacket) {
            NBTTagList invList = nbt.getTagList("inputs", 10);
            this.inputs.clear();
            for (int i = 0; i < invList.tagCount(); ++i) {
                this.inputs.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)invList.getCompoundTagAt(i)));
            }
        } else {
            this.particleStack = nbt.hasKey("particleStack") ? ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("particleStack")) : null;
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setBoolean("hasPower", this.hasPower);
        nbt.setFloat("barrelRotation", this.barrelRotation);
        nbt.setBoolean("active", this.active);
        nbt.setBoolean("mobGrinding", this.mobGrinding);
        nbt.setInteger("grindingTimer", this.grindingTimer);
        nbt.setInteger("process", this.process);
        this.energyStorage.writeToNBT(nbt);
        if (!descPacket) {
            NBTTagList invList = new NBTTagList();
            for (ItemStack s : this.inputs) {
                invList.appendTag((NBTBase)s.writeToNBT(new NBTTagCompound()));
            }
            nbt.setTag("inputs", (NBTBase)invList);
        } else if (!this.inputs.isEmpty()) {
            NBTTagCompound t = this.inputs.get(0).writeToNBT(new NBTTagCompound());
            nbt.setTag("particleStack", (NBTBase)t);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 17 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - (this.facing == 2 || this.facing == 3 ? 2 : 1)), (double)this.yCoord, (double)(this.zCoord - (this.facing == 4 || this.facing == 5 ? 2 : 1)), (double)(this.xCoord + (this.facing == 2 || this.facing == 3 ? 3 : 2)), (double)(this.yCoord + 3), (double)(this.zCoord + (this.facing == 4 || this.facing == 5 ? 3 : 2))) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        int fl = this.facing;
        int fw = this.facing;
        if (this.mirrored) {
            fw = ForgeDirection.OPPOSITES[fw];
        }
        if (this.pos % 15 >= 6 && this.pos % 15 <= 8) {
            if (this.pos / 15 == 0) {
                if (this.pos % 5 == 1) {
                    return new float[]{fw == 3 || fl == 4 ? 0.1875f : 0.0f, 0.5f, fl == 2 || fw == 4 ? 0.1875f : 0.0f, fw == 2 || fl == 5 ? 0.8125f : 1.0f, 1.0f, fl == 3 || fw == 5 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 2) {
                    return new float[]{fl == 4 ? 0.1875f : 0.0f, 0.5f, fl == 2 ? 0.1875f : 0.0f, fl == 5 ? 0.8125f : 1.0f, 1.0f, fl == 3 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 3) {
                    return new float[]{fw == 2 || fl == 4 ? 0.1875f : 0.0f, 0.5f, fl == 2 || fw == 5 ? 0.1875f : 0.0f, fw == 3 || fl == 5 ? 0.8125f : 1.0f, 1.0f, fl == 3 || fw == 4 ? 0.8125f : 1.0f};
                }
            } else if (this.pos / 15 == 1) {
                if (this.pos % 5 == 1) {
                    return new float[]{fw == 3 ? 0.1875f : 0.0f, 0.5f, fw == 4 ? 0.1875f : 0.0f, fw == 2 ? 0.8125f : 1.0f, 1.0f, fw == 5 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 2) {
                    return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
                }
                if (this.pos % 5 == 3) {
                    return new float[]{fw == 2 ? 0.1875f : 0.0f, 0.5f, fw == 5 ? 0.1875f : 0.0f, fw == 3 ? 0.8125f : 1.0f, 1.0f, fw == 4 ? 0.8125f : 1.0f};
                }
            } else if (this.pos / 15 == 2) {
                if (this.pos % 5 == 1) {
                    return new float[]{fw == 3 || fl == 5 ? 0.1875f : 0.0f, 0.5f, fl == 3 || fw == 4 ? 0.1875f : 0.0f, fw == 2 || fl == 4 ? 0.8125f : 1.0f, 1.0f, fl == 2 || fw == 5 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 2) {
                    return new float[]{fl == 5 ? 0.1875f : 0.0f, 0.5f, fl == 3 ? 0.1875f : 0.0f, fl == 4 ? 0.8125f : 1.0f, 1.0f, fl == 2 ? 0.8125f : 1.0f};
                }
                if (this.pos % 5 == 3) {
                    return new float[]{fw == 2 || fl == 5 ? 0.1875f : 0.0f, 0.5f, fl == 3 || fw == 5 ? 0.1875f : 0.0f, fw == 3 || fl == 4 ? 0.8125f : 1.0f, 1.0f, fl == 2 || fw == 4 ? 0.8125f : 1.0f};
                }
            }
        } else if (this.pos % 15 >= 11 && this.pos % 15 <= 13) {
            if (this.pos / 15 == 0) {
                if (this.pos % 5 == 2) {
                    float[] fArray = new float[6];
                    fArray[0] = fl == 4 ? 0.1875f : (fl == 5 ? 0.5625f : 0.0f);
                    fArray[1] = 0.0f;
                    float f = fl == 2 ? 0.1875f : (fArray[2] = fl == 3 ? 0.5625f : 0.0f);
                    fArray[3] = fl == 5 ? 0.8125f : (fl == 4 ? 0.4375f : 1.0f);
                    fArray[4] = 1.0f;
                    fArray[5] = fl == 3 ? 0.8125f : (fl == 2 ? 0.4375f : 1.0f);
                    return fArray;
                }
            } else if (this.pos / 15 == 1) {
                if (this.pos % 5 == 1) {
                    float[] fArray = new float[6];
                    fArray[0] = fw == 3 ? 0.1875f : (fw == 2 ? 0.5625f : 0.0f);
                    fArray[1] = 0.0f;
                    float f = fw == 4 ? 0.1875f : (fArray[2] = fw == 5 ? 0.5625f : 0.0f);
                    fArray[3] = fw == 2 ? 0.8125f : (fw == 3 ? 0.4375f : 1.0f);
                    fArray[4] = 1.0f;
                    fArray[5] = fw == 5 ? 0.8125f : (fw == 4 ? 0.4375f : 1.0f);
                    return fArray;
                }
                if (this.pos % 5 == 2) {
                    return new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                }
                if (this.pos % 5 == 3) {
                    float[] fArray = new float[6];
                    fArray[0] = fw == 2 ? 0.1875f : (fw == 3 ? 0.5625f : 0.0f);
                    fArray[1] = 0.0f;
                    float f = fw == 5 ? 0.1875f : (fArray[2] = fw == 4 ? 0.5625f : 0.0f);
                    fArray[3] = fw == 3 ? 0.8125f : (fw == 2 ? 0.4375f : 1.0f);
                    fArray[4] = 1.0f;
                    fArray[5] = fw == 4 ? 0.8125f : (fw == 5 ? 0.4375f : 1.0f);
                    return fArray;
                }
            } else if (this.pos / 15 == 2 && this.pos % 5 == 2) {
                float[] fArray = new float[6];
                fArray[0] = fl == 5 ? 0.1875f : (fl == 4 ? 0.5625f : 0.0f);
                fArray[1] = 0.0f;
                float f = fl == 3 ? 0.1875f : (fArray[2] = fl == 2 ? 0.5625f : 0.0f);
                fArray[3] = fl == 4 ? 0.8125f : (fl == 5 ? 0.4375f : 1.0f);
                fArray[4] = 1.0f;
                fArray[5] = fl == 2 ? 0.8125f : (fl == 3 ? 0.4375f : 1.0f);
                return fArray;
            }
        } else {
            if (this.pos == 9) {
                return new float[]{fl == 5 ? 0.5f : 0.0f, 0.0f, fl == 3 ? 0.5f : 0.0f, fl == 4 ? 0.5f : 1.0f, 1.0f, fl == 2 ? 0.5f : 1.0f};
            }
            if (this.pos == 1 || this.pos == 3 || this.pos == 16 || this.pos == 18 || this.pos == 24 || this.pos >= 31 && this.pos <= 34) {
                return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            int f = this.facing;
            int il = this.pos / 15;
            int ih = this.pos % 15 / 5 - 1;
            int iw = this.pos % 5 - 2;
            if (this.mirrored) {
                iw = -iw;
            }
            int startX = this.xCoord - (f == 4 ? il : (f == 5 ? -il : (f == 2 ? -iw : iw)));
            int startY = this.yCoord - ih;
            int startZ = this.zCoord - (f == 2 ? il : (f == 3 ? -il : (f == 5 ? -iw : iw)));
            for (int l = 0; l < 3; ++l) {
                for (int w = -2; w <= 2; ++w) {
                    for (int h = -1; h <= 1; ++h) {
                        int ww;
                        int n = ww = this.mirrored ? -w : w;
                        int xx = f == 4 ? l : (f == 5 ? -l : (f == 2 ? -ww : ww));
                        int yy = h;
                        int zz = f == 2 ? l : (f == 3 ? -l : (f == 5 ? -ww : ww));
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityCrusher) {
                            s = ((TileEntityCrusher)te).getOriginalBlock();
                            ((TileEntityCrusher)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                            continue;
                        }
                        if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                            this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                        }
                        this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                    }
                }
            }
        }
    }

    public int getSizeInventory() {
        if (!this.formed || this.pos != 27) {
            return 0;
        }
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (!this.formed || this.pos != 27) {
            return;
        }
        TileEntityCrusher master = this.master();
        if (master != null) {
            master.addStackToInputs(stack);
        }
    }

    public String getInventoryName() {
        return "IECrusher";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer p_70300_1_) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed || this.pos != 27) {
            return false;
        }
        return this.isValidInput(stack);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        int[] nArray;
        if (this.formed && this.pos == 27 && side == ForgeDirection.UP.ordinal()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.formed && this.pos == 27 && side == ForgeDirection.UP.ordinal();
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 20 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityCrusher master = this.master();
        if (this.formed && master != null && this.pos == 20 && from == ForgeDirection.UP) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.markDirty();
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityCrusher master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityCrusher master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }
}

