/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityConveyorSorter
extends TileEntityIEBase
implements ISidedInventory {
    public SorterInventory filter;
    public int[] sideFilter = new int[]{0, 0, 0, 0, 0, 0};
    public static final int filterSlotsPerSide = 8;
    private boolean isRouting = false;

    public TileEntityConveyorSorter() {
        this.filter = new SorterInventory(this);
    }

    public boolean canUpdate() {
        return false;
    }

    public void routeItem(int inputSide, ItemStack stack) {
        block6: {
            int i;
            int rand;
            Integer[][] validOutputs;
            block7: {
                if (this.worldObj.isRemote) break block6;
                validOutputs = this.getValidOutputs(inputSide, stack, true, false);
                if (validOutputs[0].length > 0 && (stack = this.outputItemToInv(stack, validOutputs[0][rand = this.worldObj.rand.nextInt(validOutputs[0].length)])) != null) {
                    for (i = 0; i < validOutputs[0].length; ++i) {
                        if (i == rand || (stack = this.outputItemToInv(stack, validOutputs[0][i])) != null) {
                            continue;
                        }
                        break block6;
                    }
                }
                if (stack == null || validOutputs[1].length <= 0) break block7;
                rand = this.worldObj.rand.nextInt(validOutputs[1].length);
                ForgeDirection fd = ForgeDirection.getOrientation((int)validOutputs[1][rand]);
                EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)fd.offsetX, (double)this.yCoord + 0.5 + (double)fd.offsetY, (double)this.zCoord + 0.5 + (double)fd.offsetZ, stack.copy());
                ei.motionX = 0.075f * (float)fd.offsetX;
                ei.motionY = 0.025000000372529;
                ei.motionZ = 0.075f * (float)fd.offsetZ;
                this.worldObj.spawnEntityInWorld((Entity)ei);
                break block6;
            }
            if (validOutputs[2].length > 0 && (stack = this.outputItemToInv(stack, validOutputs[2][rand = this.worldObj.rand.nextInt(validOutputs[2].length)])) != null) {
                for (i = 0; i < validOutputs[2].length; ++i) {
                    if (i == rand || (stack = this.outputItemToInv(stack, validOutputs[2][rand])) != null) {
                        continue;
                    }
                    break block6;
                }
            }
            if (stack == null || validOutputs[3].length <= 0) break block6;
            rand = this.worldObj.rand.nextInt(validOutputs[3].length);
            ForgeDirection fd = ForgeDirection.getOrientation((int)validOutputs[1][rand]);
            EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)fd.offsetX, (double)this.yCoord + 0.5 + (double)fd.offsetY, (double)this.zCoord + 0.5 + (double)fd.offsetZ, stack.copy());
            ei.motionX = 0.075f * (float)fd.offsetX;
            ei.motionY = 0.025000000372529;
            ei.motionZ = 0.075f * (float)fd.offsetZ;
            this.worldObj.spawnEntityInWorld((Entity)ei);
        }
    }

    public boolean doOredict(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 1) != 0;
        }
        return false;
    }

    public boolean doNBT(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 2) != 0;
        }
        return false;
    }

    public boolean doFuzzy(int side) {
        if (side >= 0 && side < this.sideFilter.length) {
            return (this.sideFilter[side] & 4) != 0;
        }
        return false;
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.hasKey("sideConfig")) {
            this.sideFilter = message.getIntArray("sideConfig");
        }
    }

    public Integer[][] getValidOutputs(int inputSide, ItemStack stack, boolean allowUnmapped, boolean allowThrowing) {
        if (this.isRouting || stack == null) {
            return new Integer[][]{new Integer[0], new Integer[0], new Integer[0], new Integer[0]};
        }
        this.isRouting = true;
        ArrayList<Integer> validFilteredInvOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validFilteredEntityOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validUnfilteredInvOuts = new ArrayList<Integer>(6);
        ArrayList<Integer> validUnfilteredEntityOuts = new ArrayList<Integer>(6);
        for (int side = 0; side < 6; ++side) {
            ForgeDirection fd;
            if (side == inputSide) continue;
            boolean unmapped = true;
            boolean allowed = false;
            for (ItemStack filterStack : this.filter.filters[side]) {
                if (filterStack == null) continue;
                unmapped = false;
                boolean b = OreDictionary.itemMatches((ItemStack)filterStack, (ItemStack)stack, (boolean)true);
                if (!b && this.doFuzzy(side)) {
                    b = filterStack.getItem().equals(stack.getItem());
                }
                if (!b && this.doOredict(side)) {
                    for (String name : OreDictionary.getOreNames()) {
                        if (!Utils.compareToOreName(stack, name) || !Utils.compareToOreName(filterStack, name)) continue;
                        b = true;
                        break;
                    }
                }
                if (this.doNBT(side)) {
                    b &= ItemStack.areItemStackTagsEqual((ItemStack)filterStack, (ItemStack)stack);
                }
                if (!b) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                fd = ForgeDirection.getOrientation((int)side);
                TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
                if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side]) && Utils.canInsertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side])) {
                    validFilteredInvOuts.add(side);
                    continue;
                }
                if (!allowThrowing) continue;
                validFilteredEntityOuts.add(side);
                continue;
            }
            if (!allowUnmapped || !unmapped) continue;
            fd = ForgeDirection.getOrientation((int)side);
            TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
            if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side]) && Utils.canInsertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side])) {
                validUnfilteredInvOuts.add(side);
                continue;
            }
            if (!allowThrowing) continue;
            validUnfilteredEntityOuts.add(side);
        }
        this.isRouting = false;
        return new Integer[][]{validFilteredInvOuts.toArray(new Integer[validFilteredInvOuts.size()]), validFilteredEntityOuts.toArray(new Integer[validFilteredEntityOuts.size()]), validUnfilteredInvOuts.toArray(new Integer[validUnfilteredInvOuts.size()]), validUnfilteredEntityOuts.toArray(new Integer[validUnfilteredEntityOuts.size()])};
    }

    public void outputItem(ItemStack stack, int side) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)side);
        TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
        if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side]) && Utils.canInsertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side])) {
            stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side]);
        }
        if (stack != null) {
            EntityItem ei = new EntityItem(this.worldObj, (double)this.xCoord + 0.5 + (double)fd.offsetX, (double)this.yCoord + 0.5 + (double)fd.offsetY, (double)this.zCoord + 0.5 + (double)fd.offsetZ, stack.copy());
            ei.motionX = 0.075f * (float)fd.offsetX;
            ei.motionY = 0.025000000372529;
            ei.motionZ = 0.075f * (float)fd.offsetZ;
            this.worldObj.spawnEntityInWorld((Entity)ei);
        }
    }

    public ItemStack outputItemToInv(ItemStack stack, int side) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)side);
        TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
        if (this.isInventory(inventory, ForgeDirection.OPPOSITES[side])) {
            stack = Utils.insertStackIntoInventory((IInventory)inventory, stack, ForgeDirection.OPPOSITES[side]);
        }
        return stack;
    }

    boolean isInventory(TileEntity tile, int side) {
        if (tile instanceof ISidedInventory && ((ISidedInventory)tile).getAccessibleSlotsFromSide(side).length > 0) {
            return true;
        }
        return tile instanceof IInventory && ((IInventory)tile).getSizeInventory() > 0;
    }

    public int getSizeInventory() {
        return 6;
    }

    public ItemStack getStackInSlot(int slot) {
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.routeItem(slot, stack);
    }

    public String getInventoryName() {
        return "IERouter";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        Integer[][] outputs = this.getValidOutputs(slot, stack, true, false);
        return outputs[0].length > 0 || outputs[1].length > 0 || outputs[2].length > 0 || outputs[3].length > 0;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return new int[]{side};
    }

    public boolean canInsertItem(int slot, ItemStack item, int side) {
        return side == slot;
    }

    public boolean canExtractItem(int slot, ItemStack item, int side) {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.sideFilter = nbt.getIntArray("sideFilter");
        if (!descPacket) {
            NBTTagList filterList = nbt.getTagList("filter", 10);
            this.filter = new SorterInventory(this);
            this.filter.readFromNBT(filterList);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.setIntArray("sideFilter", this.sideFilter);
        if (!descPacket) {
            NBTTagList filterList = new NBTTagList();
            this.filter.writeToNBT(filterList);
            nbt.setTag("filter", (NBTBase)filterList);
        }
    }

    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return false;
    }

    public static class SorterInventory
    implements IInventory {
        public ItemStack[][] filters = new ItemStack[6][8];
        final TileEntityConveyorSorter tile;

        public SorterInventory(TileEntityConveyorSorter tile) {
            this.tile = tile;
        }

        public int getSizeInventory() {
            return 48;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.filters[slot / 8][slot % 8];
        }

        public ItemStack decrStackSize(int slot, int amount) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack != null) {
                if (stack.stackSize <= amount) {
                    this.setInventorySlotContents(slot, null);
                } else {
                    stack = stack.splitStack(amount);
                    if (stack.stackSize == 0) {
                        this.setInventorySlotContents(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack getStackInSlotOnClosing(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack != null) {
                this.setInventorySlotContents(slot, null);
            }
            return stack;
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            this.filters[slot / 8][slot % 8] = stack;
            if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
                stack.stackSize = this.getInventoryStackLimit();
            }
        }

        public String getInventoryName() {
            return "IESorterLayout";
        }

        public boolean hasCustomInventoryName() {
            return false;
        }

        public int getInventoryStackLimit() {
            return 1;
        }

        public boolean isUseableByPlayer(EntityPlayer player) {
            return true;
        }

        public void openInventory() {
        }

        public void closeInventory() {
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return true;
        }

        public void markDirty() {
            this.tile.markDirty();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.filters.length; ++i) {
                for (int j = 0; j < this.filters[i].length; ++j) {
                    if (this.filters[i][j] == null) continue;
                    NBTTagCompound itemTag = new NBTTagCompound();
                    itemTag.setByte("Slot", (byte)(i * 8 + j));
                    this.filters[i][j].writeToNBT(itemTag);
                    list.appendTag((NBTBase)itemTag);
                }
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound itemTag = list.getCompoundTagAt(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getSizeInventory()) continue;
                this.filters[slot / 8][slot % 8] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemTag);
            }
        }
    }
}

