/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.GregTechHelper;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import blusunrize.immersiveengineering.common.util.compat.ModCompatability;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.tile.IEnergySink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2")
public class TileEntityConnectorLV
extends TileEntityImmersiveConnectable
implements IEnergyHandler,
IEnergySink {
    boolean inICNet = false;
    public int facing = 0;
    private long lastTransfer = -1L;
    public int currentTickAccepted = 0;
    public static int[] connectorInputValues = new int[0];
    public int energyStored = 0;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            int temp;
            if (Lib.IC2 && !this.inICNet) {
                IC2Helper.loadIC2Tile(this);
                this.inICNet = true;
            }
            if (this.energyStored > 0 && (temp = this.transferEnergy(this.energyStored, true, 0)) > 0) {
                this.energyStored -= this.transferEnergy(temp, false, 0);
                this.markDirty();
            }
            this.currentTickAccepted = 0;
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.unload();
    }

    void unload() {
        if (Lib.IC2 && this.inICNet) {
            IC2Helper.unloadIC2Tile(this);
            this.inICNet = false;
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.unload();
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        TileEntity tile = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
        return tile != null && (tile instanceof IEnergyReceiver || Lib.IC2 && IC2Helper.isEnergySink(tile) || Lib.GREG && GregTechHelper.gregtech_isValidEnergyOutput(tile));
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        int acceptanceLeft = this.getMaxOutput() - this.currentTickAccepted;
        if (acceptanceLeft <= 0) {
            return 0;
        }
        int toAccept = Math.min(acceptanceLeft, amount);
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing);
        TileEntity capacitor = this.worldObj.getTileEntity(this.xCoord + fd.offsetX, this.yCoord + fd.offsetY, this.zCoord + fd.offsetZ);
        int ret = 0;
        if (capacitor instanceof IEnergyReceiver && ((IEnergyReceiver)capacitor).canConnectEnergy(fd.getOpposite())) {
            ret = ((IEnergyReceiver)capacitor).receiveEnergy(fd.getOpposite(), toAccept, simulate);
        } else if (Lib.IC2 && IC2Helper.isAcceptingEnergySink(capacitor, this, fd.getOpposite())) {
            double left = IC2Helper.injectEnergy(capacitor, fd.getOpposite(), ModCompatability.convertRFtoEU(toAccept, this.getIC2Tier()), this.canTakeHV() ? 65536.0 : (this.canTakeMV() ? 16384.0 : 1024.0), simulate);
            ret = toAccept - ModCompatability.convertEUtoRF(left);
        } else if (Lib.GREG && GregTechHelper.gregtech_isValidEnergyOutput(capacitor)) {
            int reConv;
            long translAmount = (long)ModCompatability.convertRFtoEU(toAccept, this.getIC2Tier());
            long accepted = GregTechHelper.gregtech_outputGTPower(capacitor, (byte)fd.getOpposite().ordinal(), translAmount, 1L, simulate);
            ret = reConv = ModCompatability.convertEUtoRF(accepted);
        }
        if (!simulate) {
            this.currentTickAccepted += ret;
        }
        return ret;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        nbt.setLong("lastTransfer", this.lastTransfer);
        nbt.setInteger("stored", this.energyStored);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.lastTransfer = nbt.getLong("lastTransfer");
        this.energyStored = nbt.getInteger("stored");
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        return Vec3.createVectorHelper((double)(0.5 + (double)fd.offsetX * 0.0625), (double)(0.5 + (double)fd.offsetY * 0.0625), (double)(0.5 + (double)fd.offsetZ * 0.0625));
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)this.facing).getOpposite();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return Vec3.createVectorHelper((double)(0.5 - conRadius * (double)fd.offsetX), (double)(0.5 - conRadius * (double)fd.offsetY), (double)(0.5 - conRadius * (double)fd.offsetZ));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            if (Config.getBoolean("increasedRenderboxes")) {
                int inc = this.getRenderRadiusIncrease();
                this.renderAABB = AxisAlignedBB.getBoundingBox((double)(this.xCoord - inc), (double)(this.yCoord - inc), (double)(this.zCoord - inc), (double)(this.xCoord + inc + 1), (double)(this.yCoord + inc + 1), (double)(this.zCoord + inc + 1));
            } else {
                this.renderAABB = super.getRenderBoundingBox();
            }
        }
        return this.renderAABB;
    }

    int getRenderRadiusIncrease() {
        return WireType.COPPER.getMaxLength();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from.ordinal() == this.facing;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.worldObj.isRemote) {
            return 0;
        }
        if (this.worldObj.getTotalWorldTime() == this.lastTransfer) {
            return 0;
        }
        int accepted = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), maxReceive);
        accepted = Math.min(this.getMaxOutput() - this.energyStored, accepted);
        if (accepted <= 0) {
            return 0;
        }
        if (!simulate) {
            this.energyStored += accepted;
            this.lastTransfer = this.worldObj.getTotalWorldTime();
            this.markDirty();
        }
        return accepted;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStored;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxInput();
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int transferEnergy(int energy, boolean simulate, int energyType) {
        int received = 0;
        if (!this.worldObj.isRemote) {
            int tempR;
            IImmersiveConnectable end;
            int powerLeft;
            Set<ImmersiveNetHandler.AbstractConnection> outputs = ImmersiveNetHandler.INSTANCE.getIndirectEnergyConnections(Utils.toCC(this), this.worldObj);
            int powerForSort = powerLeft = Math.min(Math.min(this.getMaxOutput(), this.getMaxInput()), energy);
            if (outputs.size() < 1) {
                return 0;
            }
            int sum = 0;
            HashMap<ImmersiveNetHandler.AbstractConnection, Integer> powerSorting = new HashMap<ImmersiveNetHandler.AbstractConnection, Integer>();
            for (ImmersiveNetHandler.AbstractConnection con : outputs) {
                int atmOut;
                end = Utils.toIIC(con.end, this.worldObj);
                if (con.cableType == null || end == null || (tempR = end.outputEnergy(atmOut = Math.min(powerForSort, con.cableType.getTransferRate()), true, energyType)) <= 0) continue;
                powerSorting.put(con, tempR);
                sum += tempR;
            }
            if (sum > 0) {
                for (ImmersiveNetHandler.AbstractConnection con : powerSorting.keySet()) {
                    end = Utils.toIIC(con.end, this.worldObj);
                    if (con.cableType == null || end == null) continue;
                    int output = (Integer)powerSorting.get(con);
                    int r = tempR = end.outputEnergy(Math.min(output, con.cableType.getTransferRate()), true, energyType);
                    int maxInput = this.getMaxInput();
                    tempR -= (int)Math.max(0.0, Math.floor((float)tempR * con.getPreciseLossRate(tempR, maxInput)));
                    end.outputEnergy(tempR, simulate, energyType);
                    HashSet<IImmersiveConnectable> passedConnectors = new HashSet<IImmersiveConnectable>();
                    float intermediaryLoss = 0.0f;
                    for (ImmersiveNetHandler.Connection sub : con.subConnections) {
                        float length = (float)sub.length / (float)sub.cableType.getMaxLength();
                        float baseLoss = (float)sub.cableType.getLossRatio();
                        float mod = (float)(maxInput - tempR) / (float)maxInput / 0.25f * 0.1f;
                        intermediaryLoss = MathHelper.clamp_float((float)(intermediaryLoss + length * (baseLoss + baseLoss * mod)), (float)0.0f, (float)1.0f);
                        int transferredPerCon = ImmersiveNetHandler.INSTANCE.getTransferedRates(this.worldObj.provider.dimensionId).containsKey(sub) ? ImmersiveNetHandler.INSTANCE.getTransferedRates(this.worldObj.provider.dimensionId).get(sub) : 0;
                        transferredPerCon += r;
                        if (simulate) continue;
                        ImmersiveNetHandler.INSTANCE.getTransferedRates(this.worldObj.provider.dimensionId).put(sub, transferredPerCon);
                        IImmersiveConnectable subStart = Utils.toIIC(sub.start, this.worldObj);
                        IImmersiveConnectable subEnd = Utils.toIIC(sub.end, this.worldObj);
                        if (subStart != null && passedConnectors.add(subStart)) {
                            subStart.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                        }
                        if (subEnd == null || !passedConnectors.add(subEnd)) continue;
                        subEnd.onEnergyPassthrough((int)((float)r - (float)r * intermediaryLoss));
                    }
                    received += r;
                    if ((powerLeft -= r) > 0) continue;
                    break;
                }
            }
        }
        return received;
    }

    public int getMaxInput() {
        return connectorInputValues[0];
    }

    public int getMaxOutput() {
        return connectorInputValues[0];
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return Lib.IC2 && this.canConnectEnergy(direction);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return ModCompatability.convertRFtoEU(this.getMaxInput() - this.energyStored, this.getIC2Tier());
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return this.getIC2Tier();
    }

    int getIC2Tier() {
        return this.canTakeHV() ? 3 : (this.canTakeMV() ? 2 : 1);
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        int rf = ModCompatability.convertEUtoRF(amount);
        int r = Math.min(this.getMaxInput() - this.energyStored, rf);
        this.energyStored += r;
        double eu = ModCompatability.convertRFtoEU(r, this.getIC2Tier());
        return amount - eu;
    }
}

