/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityStructuralArm;
import blusunrize.immersiveengineering.common.blocks.multiblocks.MultiblockAssembler;
import blusunrize.immersiveengineering.common.util.Utils;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityAssembler
extends TileEntityMultiblockPart
implements ISidedInventory,
IEnergyReceiver,
IFluidHandler {
    public int facing = 2;
    public EnergyStorage energyStorage = new EnergyStorage(16000);
    public ItemStack[] inventory = new ItemStack[21];
    public CrafterPatternInventory[] patterns = new CrafterPatternInventory[]{new CrafterPatternInventory(this), new CrafterPatternInventory(this), new CrafterPatternInventory(this)};
    public FluidTank[] tanks = new FluidTank[]{new FluidTank(8000), new FluidTank(8000), new FluidTank(8000)};
    public boolean computerControlled = false;
    public boolean[] computerOn = new boolean[3];
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public TileEntityAssembler master() {
        if (this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0) {
            return null;
        }
        TileEntity te = this.worldObj.getTileEntity(this.xCoord - this.offset[0], this.yCoord - this.offset[1], this.zCoord - this.offset[2]);
        return te instanceof TileEntityAssembler ? (TileEntityAssembler)te : null;
    }

    @Override
    public ItemStack getOriginalBlock() {
        if (this.pos < 0) {
            return null;
        }
        ItemStack s = MultiblockAssembler.instance.getStructureManual()[this.pos / 9][this.pos % 9 / 3][this.pos % 3];
        return s != null ? s.copy() : null;
    }

    public void updateEntity() {
        if (!this.formed || this.pos != 13) {
            return;
        }
        if (this.worldObj.isRemote || this.worldObj.getTotalWorldTime() % 16L != (long)((this.xCoord ^ this.zCoord) & 0xF)) {
            return;
        }
        boolean update = false;
        ItemStack[][] outputBuffer = new ItemStack[this.patterns.length][0];
        for (int p = 0; p < this.patterns.length; ++p) {
            if (this.computerControlled && !this.computerOn[p]) continue;
            CrafterPatternInventory pattern = this.patterns[p];
            if (pattern.inv[9] == null || !this.canOutput(pattern.inv[9], p)) continue;
            ItemStack output = pattern.inv[9].copy();
            ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
            ItemStack[][] itemStackArray = outputBuffer;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack[] itemStackArray2;
                for (ItemStack stack : itemStackArray2 = itemStackArray[i]) {
                    if (stack == null) continue;
                    queryList.add(stack.copy());
                }
            }
            for (ItemStack[] itemStackArray3 : this.inventory) {
                if (itemStackArray3 == null) continue;
                queryList.add(itemStackArray3.copy());
            }
            int consumed = Config.getInt("assembler_consumption");
            if (!this.hasIngredients(pattern, queryList) || this.energyStorage.extractEnergy(consumed, true) != consumed) continue;
            this.energyStorage.extractEnergy(consumed, false);
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(output);
            Object[] oreInputs = null;
            ArrayList arrayList = new ArrayList();
            if (pattern.recipe instanceof ShapedOreRecipe || pattern.recipe instanceof ShapelessOreRecipe) {
                oreInputs = pattern.recipe instanceof ShapedOreRecipe ? ((ShapedOreRecipe)pattern.recipe).getInput() : ((ShapelessOreRecipe)pattern.recipe).getInput().toArray();
            }
            for (int i = 0; i < 9; ++i) {
                if (pattern.inv[i] == null) continue;
                Object query = pattern.inv[i].copy();
                int querySize = pattern.inv[i].stackSize;
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]) != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]);
                    fs.amount *= querySize;
                    boolean hasFluid = false;
                    for (FluidTank tank : this.tanks) {
                        if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                        hasFluid = true;
                        break;
                    }
                    if (hasFluid) {
                        query = fs;
                    }
                }
                if (query instanceof ItemStack && oreInputs != null) {
                    for (int iOre = 0; iOre < oreInputs.length; ++iOre) {
                        if (arrayList.contains(iOre) || !Utils.stackMatchesObject(query, oreInputs[iOre], true)) continue;
                        query = oreInputs[iOre];
                        querySize = 1;
                        break;
                    }
                }
                boolean taken = false;
                for (int j = 0; j < outputBuffer.length && !(taken = this.consumeItem(query, querySize, outputBuffer[j], outputList)); ++j) {
                }
                if (taken) continue;
                this.consumeItem(query, querySize, this.inventory, outputList);
            }
            outputBuffer[p] = outputList.toArray(new ItemStack[outputList.size()]);
            update = true;
        }
        TileEntity inventory = this.worldObj.getTileEntity(this.xCoord + (this.facing == 4 ? 2 : (this.facing == 5 ? -2 : 0)), this.yCoord, this.zCoord + (this.facing == 2 ? 2 : (this.facing == 3 ? -2 : 0)));
        block8: for (int buffer = 0; buffer < outputBuffer.length; ++buffer) {
            if (outputBuffer[buffer] == null || outputBuffer[buffer].length <= 0) continue;
            for (int iOutput = 0; iOutput < outputBuffer[buffer].length; ++iOutput) {
                ItemStack output = outputBuffer[buffer][iOutput];
                if (output == null || output.stackSize <= 0 || !this.isRecipeIngredient(output, buffer) && (inventory instanceof ISidedInventory && ((ISidedInventory)inventory).getAccessibleSlotsFromSide(this.facing).length > 0 || inventory instanceof IInventory && ((IInventory)inventory).getSizeInventory() > 0) && ((output = Utils.insertStackIntoInventory((IInventory)inventory, output, this.facing)) == null || output.stackSize <= 0)) continue;
                int free = -1;
                if (iOutput == 0) {
                    if (this.inventory[18 + buffer] == null && free < 0) {
                        free = 18 + buffer;
                    } else if (this.inventory[18 + buffer] != null && OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[18 + buffer], (boolean)true) && this.inventory[18 + buffer].stackSize + output.stackSize <= this.inventory[18 + buffer].getMaxStackSize()) {
                        this.inventory[18 + buffer].stackSize += output.stackSize;
                        free = -1;
                        continue block8;
                    }
                } else {
                    for (int i = 0; i < this.inventory.length; ++i) {
                        if (this.inventory[i] == null && free < 0) {
                            free = i;
                            continue;
                        }
                        if (this.inventory[i] == null || !OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[i], (boolean)true) || this.inventory[i].stackSize + output.stackSize > this.inventory[i].getMaxStackSize()) continue;
                        this.inventory[i].stackSize += output.stackSize;
                        free = -1;
                        break;
                    }
                }
                if (free < 0) continue;
                this.inventory[free] = output.copy();
            }
        }
        for (int i = 0; i < 3; ++i) {
            if ((!(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).getAccessibleSlotsFromSide(this.facing).length <= 0) && (!(inventory instanceof IInventory) || ((IInventory)inventory).getSizeInventory() <= 0) || this.isRecipeIngredient(this.inventory[18 + i], i)) continue;
            this.inventory[18 + i] = Utils.insertStackIntoInventory((IInventory)inventory, this.inventory[18 + i], this.facing);
        }
        if (update) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public boolean consumeItem(Object query, int querySize, ItemStack[] inventory, ArrayList<ItemStack> containerItems) {
        if (query instanceof FluidStack) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid() == null || !tank.getFluid().containsFluid((FluidStack)query)) continue;
                tank.drain(((FluidStack)query).amount, true);
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                return true;
            }
        }
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !Utils.stackMatchesObject(inventory[i], query, true)) continue;
            int taken = Math.min(querySize, inventory[i].stackSize);
            boolean doTake = true;
            if (inventory[i].getItem().hasContainerItem(inventory[i])) {
                ItemStack container = inventory[i].getItem().getContainerItem(inventory[i]);
                if (container != null && inventory[i].getItem().doesContainerItemLeaveCraftingGrid(inventory[i])) {
                    containerItems.add(container.copy());
                    if (inventory[i].stackSize - taken <= 0) {
                        inventory[i] = null;
                        doTake = false;
                    }
                } else if (inventory[i].stackSize - taken <= 0) {
                    inventory[i] = container;
                    doTake = false;
                }
            }
            if (doTake) {
                inventory[i].stackSize -= taken;
                if (inventory[i].stackSize <= 0) {
                    inventory[i] = null;
                }
            }
            if ((querySize -= taken) <= 0) break;
        }
        return query == null || querySize <= 0;
    }

    public boolean hasIngredients(CrafterPatternInventory pattern, ArrayList<ItemStack> queryList) {
        Object[] oreInputs = null;
        ArrayList usedOreSlots = new ArrayList();
        if (pattern.recipe instanceof ShapedOreRecipe || pattern.recipe instanceof ShapelessOreRecipe) {
            oreInputs = pattern.recipe instanceof ShapedOreRecipe ? ((ShapedOreRecipe)pattern.recipe).getInput() : ((ShapelessOreRecipe)pattern.recipe).getInput().toArray();
        }
        boolean match = true;
        for (int i = 0; i < 9; ++i) {
            if (pattern.inv[i] == null) continue;
            if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]) != null) {
                FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)pattern.inv[i]);
                boolean hasFluid = false;
                for (FluidTank tank : this.tanks) {
                    if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                    hasFluid = true;
                    break;
                }
                if (hasFluid) continue;
            }
            Object query = pattern.inv[i].copy();
            int querySize = pattern.inv[i].stackSize;
            if (oreInputs != null) {
                for (int iOre = 0; iOre < oreInputs.length; ++iOre) {
                    if (usedOreSlots.contains(iOre) || !Utils.stackMatchesObject(query, oreInputs[iOre], true)) continue;
                    query = oreInputs[iOre];
                    querySize = 1;
                    break;
                }
            }
            Iterator<ItemStack> it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!Utils.stackMatchesObject(next, query, true)) continue;
                int taken = Math.min(querySize, next.stackSize);
                next.stackSize -= taken;
                if (next.stackSize <= 0) {
                    it.remove();
                }
                if ((querySize -= taken) > 0) continue;
                break;
            }
            if (querySize <= 0) continue;
            match = false;
            break;
        }
        return match;
    }

    public boolean canOutput(ItemStack output, int iPattern) {
        if (this.inventory[18 + iPattern] == null) {
            return true;
        }
        return OreDictionary.itemMatches((ItemStack)output, (ItemStack)this.inventory[18 + iPattern], (boolean)true) && ItemStack.areItemStackTagsEqual((ItemStack)output, (ItemStack)this.inventory[18 + iPattern]) && this.inventory[18 + iPattern].stackSize + output.stackSize <= this.inventory[18 + iPattern].getMaxStackSize();
    }

    public boolean isRecipeIngredient(ItemStack stack, int slot) {
        if (slot - 1 < this.patterns.length) {
            for (int p = slot + 1; p < this.patterns.length; ++p) {
                CrafterPatternInventory pattern = this.patterns[p];
                for (int i = 0; i < 9; ++i) {
                    if (pattern.inv[i] == null || !OreDictionary.itemMatches((ItemStack)pattern.inv[i], (ItemStack)stack, (boolean)false)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.getInteger("facing");
        this.energyStorage.readFromNBT(nbt);
        this.tanks[0].readFromNBT(nbt.getCompoundTag("tank0"));
        this.tanks[1].readFromNBT(nbt.getCompoundTag("tank1"));
        this.tanks[2].readFromNBT(nbt.getCompoundTag("tank2"));
        if (!descPacket) {
            this.inventory = Utils.readInventory(nbt.getTagList("inventory", 10), 21);
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = nbt.getTagList("pattern" + iPattern, 10);
                this.patterns[iPattern] = new CrafterPatternInventory(this);
                this.patterns[iPattern].readFromNBT(patternList);
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("facing", this.facing);
        this.energyStorage.writeToNBT(nbt);
        NBTTagCompound tankTag0 = this.tanks[0].writeToNBT(new NBTTagCompound());
        nbt.setTag("tank0", (NBTBase)tankTag0);
        NBTTagCompound tankTag1 = this.tanks[1].writeToNBT(new NBTTagCompound());
        nbt.setTag("tank1", (NBTBase)tankTag1);
        NBTTagCompound tankTag2 = this.tanks[2].writeToNBT(new NBTTagCompound());
        nbt.setTag("tank2", (NBTBase)tankTag2);
        if (!descPacket) {
            nbt.setTag("inventory", (NBTBase)Utils.writeInventory(this.inventory));
            for (int iPattern = 0; iPattern < this.patterns.length; ++iPattern) {
                NBTTagList patternList = new NBTTagList();
                this.patterns[iPattern].writeToNBT(patternList);
                nbt.setTag("pattern" + iPattern, (NBTBase)patternList);
            }
        }
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        block4: {
            block3: {
                if (!message.hasKey("buttonID")) break block3;
                int id = message.getInteger("buttonID");
                if (id < 0 || id >= this.patterns.length) break block4;
                CrafterPatternInventory pattern = this.patterns[id];
                for (int i = 0; i < pattern.inv.length; ++i) {
                    pattern.inv[i] = null;
                }
                break block4;
            }
            if (message.hasKey("patternSync")) {
                int r = message.getInteger("recipe");
                NBTTagList list = message.getTagList("patternSync", 10);
                CrafterPatternInventory pattern = this.patterns[r];
                for (int i = 0; i < list.tagCount(); ++i) {
                    NBTTagCompound itemTag = list.getCompoundTagAt(i);
                    pattern.inv[itemTag.getInteger((String)"slot")] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemTag);
                }
            }
        }
    }

    public boolean receiveClientEvent(int id, int arg) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.pos == 4 ? AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)this.yCoord, (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 3), (double)(this.zCoord + 2)) : AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord);
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        return super.getMaxRenderDistanceSquared() * Config.getDouble("increasedTileRenderdistance");
    }

    @Override
    public float[] getBlockBounds() {
        if (this.pos < 9 || this.pos == 10 || this.pos == 13 || this.pos == 16 || this.pos == 22) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        }
        float xMin = 0.0f;
        float yMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float yMax = 1.0f;
        float zMax = 1.0f;
        if (this.pos % 9 < 3 && this.facing == 2 || this.pos % 9 >= 6 && this.facing == 3) {
            zMin = 0.25f;
        } else if (this.pos % 9 < 3 && this.facing == 3 || this.pos % 9 >= 6 && this.facing == 2) {
            zMax = 0.75f;
        } else if (this.pos % 9 < 3 && this.facing == 4 || this.pos % 9 >= 6 && this.facing == 5) {
            xMin = 0.25f;
        } else if (this.pos % 9 < 3 && this.facing == 5 || this.pos % 9 >= 6 && this.facing == 4) {
            xMax = 0.75f;
        }
        if (this.pos % 3 == 0 && this.facing == 4 || this.pos % 3 == 2 && this.facing == 5) {
            zMin = 0.1875f;
        } else if (this.pos % 3 == 0 && this.facing == 5 || this.pos % 3 == 2 && this.facing == 4) {
            zMax = 0.8125f;
        } else if (this.pos % 3 == 0 && this.facing == 3 || this.pos % 3 == 2 && this.facing == 2) {
            xMin = 0.1875f;
        } else if (this.pos % 3 == 0 && this.facing == 2 || this.pos % 3 == 2 && this.facing == 3) {
            xMax = 0.8125f;
        }
        return new float[]{xMin, yMin, zMin, xMax, yMax, zMax};
    }

    public void invalidate() {
        super.invalidate();
        if (this.formed && !this.worldObj.isRemote) {
            TileEntityAssembler master = this.master();
            if (master == null) {
                master = this;
            }
            int startX = master.xCoord;
            int startY = master.yCoord;
            int startZ = master.zCoord;
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    for (int xx = -1; xx <= 1; ++xx) {
                        ItemStack s = null;
                        TileEntity te = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (te instanceof TileEntityAssembler) {
                            s = ((TileEntityAssembler)te).getOriginalBlock();
                            ((TileEntityAssembler)te).formed = false;
                        }
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.getBlockFromItem((Item)s.getItem()) == null) continue;
                        if (startX + xx == this.xCoord && startY + yy == this.yCoord && startZ + zz == this.zCoord) {
                            this.worldObj.spawnEntityInWorld((Entity)new EntityItem(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, s));
                        } else {
                            if (Block.getBlockFromItem((Item)s.getItem()) == IEContent.blockMetalMultiblocks) {
                                this.worldObj.setBlockToAir(startX + xx, startY + yy, startZ + zz);
                            }
                            this.worldObj.setBlock(startX + xx, startY + yy, startZ + zz, Block.getBlockFromItem((Item)s.getItem()), s.getItemDamage(), 3);
                        }
                        TileEntity tile = this.worldObj.getTileEntity(startX + xx, startY + yy, startZ + zz);
                        if (!(tile instanceof TileEntityStructuralArm)) continue;
                        ((TileEntityStructuralArm)tile).facing = this.facing < 4 ? (xx == -1 ? 4 : 5) : (zz == -1 ? 2 : 3);
                    }
                }
            }
        }
    }

    public int getSizeInventory() {
        if (!this.formed) {
            return 0;
        }
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityAssembler master = this.master();
        if (master != null) {
            return master.getStackInSlot(slot);
        }
        if (slot < this.inventory.length) {
            return this.inventory[slot];
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        if (!this.formed) {
            return null;
        }
        TileEntityAssembler master = this.master();
        if (master != null) {
            return master.decrStackSize(slot, amount);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize <= amount) {
                this.setInventorySlotContents(slot, null);
            } else {
                stack = stack.splitStack(amount);
                if (stack.stackSize == 0) {
                    this.setInventorySlotContents(slot, null);
                }
            }
        }
        this.markDirty();
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (!this.formed) {
            return null;
        }
        TileEntityAssembler master = this.master();
        if (master != null) {
            return master.getStackInSlotOnClosing(slot);
        }
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        if (!this.formed) {
            return;
        }
        TileEntityAssembler master = this.master();
        if (master != null) {
            master.setInventorySlotContents(slot, stack);
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public String getInventoryName() {
        return "IEAssembler";
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.worldObj.getTileEntity(this.xCoord, this.yCoord, this.zCoord) != this ? false : this.formed && player.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!this.formed || stack == null) {
            return false;
        }
        TileEntityAssembler master = this.master();
        if (master != null && slot < 18) {
            return master.isItemValidForSlot(slot, stack);
        }
        return true;
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (!this.formed) {
            return new int[0];
        }
        if (this.pos == 10 || this.pos == 16) {
            return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
        }
        return new int[0];
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return true;
        }
        TileEntityAssembler master = this.master();
        if (master == null) {
            return this.isItemValidForSlot(slot, stack);
        }
        if (this.pos == 10) {
            return master.canInsertItem(slot, stack, side);
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        if (!this.formed) {
            return true;
        }
        TileEntityAssembler master = this.master();
        if (master == null) {
            return true;
        }
        if (this.pos == 16) {
            return master.canExtractItem(slot, stack, side);
        }
        return false;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.formed && this.pos == 22 && from == ForgeDirection.UP;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        TileEntityAssembler master = this.master();
        if (this.formed && this.pos == 22 && from == ForgeDirection.UP && master != null) {
            int rec = master.energyStorage.receiveEnergy(maxReceive, simulate);
            master.markDirty();
            if (rec > 0) {
                this.worldObj.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
            }
            return rec;
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        TileEntityAssembler master = this.master();
        if (master != null) {
            return master.energyStorage.getEnergyStored();
        }
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        TileEntityAssembler master = this.master();
        if (master != null) {
            return master.energyStorage.getMaxEnergyStored();
        }
        return this.energyStorage.getMaxEnergyStored();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TileEntityAssembler master = this.master();
        if (master != null) {
            return master.fill(from, resource, doFill);
        }
        int fill = -1;
        for (FluidTank tank : this.tanks) {
            if (tank.getFluid() == null || !tank.getFluid().isFluidEqual(resource)) continue;
            fill = tank.fill(resource, doFill);
            break;
        }
        if (fill == -1) {
            FluidTank tank;
            FluidTank[] fluidTankArray = this.tanks;
            int n = fluidTankArray.length;
            for (int i = 0; i < n && (fill = (tank = fluidTankArray[i]).fill(resource, doFill)) <= 0; ++i) {
            }
        }
        if (fill > 0) {
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        return fill < 0 ? 0 : fill;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.formed && this.pos == 1 && from == ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.pos == 1 && from == ForgeDirection.getOrientation((int)this.facing)) {
            TileEntityAssembler master = this.master();
            if (master != null) {
                return new FluidTankInfo[]{master.tanks[0].getInfo(), master.tanks[1].getInfo(), master.tanks[2].getInfo()};
            }
            return new FluidTankInfo[]{this.tanks[0].getInfo(), this.tanks[1].getInfo(), this.tanks[2].getInfo()};
        }
        return new FluidTankInfo[0];
    }

    public static class CrafterPatternInventory
    implements IInventory {
        public ItemStack[] inv = new ItemStack[10];
        public IRecipe recipe;
        final TileEntityAssembler tile;

        public CrafterPatternInventory(TileEntityAssembler tile) {
            this.tile = tile;
        }

        public int getSizeInventory() {
            return 10;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inv[slot];
        }

        public ItemStack decrStackSize(int slot, int amount) {
            ItemStack stack = this.getStackInSlot(slot);
            if (slot < 9 && stack != null) {
                if (stack.stackSize <= amount) {
                    this.setInventorySlotContents(slot, null);
                } else {
                    stack = stack.splitStack(amount);
                    if (stack.stackSize == 0) {
                        this.setInventorySlotContents(slot, null);
                    }
                }
            }
            return stack;
        }

        public ItemStack getStackInSlotOnClosing(int slot) {
            ItemStack stack = this.getStackInSlot(slot);
            if (stack != null) {
                this.setInventorySlotContents(slot, null);
            }
            return stack;
        }

        public void setInventorySlotContents(int slot, ItemStack stack) {
            if (slot < 9) {
                this.inv[slot] = stack;
                if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
                    stack.stackSize = this.getInventoryStackLimit();
                }
            }
            this.recalculateOutput();
        }

        public void recalculateOutput() {
            Utils.InventoryCraftingFalse invC = new Utils.InventoryCraftingFalse(3, 3);
            for (int j = 0; j < 9; ++j) {
                invC.setInventorySlotContents(j, this.inv[j]);
            }
            this.recipe = Utils.findRecipe(invC, this.tile.getWorldObj());
            this.inv[9] = this.recipe != null ? this.recipe.getCraftingResult((InventoryCrafting)invC) : null;
        }

        public ArrayList<ItemStack> getTotalPossibleOutputs() {
            ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
            outputList.add(this.inv[9].copy());
            for (int i = 0; i < 9; ++i) {
                ItemStack container;
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inv[i]) != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inv[i]);
                    boolean hasFluid = false;
                    for (FluidTank tank : this.tile.tanks) {
                        if (tank.getFluid() == null || !tank.getFluid().containsFluid(fs)) continue;
                        hasFluid = true;
                        break;
                    }
                    if (hasFluid) continue;
                }
                if ((container = this.inv[i].getItem().getContainerItem(this.inv[i])) == null || !this.inv[i].getItem().doesContainerItemLeaveCraftingGrid(this.inv[i])) continue;
                outputList.add(container.copy());
            }
            return outputList;
        }

        public String getInventoryName() {
            return "IECrafterPattern";
        }

        public boolean hasCustomInventoryName() {
            return false;
        }

        public int getInventoryStackLimit() {
            return 1;
        }

        public boolean isUseableByPlayer(EntityPlayer player) {
            return true;
        }

        public void openInventory() {
        }

        public void closeInventory() {
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return true;
        }

        public void markDirty() {
            this.tile.markDirty();
        }

        public void writeToNBT(NBTTagList list) {
            for (int i = 0; i < this.inv.length; ++i) {
                if (this.inv[i] == null) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.setByte("Slot", (byte)i);
                this.inv[i].writeToNBT(itemTag);
                list.appendTag((NBTBase)itemTag);
            }
        }

        public void readFromNBT(NBTTagList list) {
            for (int i = 0; i < list.tagCount(); ++i) {
                NBTTagCompound itemTag = list.getCompoundTagAt(i);
                int slot = itemTag.getByte("Slot") & 0xFF;
                if (slot < 0 || slot >= this.getSizeInventory()) continue;
                this.inv[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemTag);
            }
            this.recalculateOutput();
        }
    }
}

