/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBlastFurnacePreheater;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBreakerSwitch;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityChargingStation;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityEnergyMeter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFloodlight;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class ItemBlockMetalDevices2
extends ItemBlockIEBase {
    public ItemBlockMetalDevices2(Block b) {
        super(b);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean advInfo) {
        if (stack.getItemDamage() == 7) {
            if (stack.hasTagCompound()) {
                NBTTagCompound tag = stack.getTagCompound().getCompoundTag("tank");
                if (!tag.hasKey("Empty")) {
                    FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
                    list.add(fluid.getLocalizedName() + ": " + fluid.amount + "mB");
                } else {
                    list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.barrel"));
                }
            } else {
                list.add(StatCollector.translateToLocal((String)"desc.ImmersiveEngineering.flavour.barrel"));
            }
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int f;
        int playerViewQuarter = MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 0.5)) & 3;
        int n = playerViewQuarter == 0 ? 2 : (playerViewQuarter == 1 ? 5 : (f = playerViewQuarter == 2 ? 3 : 4));
        if (!(meta != 6 && meta != 2 || world.isAirBlock(x, y + 1, z))) {
            return false;
        }
        if (!(meta != 11 || world.isAirBlock(x, y + 1, z) && world.isAirBlock(x, y + 2, z))) {
            return false;
        }
        boolean ret = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, meta);
        if (!ret) {
            return false;
        }
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityBreakerSwitch) {
            if (side < 2) {
                ((TileEntityBreakerSwitch)tileEntity).sideAttached = ForgeDirection.OPPOSITES[side] + 1;
                ((TileEntityBreakerSwitch)tileEntity).facing = f;
            } else {
                ((TileEntityBreakerSwitch)tileEntity).facing = ForgeDirection.OPPOSITES[side];
            }
        } else if (tileEntity instanceof TileEntityEnergyMeter) {
            ((TileEntityEnergyMeter)tileEntity).facing = f;
            ((TileEntityEnergyMeter)tileEntity).dummy = true;
            world.setBlock(x, y + 1, z, (Block)IEContent.blockMetalDevice2, 2, 3);
            TileEntity tileEntityOther = world.getTileEntity(x, y + 1, z);
            if (tileEntityOther instanceof TileEntityEnergyMeter) {
                ((TileEntityEnergyMeter)tileEntityOther).facing = f;
            }
        } else if (tileEntity instanceof TileEntityFloodlight) {
            ((TileEntityFloodlight)tileEntity).side = side;
            if (f == side && player.rotationPitch > 0.0f) {
                f = ForgeDirection.OPPOSITES[f];
            }
            ((TileEntityFloodlight)tileEntity).facing = f;
        } else if (tileEntity instanceof TileEntityFluidPump) {
            ((TileEntityFluidPump)tileEntity).dummy = false;
            world.setBlock(x, y + 1, z, (Block)IEContent.blockMetalDevice2, 6, 3);
        } else if (tileEntity instanceof TileEntityWoodenBarrel) {
            if (stack.hasTagCompound()) {
                ((TileEntityWoodenBarrel)tileEntity).readTank(stack.getTagCompound());
            }
        } else if (tileEntity instanceof TileEntityChargingStation) {
            ((TileEntityChargingStation)tileEntity).facing = f;
        } else if (tileEntity instanceof TileEntityBlastFurnacePreheater) {
            ((TileEntityBlastFurnacePreheater)tileEntity).facing = f;
            for (int i = 1; i <= 2; ++i) {
                world.setBlock(x, y + i, z, (Block)IEContent.blockMetalDevice2, 11, 3);
                ((TileEntityBlastFurnacePreheater)world.getTileEntity((int)x, (int)(y + i), (int)z)).dummy = i;
                ((TileEntityBlastFurnacePreheater)world.getTileEntity((int)x, (int)(y + i), (int)z)).facing = f;
            }
        }
        return ret;
    }
}

