/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.client.render.BlockRenderMetalMultiblocks;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBucketWheel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDieselGenerator;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityExcavator;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFermenter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityLightningRod;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalPress;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySheetmetalTank;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySilo;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySqueezer;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidContainerItem;

public class BlockMetalMultiblocks
extends BlockIEBase
implements IEBlockInterfaces.ICustomBoundingboxes {
    public static final int META_lightningRod = 0;
    public static final int META_dieselGenerator = 1;
    public static final int META_squeezer = 2;
    public static final int META_fermenter = 3;
    public static final int META_refinery = 4;
    public static final int META_crusher = 5;
    public static final int META_bucketWheel = 6;
    public static final int META_excavator = 7;
    public static final int META_arcFurnace = 8;
    public static final int META_tank = 9;
    public static final int META_silo = 10;
    public static final int META_assembler = 11;
    public static final int META_bottlingMachine = 12;
    public static final int META_metalPress = 13;

    public BlockMetalMultiblocks() {
        super("metalMultiblock", Material.iron, 4, ItemBlockIEBase.class, "lightningRod", "dieselGenerator", "industrialSqueezer", "fermenter", "refinery", "crusher", "bucketWheel", "excavator", "arcFurnace", "tank", "silo", "assembler", "bottlingMachine", "metalPress");
        this.setHardness(3.0f);
        this.setResistance(15.0f);
    }

    @Override
    public boolean allowHammerHarvest(int meta) {
        return true;
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            if (i != 0 && i != 2 && i != 3) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons[0][0] = iconRegister.registerIcon("immersiveengineering:metal_lightningrod_top");
        this.icons[0][1] = iconRegister.registerIcon("immersiveengineering:metal_lightningrod_top");
        this.icons[0][2] = iconRegister.registerIcon("immersiveengineering:metal_lightningrod_side");
        this.icons[0][3] = iconRegister.registerIcon("immersiveengineering:metal_lightningrod_side");
        this.icons[2][0] = iconRegister.registerIcon("immersiveengineering:metal_squeezer");
        this.icons[2][1] = iconRegister.registerIcon("immersiveengineering:metal_multiblockTop");
        this.icons[2][2] = iconRegister.registerIcon("immersiveengineering:metal_multiblockSqueezer0");
        this.icons[2][3] = iconRegister.registerIcon("immersiveengineering:metal_multiblockSqueezer1");
        this.icons[3][0] = iconRegister.registerIcon("immersiveengineering:metal_fermenter");
        this.icons[3][1] = iconRegister.registerIcon("immersiveengineering:metal_multiblockTop");
        this.icons[3][2] = iconRegister.registerIcon("immersiveengineering:metal_multiblockFermenter0");
        this.icons[3][3] = iconRegister.registerIcon("immersiveengineering:metal_multiblockFermenter1");
        this.icons[1][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_dieselGenerator");
        this.icons[4][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_refinery");
        this.icons[5][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_crusher");
        this.icons[7][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_excavator");
        this.icons[8][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_arcFurnace");
        this.icons[11][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_assembler");
        this.icons[12][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_bottlingMachine");
        this.icons[13][0] = iconRegister.registerIcon("immersiveengineering:metal_multiblock_metalPress");
        for (int i = 0; i < 4; ++i) {
            this.icons[6][i] = iconRegister.registerIcon("immersiveengineering:storage_Steel");
            this.icons[9][i] = iconRegister.registerIcon("immersiveengineering:storage_Steel");
            this.icons[10][i] = iconRegister.registerIcon("immersiveengineering:storage_Steel");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (world.getBlockMetadata(x, y, z) == 2) {
            if (te instanceof TileEntitySqueezer && ((TileEntitySqueezer)te).formed) {
                return this.icons[2][side == 0 || side == 1 ? 1 : (((TileEntitySqueezer)te).facing == side ? 2 : 3)];
            }
            return this.icons[2][0];
        }
        if (world.getBlockMetadata(x, y, z) == 3) {
            if (te instanceof TileEntityFermenter && ((TileEntityFermenter)te).formed) {
                return this.icons[3][side == 0 || side == 1 ? 1 : (((TileEntityFermenter)te).facing == side ? 2 : 3)];
            }
            return this.icons[3][0];
        }
        if (world.getBlockMetadata(x, y, z) == 4) {
            if (te instanceof TileEntityRefinery && ((TileEntityRefinery)te).formed) {
                return this.icons[4][side == 0 || side == 1 ? 1 : (((TileEntityRefinery)te).facing == side ? 2 : 3)];
            }
            return this.icons[4][0];
        }
        return super.getIcon(world, x, y, z, side);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return BlockRenderMetalMultiblocks.renderID;
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityMultiblockPart && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
            TileEntityMultiblockPart tile = (TileEntityMultiblockPart)tileEntity;
            if (!tile.formed && tile.pos == -1 && tile.getOriginalBlock() != null) {
                world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, tile.getOriginalBlock().copy()));
            }
            if (tileEntity instanceof IInventory && !world.isRemote && ((TileEntityMultiblockPart)tileEntity).formed) {
                TileEntityMultiblockPart master = ((TileEntityMultiblockPart)tileEntity).master();
                if (master == null) {
                    master = tileEntity;
                }
                for (int i = 0; i < ((IInventory)master).getSizeInventory(); ++i) {
                    ItemStack stack = ((IInventory)master).getStackInSlot(i);
                    if (stack == null) continue;
                    float fx = world.rand.nextFloat() * 0.8f + 0.1f;
                    float fz = world.rand.nextFloat() * 0.8f + 0.1f;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + fx), (double)y + 0.5, (double)((float)z + fz), stack);
                    entityitem.motionX = world.rand.nextGaussian() * 0.05;
                    entityitem.motionY = world.rand.nextGaussian() * 0.05 + 0.2;
                    entityitem.motionZ = world.rand.nextGaussian() * 0.05;
                    if (stack.hasTagCompound()) {
                        entityitem.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                    }
                    world.spawnEntityInWorld((Entity)entityitem);
                }
            }
        }
        super.breakBlock(world, x, y, z, par5, par6);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return this.getOriginalBlock(world, x, y, z);
    }

    public ItemStack getOriginalBlock(World world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityMultiblockPart) {
            return ((TileEntityMultiblockPart)te).getOriginalBlock();
        }
        return new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z));
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity curr = world.getTileEntity(x, y, z);
        if (curr instanceof TileEntitySqueezer) {
            if (!player.isSneaking() && ((TileEntitySqueezer)curr).formed) {
                TileEntitySqueezer te = ((TileEntitySqueezer)curr).master();
                if (te == null) {
                    te = (TileEntitySqueezer)curr;
                }
                if (!world.isRemote) {
                    player.openGui((Object)ImmersiveEngineering.instance, 5, world, te.xCoord, te.yCoord, te.zCoord);
                }
                return true;
            }
        } else if (curr instanceof TileEntityFermenter) {
            if (!player.isSneaking() && ((TileEntityFermenter)curr).formed) {
                TileEntityFermenter te = ((TileEntityFermenter)curr).master();
                if (te == null) {
                    te = (TileEntityFermenter)curr;
                }
                if (!world.isRemote) {
                    player.openGui((Object)ImmersiveEngineering.instance, 6, world, te.xCoord, te.yCoord, te.zCoord);
                }
                return true;
            }
        } else if (curr instanceof TileEntityRefinery) {
            if (!player.isSneaking() && ((TileEntityRefinery)curr).formed) {
                TileEntityRefinery te = ((TileEntityRefinery)curr).master();
                if (te == null) {
                    te = (TileEntityRefinery)curr;
                }
                if (!world.isRemote) {
                    player.openGui((Object)ImmersiveEngineering.instance, 8, world, te.xCoord, te.yCoord, te.zCoord);
                }
                return true;
            }
        } else if (curr instanceof TileEntityDieselGenerator) {
            TileEntityDieselGenerator master = ((TileEntityDieselGenerator)curr).master();
            if (master == null) {
                master = (TileEntityDieselGenerator)curr;
            }
            if (((TileEntityDieselGenerator)curr).pos == 40 && Utils.isHammer(player.getCurrentEquippedItem())) {
                master.mirrored = !master.mirrored;
                master.mirror();
                ForgeDirection dir = ForgeDirection.getOrientation((int)master.facing);
                int axis = dir == ForgeDirection.EAST || dir == ForgeDirection.WEST ? 2 : 0;
                ChunkCoordinates gen = new ChunkCoordinates(master.xCoord + (axis == 0 ? 1 : -dir.offsetX), master.yCoord, master.zCoord + (axis == 2 ? 1 : -dir.offsetZ));
                ChunkCoordinates adapter = new ChunkCoordinates(master.xCoord + (axis == 0 ? 2 : -dir.offsetX), master.yCoord, master.zCoord + (axis == 2 ? 2 : -dir.offsetZ));
                Block b = world.getBlock(adapter.posX, adapter.posY, adapter.posZ);
                if (b != null) {
                    b.onNeighborChange((IBlockAccess)world, adapter.posX, adapter.posY, adapter.posZ, gen.posX, gen.posY, gen.posZ);
                }
                gen = new ChunkCoordinates(master.xCoord - (axis == 0 ? 1 : -dir.offsetX), master.yCoord, master.zCoord - (axis == 2 ? 1 : dir.offsetZ));
                adapter = new ChunkCoordinates(master.xCoord - (axis == 0 ? 2 : -dir.offsetX), master.yCoord, master.zCoord - (axis == 2 ? 2 : dir.offsetZ));
                b = world.getBlock(adapter.posX, adapter.posY, adapter.posZ);
                if (b != null) {
                    b.onNeighborChange((IBlockAccess)world, adapter.posX, adapter.posY, adapter.posZ, gen.posX, gen.posY, gen.posZ);
                }
                master.markDirty();
                world.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
            } else if (!(world.isRemote || ((TileEntityDieselGenerator)curr).pos != 36 && ((TileEntityDieselGenerator)curr).pos != 38)) {
                if (Utils.fillFluidHandlerWithPlayerItem(world, master, player)) {
                    master.markDirty();
                    world.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
                    return true;
                }
                if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IFluidContainerItem) {
                    master.markDirty();
                    world.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
                    return true;
                }
            }
        } else if (curr instanceof TileEntityArcFurnace) {
            if (!player.isSneaking() && ((TileEntityArcFurnace)curr).formed) {
                TileEntityArcFurnace te = (TileEntityArcFurnace)curr;
                if (te.pos == 2 || te.pos == 25 || te.pos > 25 && te.pos % 5 > 0 && te.pos % 5 < 4 && te.pos % 25 / 5 < 4) {
                    TileEntityArcFurnace master = te.master();
                    if (master == null) {
                        master = te;
                    }
                    if (!world.isRemote) {
                        player.openGui((Object)ImmersiveEngineering.instance, 10, world, master.xCoord, master.yCoord, master.zCoord);
                    }
                    return true;
                }
            }
        } else if (!player.isSneaking() && curr instanceof TileEntitySheetmetalTank) {
            TileEntitySheetmetalTank tank = (TileEntitySheetmetalTank)curr;
            TileEntitySheetmetalTank master = tank.master();
            if (master == null) {
                master = tank;
            }
            if (Utils.fillFluidHandlerWithPlayerItem(world, master, player)) {
                master.markDirty();
                world.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
                return true;
            }
            if (Utils.fillPlayerItemFromFluidHandler(world, master, player, master.tank.getFluid())) {
                master.markDirty();
                world.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
                return true;
            }
            if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IFluidContainerItem) {
                master.markDirty();
                world.markBlockForUpdate(master.xCoord, master.yCoord, master.zCoord);
                return true;
            }
        } else if (curr instanceof TileEntityAssembler) {
            if (!player.isSneaking() && ((TileEntityAssembler)curr).formed) {
                TileEntityAssembler te = (TileEntityAssembler)curr;
                TileEntityAssembler master = te.master();
                if (master == null) {
                    master = te;
                }
                if (!world.isRemote) {
                    player.openGui((Object)ImmersiveEngineering.instance, 11, world, master.xCoord, master.yCoord, master.zCoord);
                }
                return true;
            }
        } else if (curr instanceof TileEntityMetalPress && ((TileEntityMetalPress)curr).formed) {
            TileEntityMetalPress te = (TileEntityMetalPress)curr;
            TileEntityMetalPress master = te.master();
            if (master == null) {
                master = te;
            }
            if (player.isSneaking() && master.mold != null) {
                if (player.getCurrentEquippedItem() == null) {
                    player.setCurrentItemOrArmor(0, master.mold.copy());
                } else if (!world.isRemote) {
                    player.entityDropItem(master.mold.copy(), 0.0f);
                }
                master.mold = null;
                return true;
            }
            if (MetalPressRecipe.isValidMold(player.getCurrentEquippedItem())) {
                ItemStack tempMould = master.mold != null ? master.mold.copy() : null;
                master.mold = Utils.copyStackWithAmount(player.getCurrentEquippedItem(), 1);
                player.inventory.decrStackSize(player.inventory.currentItem, 1);
                if (tempMould != null) {
                    if (player.getCurrentEquippedItem() == null) {
                        player.setCurrentItemOrArmor(0, tempMould);
                    } else if (!world.isRemote) {
                        player.entityDropItem(tempMould, 0.0f);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityDieselGenerator) {
            TileEntityDieselGenerator tile = (TileEntityDieselGenerator)te;
            if (tile.pos == 39 || tile.pos == 40 || tile.pos == 41) {
                return side == ForgeDirection.UP;
            }
            if (tile.pos == 36 || tile.pos == 38) {
                return true;
            }
            if (tile.pos == 21 && !tile.master().mirrored || tile.pos == 23 && tile.master().mirrored) {
                return true;
            }
        } else if (te instanceof TileEntityRefinery) {
            TileEntityRefinery tile = (TileEntityRefinery)te;
            if (tile.pos == 9 && side.ordinal() == tile.facing) {
                return true;
            }
        } else if (te instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)te;
            if (tile.pos % 5 == 0) {
                return true;
            }
            if (tile.pos == 9 && side.ordinal() == tile.facing) {
                return true;
            }
        } else if (te instanceof TileEntityExcavator) {
            TileEntityExcavator tile = (TileEntityExcavator)te;
            if (tile.pos < 27) {
                return true;
            }
        } else if (te instanceof TileEntityArcFurnace) {
            TileEntityArcFurnace tile = (TileEntityArcFurnace)te;
            if (tile.pos == 2 || tile.pos == 25 || tile.pos == 52) {
                return side.ordinal() == tile.facing || tile.pos == 52 && side == ForgeDirection.UP;
            }
            if (tile.pos == 82 || tile.pos == 86 || tile.pos == 88 || tile.pos == 112) {
                return side == ForgeDirection.UP;
            }
            if (tile.pos >= 21 && tile.pos <= 23 || tile.pos >= 46 && tile.pos <= 48 || tile.pos >= 71 && tile.pos <= 73) {
                return side.getOpposite().ordinal() == tile.facing;
            }
        } else {
            if (te instanceof TileEntitySheetmetalTank || te instanceof TileEntitySilo) {
                TileEntityMultiblockPart tile = (TileEntityMultiblockPart)te;
                return tile.pos == 4 || tile.pos == (tile instanceof TileEntitySilo ? 58 : 40) || tile.pos >= 18 && tile.pos < (tile instanceof TileEntitySilo ? 54 : 36);
            }
            if (te instanceof TileEntityFermenter || te instanceof TileEntitySqueezer) {
                return true;
            }
            if (te instanceof TileEntityAssembler) {
                return ((TileEntityAssembler)te).offset[1] == -1;
            }
            if (te instanceof TileEntityBottlingMachine) {
                return ((TileEntityBottlingMachine)te).offset[1] == 0 && ((TileEntityBottlingMachine)te).pos != 0 && ((TileEntityBottlingMachine)te).pos != 2;
            }
            if (te instanceof TileEntityMetalPress) {
                TileEntityMetalPress tile = (TileEntityMetalPress)te;
                return tile.pos > 2 ? side == ForgeDirection.UP : side == ForgeDirection.DOWN;
            }
        }
        return super.isSideSolid(world, x, y, z, side);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityDieselGenerator) {
            return ((TileEntityDieselGenerator)te).pos == 21 || ((TileEntityDieselGenerator)te).pos == 23;
        }
        if (te instanceof TileEntityRefinery) {
            return ((TileEntityRefinery)te).pos == 9 && side == ((TileEntityRefinery)te).facing;
        }
        if (te instanceof TileEntityCrusher) {
            return ((TileEntityCrusher)te).pos == 9 && side == ((TileEntityCrusher)te).facing;
        }
        if (te instanceof TileEntityExcavator) {
            return ((TileEntityExcavator)te).pos == 3 || ((TileEntityExcavator)te).pos == 5;
        }
        if (te instanceof TileEntityArcFurnace) {
            return ((TileEntityArcFurnace)te).pos == 25;
        }
        return false;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityMultiblockPart) {
            float[] bounds = ((TileEntityMultiblockPart)te).getBlockBounds();
            if (bounds != null && bounds.length > 5) {
                this.setBlockBounds(bounds[0], bounds[1], bounds[2], bounds[3], bounds[4], bounds[5]);
            } else {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)tileEntity;
            if (tile.pos % 15 >= 11 && tile.pos % 15 <= 13) {
                int pos = tile.pos;
                int fl = tile.facing;
                int fw = tile.facing;
                if (tile.mirrored) {
                    fw = ForgeDirection.OPPOSITES[fw];
                }
                if (pos / 15 == 0 && (pos % 5 == 1 || pos % 5 == 3)) {
                    if (pos % 5 == 1) {
                        this.setBlockBounds(fl == 4 || fw == 3 ? 0.1875f : (fw == 2 ? 0.5625f : 0.0f), 0.0f, fl == 2 || fw == 4 ? 0.1875f : (fw == 5 ? 0.5625f : 0.0f), fl == 5 || fw == 2 ? 0.8125f : (fw == 3 ? 0.4375f : 1.0f), 1.0f, fl == 3 || fw == 5 ? 0.8125f : (fw == 4 ? 0.4375f : 1.0f));
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                        this.setBlockBounds(fl == 4 || fw == 3 ? 0.1875f : (fl == 5 ? 0.5625f : 0.0f), 0.0f, fl == 2 || fw == 4 ? 0.1875f : (fl == 3 ? 0.5625f : 0.0f), fl == 5 || fw == 2 ? 0.8125f : (fl == 4 ? 0.4375f : 1.0f), 1.0f, fl == 3 || fw == 5 ? 0.8125f : (fl == 2 ? 0.4375f : 1.0f));
                    } else {
                        this.setBlockBounds(fl == 4 || fw == 2 ? 0.1875f : (fw == 3 ? 0.5625f : 0.0f), 0.0f, fl == 2 || fw == 5 ? 0.1875f : (fw == 4 ? 0.5625f : 0.0f), fl == 5 || fw == 3 ? 0.8125f : (fw == 2 ? 0.4375f : 1.0f), 1.0f, fl == 3 || fw == 4 ? 0.8125f : (fw == 5 ? 0.4375f : 1.0f));
                        super.addCollisionBoxesToList(world, x, y, z, aabb, list, ent);
                        this.setBlockBounds(fl == 4 || fw == 2 ? 0.1875f : (fl == 5 ? 0.5625f : 0.0f), 0.0f, fl == 2 || fw == 5 ? 0.1875f : (fl == 3 ? 0.5625f : 0.0f), fl == 5 || fw == 3 ? 0.8125f : (fl == 4 ? 0.4375f : 1.0f), 1.0f, fl == 3 || fw == 4 ? 0.8125f : (fl == 2 ? 0.4375f : 1.0f));
                    }
                } else if (pos / 15 == 2 && (pos % 5 == 1 || pos % 5 == 3)) {
                    if (pos % 5 == 1) {
                        this.setBlockBounds(fl == 5 || fw == 3 ? 0.1875f : (fw == 2 ? 0.5625f : 0.0f), 0.0f, fl == 3 || fw == 4 ? 0.1875f : (fw == 5 ? 0.5625f : 0.0f), fl == 4 || fw == 2 ? 0.8125f : (fw == 3 ? 0.4375f : 1.0f), 1.0f, fl == 2 || fw == 5 ? 0.8125f : (fw == 4 ? 0.4375f : 1.0f));
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                        this.setBlockBounds(fl == 5 || fw == 3 ? 0.1875f : (fl == 4 ? 0.5625f : 0.0f), 0.0f, fl == 3 || fw == 4 ? 0.1875f : (fl == 2 ? 0.5625f : 0.0f), fl == 4 || fw == 2 ? 0.8125f : (fl == 5 ? 0.4375f : 1.0f), 1.0f, fl == 2 || fw == 5 ? 0.8125f : (fl == 3 ? 0.4375f : 1.0f));
                    } else {
                        this.setBlockBounds(fl == 5 || fw == 2 ? 0.1875f : (fw == 3 ? 0.5625f : 0.0f), 0.0f, fl == 3 || fw == 5 ? 0.1875f : (fw == 4 ? 0.5625f : 0.0f), fl == 4 || fw == 3 ? 0.8125f : (fw == 2 ? 0.4375f : 1.0f), 1.0f, fl == 2 || fw == 4 ? 0.8125f : (fw == 5 ? 0.4375f : 1.0f));
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                        this.setBlockBounds(fl == 5 || fw == 2 ? 0.1875f : (fl == 4 ? 0.5625f : 0.0f), 0.0f, fl == 3 || fw == 5 ? 0.1875f : (fl == 2 ? 0.5625f : 0.0f), fl == 4 || fw == 3 ? 0.8125f : (fl == 5 ? 0.4375f : 1.0f), 1.0f, fl == 2 || fw == 4 ? 0.8125f : (fl == 3 ? 0.4375f : 1.0f));
                    }
                }
            }
        }
        this.addCollisionBox(world, x, y, z, aabb, list, ent);
    }

    @Override
    public ArrayList<AxisAlignedBB> addCustomSelectionBoxesToList(World world, int x, int y, int z) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TileEntityCrusher) {
            TileEntityCrusher tile = (TileEntityCrusher)tileEntity;
            int pos = tile.pos;
            if (pos % 15 >= 11 && pos % 15 <= 13) {
                int fl = tile.facing;
                int fw = tile.facing;
                if (tile.mirrored) {
                    fw = ForgeDirection.OPPOSITES[fw];
                }
                if (pos / 15 == 0 && (pos % 5 == 1 || pos % 5 == 3)) {
                    if (pos % 5 == 1) {
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 4 ? 0.4375 : (fw == 3 ? 0.1875 : (fw == 2 ? 0.5625 : 0.0))), (double)0.0, (double)(fl == 2 ? 0.4375 : (fw == 4 ? 0.1875 : (fw == 5 ? 0.5625 : 0.0))), (double)(fl == 5 ? 0.5625 : (fw == 2 ? 0.8125 : (fw == 3 ? 0.4375 : 1.0))), (double)1.0, (double)(fl == 3 ? 0.5625 : (fw == 5 ? 0.8125 : (fw == 4 ? 0.4375 : 1.0)))));
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 4 || fw == 3 ? 0.1875 : (fl == 5 ? 0.5625 : 0.0)), (double)0.0, (double)(fl == 2 || fw == 4 ? 0.1875 : (fl == 3 ? 0.5625 : 0.0)), (double)(fl == 5 || fw == 2 ? 0.8125 : (fl == 4 ? 0.4375 : 1.0)), (double)1.0, (double)(fl == 3 || fw == 5 ? 0.8125 : (fl == 2 ? 0.4375 : 1.0))));
                    } else {
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 4 ? 0.4375 : (fw == 2 ? 0.1875 : (fw == 3 ? 0.5625 : 0.0))), (double)0.0, (double)(fl == 2 ? 0.4375 : (fw == 5 ? 0.1875 : (fw == 4 ? 0.5625 : 0.0))), (double)(fl == 5 ? 0.5625 : (fw == 3 ? 0.8125 : (fw == 2 ? 0.4375 : 1.0))), (double)1.0, (double)(fl == 3 ? 0.5625 : (fw == 4 ? 0.8125 : (fw == 5 ? 0.4375 : 1.0)))));
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 4 || fw == 2 ? 0.1875 : (fl == 5 ? 0.5625 : 0.0)), (double)0.0, (double)(fl == 2 || fw == 5 ? 0.1875 : (fl == 3 ? 0.5625 : 0.0)), (double)(fl == 5 || fw == 3 ? 0.8125 : (fl == 4 ? 0.4375 : 1.0)), (double)1.0, (double)(fl == 3 || fw == 4 ? 0.8125 : (fl == 2 ? 0.4375 : 1.0))));
                    }
                } else if (pos / 15 == 2 && (pos % 5 == 1 || pos % 5 == 3)) {
                    if (pos % 5 == 1) {
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 5 ? 0.4375 : (fw == 3 ? 0.1875 : (fw == 2 ? 0.5625 : 0.0))), (double)0.0, (double)(fl == 3 ? 0.4375 : (fw == 4 ? 0.1875 : (fw == 5 ? 0.5625 : 0.0))), (double)(fl == 4 ? 0.5625 : (fw == 2 ? 0.8125 : (fw == 3 ? 0.4375 : 1.0))), (double)1.0, (double)(fl == 2 ? 0.5625 : (fw == 5 ? 0.8125 : (fw == 4 ? 0.4375 : 1.0)))));
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 5 || fw == 3 ? 0.1875 : (fl == 4 ? 0.5625 : 0.0)), (double)0.0, (double)(fl == 3 || fw == 4 ? 0.1875 : (fl == 2 ? 0.5625 : 0.0)), (double)(fl == 4 || fw == 2 ? 0.8125 : (fl == 5 ? 0.4375 : 1.0)), (double)1.0, (double)(fl == 2 || fw == 5 ? 0.8125 : (fl == 3 ? 0.4375 : 1.0))));
                    } else {
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 5 ? 0.4375 : (fw == 2 ? 0.1875 : (fw == 3 ? 0.5625 : 0.0))), (double)0.0, (double)(fl == 3 ? 0.4375 : (fw == 5 ? 0.1875 : (fw == 4 ? 0.5625 : 0.0))), (double)(fl == 4 ? 0.5625 : (fw == 3 ? 0.8125 : (fw == 2 ? 0.4375 : 1.0))), (double)1.0, (double)(fl == 2 ? 0.5625 : (fw == 4 ? 0.8125 : (fw == 5 ? 0.4375 : 1.0)))));
                        list.add(AxisAlignedBB.getBoundingBox((double)(fl == 5 || fw == 2 ? 0.1875 : (fl == 4 ? 0.5625 : 0.0)), (double)0.0, (double)(fl == 3 || fw == 5 ? 0.1875 : (fl == 2 ? 0.5625 : 0.0)), (double)(fl == 4 || fw == 3 ? 0.8125 : (fl == 5 ? 0.4375 : 1.0)), (double)1.0, (double)(fl == 2 || fw == 4 ? 0.8125 : (fl == 3 ? 0.4375 : 1.0))));
                    }
                }
            } else if (pos == 1 || pos == 3 || pos == 31 || pos == 33) {
                int fl = tile.facing;
                int fw = tile.facing;
                if (tile.mirrored) {
                    fw = ForgeDirection.OPPOSITES[fw];
                }
                list.add(AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0));
                list.add(AxisAlignedBB.getBoundingBox((double)(fw == (pos % 30 == 1 ? 2 : 3) || fl == (pos < 30 ? 5 : 4) ? 0.5 : 0.25), (double)0.5, (double)(fl == (pos < 30 ? 3 : 2) || fw == (pos % 30 == 1 ? 5 : 4) ? 0.5 : 0.25), (double)(fw == (pos % 30 == 1 ? 2 : 3) || fl == (pos < 30 ? 5 : 4) ? 0.75 : 0.5), (double)1.5, (double)(fl == (pos < 30 ? 3 : 2) || fw == (pos % 30 == 1 ? 5 : 4) ? 0.75 : 0.5)));
            } else {
                float[] bounds = ((TileEntityMultiblockPart)tileEntity).getBlockBounds();
                if (bounds != null && bounds.length > 5) {
                    list.add(AxisAlignedBB.getBoundingBox((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)bounds[3], (double)bounds[4], (double)bounds[5]));
                } else {
                    list.add(AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
                }
            }
        }
        return list;
    }

    @Override
    public boolean addSpecifiedSubBox(World world, int x, int y, int z, EntityPlayer player, AxisAlignedBB box, Vec3 hitVec, ArrayList<AxisAlignedBB> list) {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityLightningRod();
            }
            case 1: {
                return new TileEntityDieselGenerator();
            }
            case 2: {
                return new TileEntitySqueezer();
            }
            case 3: {
                return new TileEntityFermenter();
            }
            case 4: {
                return new TileEntityRefinery();
            }
            case 5: {
                return new TileEntityCrusher();
            }
            case 6: {
                return new TileEntityBucketWheel();
            }
            case 7: {
                return new TileEntityExcavator();
            }
            case 8: {
                return new TileEntityArcFurnace();
            }
            case 9: {
                return new TileEntitySheetmetalTank();
            }
            case 10: {
                return new TileEntitySilo();
            }
            case 11: {
                return new TileEntityAssembler();
            }
            case 12: {
                return new TileEntityBottlingMachine();
            }
            case 13: {
                return new TileEntityMetalPress();
            }
        }
        return null;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntitySilo) {
            return ((TileEntitySilo)te).getComparatorOutput();
        }
        if (te instanceof TileEntitySheetmetalTank) {
            return ((TileEntitySheetmetalTank)te).getComparatorOutput();
        }
        return super.getComparatorInputOverride(world, x, y, z, side);
    }

    public void onEntityCollidedWithBlock(World w, int x, int y, int z, Entity e) {
        if (w.isRemote || !(e instanceof EntityItem)) {
            return;
        }
        TileEntity te = w.getTileEntity(x, y, z);
        if (te instanceof TileEntityMetalPress && ((TileEntityMetalPress)te).pos == 3 && w.getTotalWorldTime() % 10L == (long)((x ^ z) % 10)) {
            ItemStack s = Utils.insertStackIntoInventory((IInventory)te, ((EntityItem)e).getEntityItem(), ForgeDirection.OPPOSITES[((TileEntityMetalPress)te).facing]);
            if (s == null || s.stackSize == 0) {
                e.setDead();
            } else if (s.stackSize != ((EntityItem)e).getEntityItem().stackSize) {
                ((EntityItem)e).setEntityItemStack(s);
            }
        }
    }
}

