/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.aquatweaks.api.IAquaConnectable;
import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.render.BlockRenderMetalDevices2;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.ItemBlockMetalDevices2;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBlastFurnacePreheater;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBreakerSwitch;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCapacitorCreative;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityChargingStation;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityElectricLantern;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityEnergyMeter;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFloodlight;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPipe;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFluidPump;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalBarrel;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRedstoneBreaker;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySkycrateDispenser;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenBarrel;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.IC2Helper;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

@Optional.Interface(iface="blusunrize.aquatweaks.api.IAquaConnectable", modid="AquaTweaks")
public class BlockMetalDevices2
extends BlockIEBase
implements IEBlockInterfaces.ICustomBoundingboxes,
IAquaConnectable {
    public static final int META_breakerSwitch = 0;
    public static final int META_skycrateDispenser = 1;
    public static final int META_energyMeter = 2;
    public static final int META_electricLantern = 3;
    public static final int META_floodlight = 4;
    public static final int META_fluidPipe = 5;
    public static final int META_fluidPump = 6;
    public static final int META_barrel = 7;
    public static final int META_capacitorCreative = 8;
    public static final int META_redstoneBreaker = 9;
    public static final int META_chargingStation = 10;
    public static final int META_blastFurnacePreheater = 11;
    IIcon[] iconPump = new IIcon[7];
    IIcon iconFloodlightGlass;
    IIcon[] iconBarrel = new IIcon[4];
    IIcon[][] iconCap = new IIcon[3][3];

    public BlockMetalDevices2() {
        super("metalDevice2", Material.iron, 1, ItemBlockMetalDevices2.class, "breakerSwitch", "skycrateDispenser", "energyMeter", "electricLantern", "floodlight", "fluidPipe", "fluidPump", "barrel", "capacitorCreative", "redstoneBreaker", "chargingStation", "blastFurnacePreheater");
        this.setHardness(3.0f);
        this.setResistance(15.0f);
        this.setMetaLightOpacity(7, 255);
    }

    @Override
    public boolean allowHammerHarvest(int meta) {
        return true;
    }

    @Override
    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 6));
        list.add(new ItemStack(item, 1, 7));
        list.add(new ItemStack(item, 1, 8));
        list.add(new ItemStack(item, 1, 9));
        list.add(new ItemStack(item, 1, 10));
        list.add(new ItemStack(item, 1, 11));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        int i;
        for (i = 0; i < this.subNames.length; ++i) {
            if (i == 6 || i == 8) continue;
            this.icons[i][0] = iconRegister.registerIcon("immersiveEngineering:metal2_" + this.subNames[i]);
        }
        for (i = 0; i < 3; ++i) {
            String s = i == 0 ? "none" : (i == 1 ? "in" : "out");
            this.iconCap[0][i] = iconRegister.registerIcon("immersiveengineering:metal2_capacitorCreative_bottom_" + s);
            this.iconCap[1][i] = iconRegister.registerIcon("immersiveengineering:metal2_capacitorCreative_top_" + s);
            this.iconCap[2][i] = iconRegister.registerIcon("immersiveengineering:metal2_capacitorCreative_side_" + s);
        }
        this.iconFloodlightGlass = iconRegister.registerIcon("immersiveEngineering:metal2_floodlightGlass");
        this.iconPump[0] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_side_none");
        this.iconPump[1] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_side_in");
        this.iconPump[2] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_side_out");
        this.iconPump[3] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_bottom_none");
        this.iconPump[4] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_bottom_in");
        this.iconPump[5] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_bottom_out");
        this.iconPump[6] = iconRegister.registerIcon("immersiveEngineering:metal2_pump_top");
        this.iconBarrel[0] = iconRegister.registerIcon("immersiveengineering:metal2_barrel_top_none");
        this.iconBarrel[1] = iconRegister.registerIcon("immersiveengineering:metal2_barrel_top_in");
        this.iconBarrel[2] = iconRegister.registerIcon("immersiveengineering:metal2_barrel_top_out");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityMetalBarrel && side < 2) {
            return this.iconBarrel[((TileEntityMetalBarrel)te).sideConfig[side] + 1];
        }
        if (te instanceof TileEntityCapacitorCreative) {
            TileEntityCapacitorCreative cap = (TileEntityCapacitorCreative)te;
            if (side == 0) {
                return this.iconCap[0][cap.sideConfig[side] + 1];
            }
            if (side == 1) {
                return this.iconCap[1][cap.sideConfig[side] + 1];
            }
            return this.iconCap[2][cap.sideConfig[side] + 1];
        }
        return super.getIcon(world, x, y, z, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        if (meta == 6) {
            return this.iconPump[Math.min(side + 1, 6)];
        }
        if (meta == 4 && side == 1) {
            return this.iconFloodlightGlass;
        }
        if (meta == 7 && side < 2) {
            return this.iconBarrel[0];
        }
        if (meta == 8) {
            if (side == 0) {
                return this.iconCap[0][0];
            }
            if (side == 1) {
                return this.iconCap[1][0];
            }
            return this.iconCap[2][0];
        }
        return super.getIcon(side, meta);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return BlockRenderMetalDevices2.renderID;
    }

    public boolean canRenderInPass(int pass) {
        BlockRenderMetalDevices2.renderPass = pass;
        return true;
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int dye;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof IEBlockInterfaces.IColouredTile && (dye = Utils.getDye(player.getCurrentEquippedItem())) >= 0) {
            float r = (float)(((IEBlockInterfaces.IColouredTile)te).getColour() >> 16 & 0xFF) / 255.0f;
            float g = (float)(((IEBlockInterfaces.IColouredTile)te).getColour() >> 8 & 0xFF) / 255.0f;
            float b = (float)(((IEBlockInterfaces.IColouredTile)te).getColour() & 0xFF) / 255.0f;
            r += EntitySheep.fleeceColorTable[15 - dye][0];
            g += EntitySheep.fleeceColorTable[15 - dye][1];
            b += EntitySheep.fleeceColorTable[15 - dye][2];
            int newColour = (int)((r /= 2.0f) * 255.0f);
            newColour = (newColour << 8) + (int)((g /= 2.0f) * 255.0f);
            newColour = (newColour << 8) + (int)((b /= 2.0f) * 255.0f);
            ((IEBlockInterfaces.IColouredTile)te).setColour(newColour);
            te.markDirty();
            world.markBlockForUpdate(x, y, z);
            return true;
        }
        if (!player.isSneaking() && te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            if (!world.isRemote) {
                if (Utils.isHammer(player.getCurrentEquippedItem())) {
                    ((TileEntityBreakerSwitch)te).inverted = !((TileEntityBreakerSwitch)te).inverted;
                    player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info." + (((TileEntityBreakerSwitch)te).inverted ? "invertedOn" : "invertedOff"), new Object[0]));
                    te.markDirty();
                } else {
                    ((TileEntityBreakerSwitch)te).toggle();
                    te.markDirty();
                }
                world.notifyBlocksOfNeighborChange(x, y, z, (Block)this);
                for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                    world.notifyBlocksOfNeighborChange(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ, (Block)this);
                }
                world.func_147451_t(x, y, z);
            }
            return true;
        }
        if (te instanceof TileEntityEnergyMeter) {
            if (!world.isRemote) {
                TileEntity tmp;
                TileEntityEnergyMeter meter = (TileEntityEnergyMeter)te;
                int transfer = meter.getAveragePower();
                if (meter.dummy && (tmp = world.getTileEntity(meter.xCoord, meter.yCoord + 1, meter.zCoord)) instanceof TileEntityEnergyMeter) {
                    meter = (TileEntityEnergyMeter)tmp;
                }
                String transferred = "0";
                if (transfer > 0) {
                    transferred = Utils.formatDouble(transfer, "0.###");
                }
                player.addChatComponentMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.energyTransfered", new Object[]{meter.lastPackets.size(), transferred}));
            }
            return true;
        }
        if (Utils.isHammer(player.getCurrentEquippedItem()) && te instanceof TileEntityFloodlight) {
            if (!world.isRemote) {
                if (side == ((TileEntityFloodlight)te).side || ForgeDirection.OPPOSITES[side] == ((TileEntityFloodlight)te).side) {
                    ((TileEntityFloodlight)te).turnY(player.isSneaking(), false);
                } else {
                    ((TileEntityFloodlight)te).turnX(!player.isSneaking(), false);
                }
            }
            return true;
        }
        if (te instanceof TileEntityFluidPump) {
            TileEntityFluidPump pump = (TileEntityFluidPump)te;
            if (!pump.dummy) {
                if (!world.isRemote) {
                    if (Utils.isHammer(player.getCurrentEquippedItem())) {
                        if (player.isSneaking()) {
                            side = ForgeDirection.OPPOSITES[side];
                        }
                        pump.toggleSide(side);
                        world.markBlockForUpdate(x, y, z);
                    } else if (Config.getBoolean("pump_placeCobble") && OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 1), (ItemStack)player.getCurrentEquippedItem(), (boolean)true)) {
                        pump.placeCobble = !pump.placeCobble;
                        player.addChatMessage((IChatComponent)new ChatComponentTranslation("chat.ImmersiveEngineering.info.pump.placeCobble." + pump.placeCobble, new Object[0]));
                    }
                }
                return true;
            }
        } else if (te instanceof TileEntityFluidPipe) {
            if (Utils.isHammer(player.getCurrentEquippedItem())) {
                if (!world.isRemote) {
                    TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
                    ForgeDirection fd = ForgeDirection.UNKNOWN;
                    ArrayList<AxisAlignedBB> boxes = this.addCustomSelectionBoxesToList(world, x, y, z);
                    for (AxisAlignedBB box : boxes) {
                        if (!box.expand(0.002, 0.002, 0.002).isVecInside(Vec3.createVectorHelper((double)hitX, (double)hitY, (double)hitZ)) || !(box instanceof AdvancedAABB)) continue;
                        fd = ((AdvancedAABB)box).fd;
                    }
                    if (fd != null && fd != ForgeDirection.UNKNOWN) {
                        tile.toggleSide(fd.ordinal());
                        world.markBlockForUpdate(x, y, z);
                        TileEntityFluidPipe.indirectConnections.clear();
                        return true;
                    }
                }
            } else if (player.getCurrentEquippedItem() != null) {
                TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
                for (ItemStack valid : TileEntityFluidPipe.validScaffoldCoverings) {
                    if (!OreDictionary.itemMatches((ItemStack)valid, (ItemStack)player.getCurrentEquippedItem(), (boolean)true) || OreDictionary.itemMatches((ItemStack)tile.scaffoldCovering, (ItemStack)player.getCurrentEquippedItem(), (boolean)true)) continue;
                    if (!world.isRemote && tile.scaffoldCovering != null && world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
                        EntityItem entityitem = player.dropPlayerItemWithRandomChoice(tile.scaffoldCovering.copy(), false);
                        entityitem.delayBeforeCanPickup = 0;
                    }
                    tile.scaffoldCovering = Utils.copyStackWithAmount(player.getCurrentEquippedItem(), 1);
                    if (!player.capabilities.isCreativeMode) {
                        player.inventory.decrStackSize(player.inventory.currentItem, 1);
                    }
                    world.markBlockForUpdate(x, y, z);
                    world.addBlockEvent(x, y, z, tile.getBlockType(), 0, 0);
                    return true;
                }
            } else if (player.isSneaking() && player.getCurrentEquippedItem() == null) {
                TileEntityFluidPipe pipe = (TileEntityFluidPipe)te;
                if (pipe.scaffoldCovering != null) {
                    if (!world.isRemote) {
                        if (world.getGameRules().getGameRuleBooleanValue("doTileDrops")) {
                            EntityItem entityitem = player.dropPlayerItemWithRandomChoice(pipe.scaffoldCovering.copy(), false);
                            entityitem.delayBeforeCanPickup = 0;
                        }
                        pipe.scaffoldCovering = null;
                        world.markBlockForUpdate(x, y, z);
                        world.addBlockEvent(x, y, z, pipe.getBlockType(), 0, 0);
                    }
                    return true;
                }
            }
        } else if (te instanceof TileEntityWoodenBarrel) {
            TileEntityWoodenBarrel barrel = (TileEntityWoodenBarrel)te;
            if (!world.isRemote && Utils.isHammer(player.getCurrentEquippedItem()) && side < 2) {
                if (player.isSneaking()) {
                    side = ForgeDirection.OPPOSITES[side];
                }
                barrel.toggleSide(side);
            } else {
                if (Utils.fillFluidHandlerWithPlayerItem(world, barrel, player)) {
                    barrel.markDirty();
                    world.markBlockForUpdate(barrel.xCoord, barrel.yCoord, barrel.zCoord);
                    return true;
                }
                if (Utils.fillPlayerItemFromFluidHandler(world, barrel, player, barrel.tank.getFluid())) {
                    barrel.markDirty();
                    world.markBlockForUpdate(barrel.xCoord, barrel.yCoord, barrel.zCoord);
                    return true;
                }
                if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof IFluidContainerItem) {
                    barrel.markDirty();
                    world.markBlockForUpdate(barrel.xCoord, barrel.yCoord, barrel.zCoord);
                    return true;
                }
            }
        } else {
            if (te instanceof TileEntityCapacitorCreative && Utils.isHammer(player.getCurrentEquippedItem())) {
                if (player.isSneaking()) {
                    side = ForgeDirection.OPPOSITES[side];
                }
                if (!world.isRemote) {
                    ((TileEntityCapacitorCreative)te).toggleSide(side);
                    te.markDirty();
                    world.markBlockForUpdate(x, y, z);
                    world.addBlockEvent(x, y, z, te.getBlockType(), 0, 0);
                }
                return true;
            }
            if (te instanceof TileEntityChargingStation) {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped != null && (equipped.getItem() instanceof IEnergyContainerItem || Lib.IC2 && IC2Helper.isElectricItem(equipped))) {
                    ItemStack stored = ((TileEntityChargingStation)te).inventory;
                    ((TileEntityChargingStation)te).setInventorySlotContents(0, player.getCurrentEquippedItem());
                    player.setCurrentItemOrArmor(0, stored);
                    return true;
                }
                if (((TileEntityChargingStation)te).inventory != null) {
                    if (!world.isRemote) {
                        player.entityDropItem(((TileEntityChargingStation)te).inventory, 0.5f);
                    }
                    ((TileEntityChargingStation)te).setInventorySlotContents(0, null);
                    return true;
                }
            }
        }
        return false;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            int f = ((TileEntityBreakerSwitch)te).facing;
            int side = ((TileEntityBreakerSwitch)te).sideAttached;
            if (side == 0) {
                this.setBlockBounds(f < 4 ? 0.25f : (f == 5 ? 0.75f : 0.0f), 0.1875f, f > 3 ? 0.25f : (f == 3 ? 0.75f : 0.0f), f < 4 ? 0.75f : (f == 4 ? 0.25f : 1.0f), 0.8125f, f > 3 ? 0.75f : (f == 2 ? 0.25f : 1.0f));
            } else if (side == 1) {
                this.setBlockBounds(f >= 4 ? 0.1875f : 0.25f, 0.0f, f <= 3 ? 0.1875f : 0.25f, f >= 4 ? 0.8125f : 0.75f, 0.25f, f <= 3 ? 0.8125f : 0.75f);
            } else {
                this.setBlockBounds(f >= 4 ? 0.1875f : 0.25f, 0.75f, f <= 3 ? 0.1875f : 0.25f, f >= 4 ? 0.8125f : 0.75f, 1.0f, f <= 3 ? 0.8125f : 0.75f);
            }
        } else if (te instanceof TileEntityEnergyMeter && !((TileEntityEnergyMeter)te).dummy) {
            this.setBlockBounds(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.875f, 0.8125f);
        } else if (te instanceof TileEntityFloodlight) {
            TileEntityFloodlight light = (TileEntityFloodlight)te;
            this.setBlockBounds(light.side / 2 == 2 ? 0.0f : 0.0625f, light.side / 2 == 0 ? 0.0f : 0.0625f, light.side / 2 == 1 ? 0.0f : 0.0625f, light.side / 2 == 2 ? 1.0f : 0.9375f, light.side / 2 == 0 ? 1.0f : 0.9375f, light.side / 2 == 1 ? 1.0f : 0.9375f);
        } else if (te instanceof TileEntityFluidPipe) {
            this.setBlockBounds(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        } else if (te instanceof TileEntityFluidPump) {
            if (((TileEntityFluidPump)te).dummy) {
                this.setBlockBounds(0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
            } else {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else if (world.getBlockMetadata(x, y, z) == 3) {
            this.setBlockBounds(0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
        } else if (te instanceof TileEntityRedstoneBreaker) {
            int f = ((TileEntityBreakerSwitch)te).facing;
            int side = ((TileEntityBreakerSwitch)te).sideAttached;
            if (side == 0) {
                this.setBlockBounds(0.0f, 0.125f, 0.0f, 1.0f, 0.875f, 1.0f);
            } else if (side == 1) {
                this.setBlockBounds(f >= 4 ? 0.125f : 0.0f, 0.0f, f <= 3 ? 0.125f : 0.0f, f >= 4 ? 0.875f : 1.0f, 1.0f, f <= 3 ? 0.875f : 1.0f);
            } else {
                this.setBlockBounds(f >= 4 ? 0.125f : 0.0f, 0.0f, f <= 3 ? 0.125f : 0.0f, f >= 4 ? 0.875f : 1.0f, 1.0f, f <= 3 ? 0.875f : 1.0f);
            }
        } else if (te instanceof TileEntityChargingStation) {
            int f = ((TileEntityChargingStation)te).facing;
            this.setBlockBounds(f < 4 ? 0.125f : 0.0f, 0.0f, f > 3 ? 0.125f : 0.0f, f < 4 ? 0.875f : 1.0f, 1.0f, f > 3 ? 0.875f : 1.0f);
        } else if (te instanceof TileEntityBlastFurnacePreheater && ((TileEntityBlastFurnacePreheater)te).dummy > 0) {
            this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity ent) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityFluidPipe) {
            TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
            if (tile.scaffoldCovering != null) {
                this.setBlockBounds(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
                this.addCollisionBox(world, x, y, z, aabb, list, ent);
            } else {
                byte connections = tile.getConnectionByte();
                if (connections == 48) {
                    this.setBlockBounds(0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    if ((connections & 0x10) == 0) {
                        this.setBlockBounds(0.0f, 0.125f, 0.125f, 0.125f, 0.875f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                    if ((connections & 0x20) == 0) {
                        this.setBlockBounds(0.875f, 0.125f, 0.125f, 1.0f, 0.875f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                } else if (connections == 12) {
                    this.setBlockBounds(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 1.0f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    if ((connections & 4) == 0) {
                        this.setBlockBounds(0.125f, 0.125f, 0.0f, 0.875f, 0.875f, 0.125f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                    if ((connections & 8) == 0) {
                        this.setBlockBounds(0.125f, 0.125f, 0.875f, 0.875f, 0.875f, 1.0f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                } else if (connections == 3) {
                    this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    if ((connections & 1) == 0) {
                        this.setBlockBounds(0.125f, 0.0f, 0.125f, 0.875f, 0.125f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                    if ((connections & 2) == 0) {
                        this.setBlockBounds(0.125f, 0.875f, 0.125f, 0.875f, 1.0f, 0.875f);
                        this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    }
                } else {
                    this.setBlockBounds(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
                    this.addCollisionBox(world, x, y, z, aabb, list, ent);
                    for (int i = 0; i < 6; ++i) {
                        if ((connections & 1) == 1) {
                            this.setBlockBounds(i == 4 ? 0.0f : (i == 5 ? 0.875f : 0.125f), i == 0 ? 0.0f : (i == 1 ? 0.875f : 0.125f), i == 2 ? 0.0f : (i == 3 ? 0.875f : 0.125f), i == 4 ? 0.125f : (i == 5 ? 1.0f : 0.875f), i == 0 ? 0.125f : (i == 1 ? 1.0f : 0.875f), i == 2 ? 0.125f : (i == 3 ? 1.0f : 0.875f));
                            this.addCollisionBox(world, x, y, z, aabb, list, ent);
                        }
                        connections = (byte)(connections >> 1);
                    }
                }
            }
        } else {
            super.addCollisionBoxesToList(world, x, y, z, aabb, list, ent);
        }
    }

    @Override
    public ArrayList<AxisAlignedBB> addCustomSelectionBoxesToList(World world, int x, int y, int z) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityFluidPipe) {
            double[] dArray;
            TileEntityFluidPipe tile = (TileEntityFluidPipe)te;
            byte connections = tile.getAvailableConnectionByte();
            byte availableConnections = tile.getConnectionByte();
            if (tile.scaffoldCovering != null) {
                double[] dArray2 = new double[6];
                dArray2[0] = 0.002;
                dArray2[1] = 0.998;
                dArray2[2] = 0.002;
                dArray2[3] = 0.998;
                dArray2[4] = 0.002;
                dArray = dArray2;
                dArray2[5] = 0.998;
            } else {
                double[] dArray3 = new double[6];
                dArray3[0] = 0.25;
                dArray3[1] = 0.75;
                dArray3[2] = 0.25;
                dArray3[3] = 0.75;
                dArray3[4] = 0.25;
                dArray = dArray3;
                dArray3[5] = 0.75;
            }
            double[] baseAABB = dArray;
            for (int i = 0; i < 6; ++i) {
                double size;
                double depth = tile.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
                double d = size = tile.getConnectionStyle(i) == 0 ? 0.25 : 0.125;
                if (tile.scaffoldCovering != null) {
                    size = 0.0;
                }
                if ((connections & 1) == 1) {
                    list.add(new AdvancedAABB(i == 4 ? 0.0 : (i == 5 ? 1.0 - depth : size), i == 0 ? 0.0 : (i == 1 ? 1.0 - depth : size), i == 2 ? 0.0 : (i == 3 ? 1.0 - depth : size), i == 4 ? depth : (i == 5 ? 1.0 : 1.0 - size), i == 0 ? depth : (i == 1 ? 1.0 : 1.0 - size), i == 2 ? depth : (i == 3 ? 1.0 : 1.0 - size), ForgeDirection.getOrientation((int)i)));
                }
                if ((availableConnections & 1) == 1) {
                    int n = i;
                    baseAABB[n] = baseAABB[n] + (i % 2 == 1 ? 0.125 : -0.125);
                }
                baseAABB[i] = Math.min(Math.max(baseAABB[i], 0.0), 1.0);
                availableConnections = (byte)(availableConnections >> 1);
                connections = (byte)(connections >> 1);
            }
            list.add(new AdvancedAABB(baseAABB[4], baseAABB[0], baseAABB[2], baseAABB[5], baseAABB[1], baseAABB[3], ForgeDirection.UNKNOWN));
        }
        return list;
    }

    @Override
    public boolean addSpecifiedSubBox(World world, int x, int y, int z, EntityPlayer player, AxisAlignedBB box, Vec3 hitVec, ArrayList<AxisAlignedBB> list) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityFluidPipe && box instanceof AdvancedAABB && ((AdvancedAABB)box).fd != null) {
            ForgeDirection fd = ((AdvancedAABB)box).fd;
            if (box.expand(0.002, 0.002, 0.002).isVecInside(hitVec.addVector((double)(-x), (double)(-y), (double)(-z)))) {
                list.add(fd == ForgeDirection.UNKNOWN ? box : box.expand(fd.offsetX != 0 ? 0.0 : 0.03125, fd.offsetY != 0 ? 0.0 : 0.03125, fd.offsetZ != 0 ? 0.0 : 0.03125));
                return fd == ForgeDirection.UNKNOWN && list.isEmpty();
            }
        }
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity ent) {
        TileEntity te;
        if (world.getBlockMetadata(x, y, z) == 5 && (te = world.getTileEntity(x, y, z)) instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)te).scaffoldCovering != null) {
            float f5 = 0.15f;
            if (ent.motionX < (double)(-f5)) {
                ent.motionX = -f5;
            }
            if (ent.motionX > (double)f5) {
                ent.motionX = f5;
            }
            if (ent.motionZ < (double)(-f5)) {
                ent.motionZ = -f5;
            }
            if (ent.motionZ > (double)f5) {
                ent.motionZ = f5;
            }
            ent.fallDistance = 0.0f;
            if (ent.motionY < -0.15) {
                ent.motionY = -0.15;
            }
            if (ent.motionY < 0.0 && ent instanceof EntityPlayer && ent.isSneaking()) {
                ent.motionY = 0.05;
                return;
            }
            if (ent.isCollidedHorizontally) {
                ent.motionY = 0.2;
            }
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 3) {
            return side.ordinal() < 2;
        }
        if (meta == 4) {
            TileEntity te = world.getTileEntity(x, y, z);
            return te instanceof TileEntityFloodlight && side.getOpposite().ordinal() == ((TileEntityFloodlight)te).side;
        }
        if (meta == 5) {
            TileEntity te = world.getTileEntity(x, y, z);
            if (te instanceof TileEntityFluidPipe && ((TileEntityFluidPipe)te).scaffoldCovering != null) {
                return true;
            }
        } else {
            if (meta == 6) {
                return true;
            }
            if (meta == 2) {
                TileEntity te = world.getTileEntity(x, y, z);
                return te instanceof TileEntityEnergyMeter && ((TileEntityEnergyMeter)te).dummy;
            }
            if (meta == 8) {
                return true;
            }
        }
        return false;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityBreakerSwitch();
            }
            case 1: {
                return new TileEntitySkycrateDispenser();
            }
            case 2: {
                return new TileEntityEnergyMeter();
            }
            case 3: {
                return new TileEntityElectricLantern();
            }
            case 4: {
                return new TileEntityFloodlight();
            }
            case 5: {
                return new TileEntityFluidPipe();
            }
            case 6: {
                return new TileEntityFluidPump();
            }
            case 7: {
                return new TileEntityMetalBarrel();
            }
            case 8: {
                return new TileEntityCapacitorCreative();
            }
            case 9: {
                return new TileEntityRedstoneBreaker();
            }
            case 10: {
                return new TileEntityChargingStation();
            }
            case 11: {
                return new TileEntityBlastFurnacePreheater();
            }
        }
        return null;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityWoodenBarrel) {
            ItemStack stack = new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z));
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenBarrel)te).writeTank(tag, true);
            if (!tag.hasNoTags()) {
                stack.setTagCompound(tag);
            }
            return stack;
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public void breakBlock(World world, int x, int y, int z, Block par5, int par6) {
        ItemStack s;
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityEnergyMeter) {
            if (((TileEntityEnergyMeter)te).dummy) {
                world.setBlockToAir(x, y + 1, z);
            } else {
                world.setBlockToAir(x, y - 1, z);
            }
        }
        if (te instanceof TileEntityFloodlight) {
            ((TileEntityFloodlight)te).updateFakeLights(true, false);
        }
        if (te instanceof TileEntityFluidPump) {
            if (((TileEntityFluidPump)te).dummy) {
                world.setBlockToAir(x, y - 1, z);
            } else {
                world.setBlockToAir(x, y + 1, z);
            }
        }
        if (te instanceof TileEntityFluidPipe && world.getGameRules().getGameRuleBooleanValue("doTileDrops") && ((TileEntityFluidPipe)te).scaffoldCovering != null) {
            EntityItem entityitem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, ((TileEntityFluidPipe)te).scaffoldCovering.copy());
            entityitem.delayBeforeCanPickup = 10;
            world.spawnEntityInWorld((Entity)entityitem);
        }
        if (te instanceof TileEntityBlastFurnacePreheater) {
            int startY = y - ((TileEntityBlastFurnacePreheater)te).dummy;
            for (int i = 0; i < 3; ++i) {
                if (!(world.getTileEntity(x, startY + i, z) instanceof TileEntityBlastFurnacePreheater)) continue;
                world.setBlockToAir(x, startY + i, z);
            }
        }
        if (te instanceof TileEntityChargingStation && (s = ((TileEntityChargingStation)te).inventory) != null) {
            float fx = (float)(world.rand.nextGaussian() * (double)0.8f + (double)0.1f);
            float fz = (float)(world.rand.nextGaussian() * (double)0.8f + (double)0.1f);
            EntityItem entityitem = new EntityItem(world, (double)((float)x + fx), (double)y + 0.5, (double)((float)z + fz), s);
            entityitem.motionX = world.rand.nextGaussian() * 0.05;
            entityitem.motionY = world.rand.nextGaussian() * 0.05 + 0.2;
            entityitem.motionZ = world.rand.nextGaussian() * 0.05;
            if (s.hasTagCompound()) {
                entityitem.getEntityItem().setTagCompound((NBTTagCompound)s.getTagCompound().copy());
            }
            world.spawnEntityInWorld((Entity)entityitem);
        }
        super.breakBlock(world, x, y, z, par5, par6);
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (!world.isRemote && te instanceof TileEntityWoodenBarrel) {
            ItemStack stack = new ItemStack((Block)this, 1, meta);
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenBarrel)te).writeTank(tag, true);
            if (!tag.hasNoTags()) {
                stack.setTagCompound(tag);
            }
            world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(x, y, z)) instanceof TileEntityWoodenBarrel) {
            ItemStack stack = new ItemStack((Block)this, 1, world.getBlockMetadata(x, y, z));
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenBarrel)te).writeTank(tag, true);
            if (!tag.hasNoTags()) {
                stack.setTagCompound(tag);
            }
            world.spawnEntityInWorld((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 7) {
            return ret;
        }
        int count = this.quantityDropped(metadata, fortune, world.rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.getItemDropped(metadata, world.rand, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.damageDropped(metadata)));
        }
        return ret;
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        if (world.getTileEntity(x, y, z) instanceof TileEntityFluidPipe && !world.isRemote) {
            TileEntityFluidPipe.indirectConnections.clear();
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity other;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileEntityFluidPipe && (other = world.getTileEntity(tileX, tileY, tileZ)) instanceof IFluidHandler) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                TileEntityFluidPipe.indirectConnections.clear();
            }
            ForgeDirection fd = tileY < y ? ForgeDirection.DOWN : (tileY > y ? ForgeDirection.UP : (tileZ < z ? ForgeDirection.NORTH : (tileZ > z ? ForgeDirection.SOUTH : (tileX < x ? ForgeDirection.WEST : ForgeDirection.EAST))));
            ((TileEntityFluidPipe)tile).sideConfig[fd.ordinal()] = 0;
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block neighbor) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (!world.isRemote && tile instanceof TileEntityRedstoneBreaker) {
            boolean RS = !world.isBlockIndirectlyGettingPowered(x, y, z);
            boolean b = ((TileEntityRedstoneBreaker)tile).active;
            ((TileEntityRedstoneBreaker)tile).active = RS;
            if (b != RS) {
                tile.markDirty();
                ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
            }
        }
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityWoodenBarrel) {
            TileEntityWoodenBarrel barrel = (TileEntityWoodenBarrel)te;
            return (int)(15.0f * ((float)barrel.tank.getFluidAmount() / (float)barrel.tank.getCapacity()));
        }
        if (te instanceof TileEntityChargingStation) {
            return ((TileEntityChargingStation)te).comparatorOutput;
        }
        if (te instanceof TileEntityEnergyMeter) {
            return ((TileEntityEnergyMeter)te).compVal;
        }
        return 0;
    }

    public int isProvidingWeakPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            TileEntityBreakerSwitch breaker = (TileEntityBreakerSwitch)te;
            boolean power = breaker.active && !breaker.inverted || !breaker.active && breaker.inverted;
            return power ? 15 : 0;
        }
        return 0;
    }

    public int isProvidingStrongPower(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityBreakerSwitch && !(te instanceof TileEntityRedstoneBreaker)) {
            TileEntityBreakerSwitch breaker = (TileEntityBreakerSwitch)te;
            int powerSide = breaker.sideAttached > 0 ? breaker.sideAttached - 1 : breaker.facing;
            boolean power = breaker.active && !breaker.inverted || !breaker.active && breaker.inverted;
            return power && ForgeDirection.OPPOSITES[side] == powerSide ? 15 : 0;
        }
        return 0;
    }

    public boolean canProvidePower() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            return super.canConnectRedstone(world, x, y, z, side);
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof TileEntityElectricLantern) {
            return ((TileEntityElectricLantern)te).active ? 15 : 0;
        }
        return 0;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean shouldRenderFluid(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return meta == 0 || meta == 3 || meta == 4 || meta == 5 || meta == 9;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.getBlockMetadata(x, y, z);
        return meta == 0 || meta == 3 || meta == 4 || meta == 5 || meta == 9;
    }
}

