/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorStructural;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class TileEntityBalloon
extends TileEntityConnectorStructural {
    public int style = 0;
    public byte colour0 = (byte)15;
    public byte colour1 = (byte)15;
    public ItemStack shader;

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.style = nbt.getInteger("style");
        this.colour0 = nbt.getByte("colour0");
        this.colour1 = nbt.getByte("colour1");
        this.shader = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbt.getCompoundTag("shader"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.setInteger("style", this.style);
        nbt.setByte("colour0", this.colour0);
        nbt.setByte("colour1", this.colour1);
        if (this.shader != null) {
            NBTTagCompound shaderTag = this.shader.writeToNBT(new NBTTagCompound());
            nbt.setTag("shader", (NBTBase)shaderTag);
        }
    }

    @Override
    public boolean receiveClientEvent(int id, int arg) {
        if (id == 0) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return super.receiveClientEvent(id, arg);
    }

    @Override
    public Vec3 getRaytraceOffset(IImmersiveConnectable link) {
        double dist;
        int xDif = ((TileEntity)link).xCoord - this.xCoord;
        int zDif = ((TileEntity)link).zCoord - this.zCoord;
        int yDif = ((TileEntity)link).yCoord - this.yCoord;
        if (yDif < 0 && (dist = Math.sqrt(xDif * xDif + zDif * zDif)) / (double)Math.abs(yDif) < 2.5) {
            return Vec3.createVectorHelper((double)0.5, (double)0.09375, (double)0.5);
        }
        if (Math.abs(zDif) > Math.abs(xDif)) {
            return Vec3.createVectorHelper((double)0.5, (double)0.09375, (double)(zDif > 0 ? 0.8125 : 0.1875));
        }
        return Vec3.createVectorHelper((double)(xDif > 0 ? 0.8125 : 0.1875), (double)0.09375, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double dist;
        int yDif;
        int zDif;
        int xDif;
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posX - this.xCoord : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posX - this.xCoord : 0));
        int n2 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posZ - this.zCoord : (zDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posZ - this.zCoord : 0));
        int n3 = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.posY - this.yCoord : (yDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.posY - this.yCoord : 0));
        if (yDif < 0 && (dist = Math.sqrt(xDif * xDif + zDif * zDif)) / (double)Math.abs(yDif) < 2.5) {
            return Vec3.createVectorHelper((double)0.5, (double)0.09375, (double)0.5);
        }
        if (Math.abs(zDif) > Math.abs(xDif)) {
            return Vec3.createVectorHelper((double)0.5, (double)0.09375, (double)(zDif > 0 ? 0.78125 : 0.21875));
        }
        return Vec3.createVectorHelper((double)(xDif > 0 ? 0.78125 : 0.21875), (double)0.09375, (double)0.5);
    }
}

