/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFloodlight;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFakeLight
extends BlockIEBase {
    public BlockFakeLight() {
        super("fakeLight", Material.air, 0, ItemBlockIEBase.class, new String[0]);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isAir(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB box, List list, Entity entity) {
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public boolean canCollideCheck(int meta, boolean b) {
        return false;
    }

    public boolean isCollidable() {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World par1World, int par2, int par3, int par4, Vec3 par5Vec3, Vec3 par6Vec3) {
        return null;
    }

    public int getMobilityFlag() {
        return 1;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        if (meta == 0) {
            return new TileEntityFakeLight();
        }
        return null;
    }

    @Override
    public boolean allowHammerHarvest(int metadata) {
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) == 0 ? 15 : 0;
    }

    public static class TileEntityFakeLight
    extends TileEntityIEBase
    implements IEBlockInterfaces.ISpawnInterdiction {
        public int[] floodlightCoords = new int[]{-1, -1, -1};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileEntityFakeLight() {
            if (Config.getBoolean("floodlight_spawnPrevent")) {
                ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
                synchronized (arrayList) {
                    if (!EventHandler.interdictionTiles.contains(this)) {
                        EventHandler.interdictionTiles.add(this);
                    }
                }
            }
        }

        public void updateEntity() {
            if (this.worldObj.getTotalWorldTime() % 256L == (long)((this.xCoord ^ this.zCoord) & 0xFF)) {
                if (this.floodlightCoords == null || this.floodlightCoords.length < 3) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                    return;
                }
                TileEntity tile = this.worldObj.getTileEntity(this.floodlightCoords[0], this.floodlightCoords[1], this.floodlightCoords[2]);
                if (!(tile instanceof TileEntityFloodlight) || !((TileEntityFloodlight)tile).active) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                    return;
                }
            }
        }

        @Override
        public double getInterdictionRangeSquared() {
            return 1024.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            ArrayList<IEBlockInterfaces.ISpawnInterdiction> arrayList = EventHandler.interdictionTiles;
            synchronized (arrayList) {
                if (EventHandler.interdictionTiles.contains(this)) {
                    EventHandler.interdictionTiles.remove(this);
                }
            }
            super.invalidate();
        }

        @Override
        public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
            this.floodlightCoords = nbt.getIntArray("floodlightCoords");
        }

        @Override
        public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
            nbt.setIntArray("floodlightCoords", this.floodlightCoords);
        }
    }
}

