/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class EntityRenderRailgunShot
extends Render {
    public void doRender(Entity entity, double x, double y, double z, float f0, float f1) {
        double yaw = entity.prevRotationYaw + (entity.rotationYaw - entity.prevRotationYaw) * f1 - 90.0f;
        double pitch = entity.prevRotationPitch + (entity.rotationPitch - entity.prevRotationPitch) * f1;
        ItemStack ammo = ((EntityRailgunShot)entity).getAmmo();
        int[][] colourMap = new int[][]{{0x777777, 0xA4A4A4}};
        if (ammo != null) {
            RailgunHandler.RailgunProjectileProperties prop = RailgunHandler.getProjectileProperties(ammo);
            colourMap = prop != null ? (Object)prop.colourMap : colourMap;
        }
        EntityRenderRailgunShot.renderRailgunProjectile(x, y, z, yaw, pitch, colourMap);
    }

    public static void renderRailgunProjectile(double x, double y, double z, double yaw, double pitch, int[][] colourMap) {
        int i;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)32826);
        Tessellator tes = ClientUtils.tes();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)2884);
        GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)pitch, (double)0.0, (double)0.0, (double)1.0);
        GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
        if (((int[][])colourMap).length == 1) {
            colourMap = new int[][]{colourMap[0], colourMap[0]};
        }
        float height = 0.1875f;
        float halfWidth = height / 2.0f;
        float length = 2.0f;
        int colWidth = colourMap[0].length;
        for (int i2 = 0; i2 < ((int[][])colourMap).length; ++i2) {
            colWidth = Math.min(colWidth, colourMap[i2].length);
        }
        int colLength = ((int[][])colourMap).length;
        float widthStep = height / (float)colWidth;
        float lengthStep = length / (float)colLength;
        GL11.glTranslatef((float)(-length * 0.85f), (float)0.0f, (float)0.0f);
        tes.startDrawingQuads();
        for (i = 0; i < colWidth; ++i) {
            tes.setNormal(-1.0f, 0.0f, 0.0f);
            tes.setColorOpaque_I(colourMap[0][i]);
            tes.addVertex(0.0, (double)height, (double)(-halfWidth + widthStep * (float)i));
            tes.addVertex(0.0, 0.0, (double)(-halfWidth + widthStep * (float)i));
            tes.addVertex(0.0, 0.0, (double)(-halfWidth + widthStep * (float)(i + 1)));
            tes.addVertex(0.0, (double)height, (double)(-halfWidth + widthStep * (float)(i + 1)));
            tes.setNormal(1.0f, 0.0f, 0.0f);
            tes.setColorOpaque_I(colourMap[colLength - 1][i]);
            tes.addVertex((double)length, 0.0, (double)(-halfWidth + widthStep * (float)i));
            tes.addVertex((double)length, (double)height, (double)(-halfWidth + widthStep * (float)i));
            tes.addVertex((double)length, (double)height, (double)(-halfWidth + widthStep * (float)(i + 1)));
            tes.addVertex((double)length, 0.0, (double)(-halfWidth + widthStep * (float)(i + 1)));
        }
        for (i = 0; i < colLength; ++i) {
            tes.setNormal(0.0f, 0.0f, -1.0f);
            tes.setColorOpaque_I(colourMap[i][0]);
            tes.addVertex((double)(lengthStep * (float)i), 0.0, (double)(-halfWidth));
            tes.addVertex((double)(lengthStep * (float)i), (double)height, (double)(-halfWidth));
            tes.addVertex((double)(lengthStep * (float)(i + 1)), (double)height, (double)(-halfWidth));
            tes.addVertex((double)(lengthStep * (float)(i + 1)), 0.0, (double)(-halfWidth));
            tes.setNormal(0.0f, 0.0f, 1.0f);
            tes.setColorOpaque_I(colourMap[i][colWidth - 1]);
            tes.addVertex((double)(lengthStep * (float)i), (double)height, (double)halfWidth);
            tes.addVertex((double)(lengthStep * (float)i), 0.0, (double)halfWidth);
            tes.addVertex((double)(lengthStep * (float)(i + 1)), 0.0, (double)halfWidth);
            tes.addVertex((double)(lengthStep * (float)(i + 1)), (double)height, (double)halfWidth);
        }
        for (i = 0; i < colLength; ++i) {
            for (int j = 0; j < colWidth; ++j) {
                tes.setNormal(0.0f, 1.0f, 0.0f);
                tes.setColorOpaque_I(colourMap[i][j]);
                tes.addVertex((double)(lengthStep * (float)(i + 1)), (double)height, (double)(-halfWidth + widthStep * (float)j));
                tes.addVertex((double)(lengthStep * (float)i), (double)height, (double)(-halfWidth + widthStep * (float)j));
                tes.addVertex((double)(lengthStep * (float)i), (double)height, (double)(-halfWidth + widthStep * (float)(j + 1)));
                tes.addVertex((double)(lengthStep * (float)(i + 1)), (double)height, (double)(-halfWidth + widthStep * (float)(j + 1)));
                tes.setNormal(0.0f, -1.0f, 0.0f);
                tes.addVertex((double)(lengthStep * (float)i), 0.0, (double)(-halfWidth + widthStep * (float)j));
                tes.addVertex((double)(lengthStep * (float)(i + 1)), 0.0, (double)(-halfWidth + widthStep * (float)j));
                tes.addVertex((double)(lengthStep * (float)(i + 1)), 0.0, (double)(-halfWidth + widthStep * (float)(j + 1)));
                tes.addVertex((double)(lengthStep * (float)i), 0.0, (double)(-halfWidth + widthStep * (float)(j + 1)));
            }
        }
        tes.draw();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(Entity p_110775_1_) {
        return new ResourceLocation("immersiveengineering:textures/models/bullet.png");
    }
}

