/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmillAdvanced;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenPost;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class BlockRenderWoodenDevices
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();
    private static final TileEntityWoodenPost woodenPost = new TileEntityWoodenPost();
    private static final TileEntityWatermill waterMill = new TileEntityWatermill();
    private static final TileEntityWindmill windMill = new TileEntityWindmill();
    private static final TileEntityWindmillAdvanced windMillAdv = new TileEntityWindmillAdvanced();
    private static final TileEntityModWorkbench workbench = new TileEntityModWorkbench();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glPushMatrix();
        try {
            if (metadata == 0) {
                GL11.glScalef((float)0.5f, (float)0.33f, (float)0.5f);
                GL11.glTranslatef((float)-0.5f, (float)-2.0f, (float)-0.5f);
                Tessellator.instance.startDrawingQuads();
                ClientUtils.handleStaticTileRenderer(woodenPost);
                Tessellator.instance.draw();
            } else if (metadata == 1) {
                GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
                TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)waterMill, 0.0, 0.0, 0.0, 0.0f);
            } else if (metadata == 2) {
                GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
                TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)windMill, 0.0, 0.0, 0.0, 0.0f);
            } else if (metadata == 3) {
                GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
                TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)windMillAdv, 0.0, 0.0, 0.0, 0.0f);
            } else if (metadata == 4) {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            } else if (metadata == 5) {
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                GL11.glTranslatef((float)-0.75f, (float)-0.5f, (float)-0.25f);
                Tessellator.instance.startDrawingQuads();
                ClientUtils.handleStaticTileRenderer(workbench);
                Tessellator.instance.draw();
            } else if (metadata == 6) {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glEnable((int)32826);
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (world.getBlockMetadata(x, y, z) == 0) {
            TileEntityWoodenPost tile = (TileEntityWoodenPost)world.getTileEntity(x, y, z);
            if (tile.type == 0) {
                ClientUtils.handleStaticTileRenderer(tile);
                return true;
            }
        } else {
            if (world.getBlockMetadata(x, y, z) == 4) {
                renderer.setRenderBoundsFromBlock(block);
                return renderer.renderStandardBlock(block, x, y, z);
            }
            if (world.getBlockMetadata(x, y, z) == 5) {
                TileEntityModWorkbench tile = (TileEntityModWorkbench)world.getTileEntity(x, y, z);
                if (!tile.dummy) {
                    ClientUtils.handleStaticTileRenderer(tile);
                    return true;
                }
            } else if (world.getBlockMetadata(x, y, z) == 6) {
                renderer.setRenderBoundsFromBlock(block);
                return renderer.renderStandardBlock(block, x, y, z);
            }
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }

    static {
        BlockRenderWoodenDevices.workbench.facing = 3;
    }
}

