/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.MetalPressRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityMetalPress;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class NEIMetalPressHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(66, 21, 32, 28), "ieMetalPress", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (MetalPressRecipe r : MetalPressRecipe.recipeList.values()) {
                if (r == null) continue;
                this.arecipes.add(new CachedMetalPressRecipe(r));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.ImmersiveEngineering.metalMultiblock.metalPress.name");
    }

    public String getGuiTexture() {
        return "textures/gui/container/furnace.png";
    }

    public String getOverlayIdentifier() {
        return "ieMetalPress";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (MetalPressRecipe r : MetalPressRecipe.recipeList.values()) {
                if (r == null || !Utils.stackMatchesObject(result, r.output)) continue;
                this.arecipes.add(new CachedMetalPressRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null) {
            for (MetalPressRecipe r : MetalPressRecipe.recipeList.values()) {
                if (r == null || !Utils.stackMatchesObject(ingredient, r.input) && !r.mold.equals(ApiUtils.createComparableItemStack(ingredient))) continue;
                this.arecipes.add(new CachedMetalPressRecipe(r));
            }
        }
    }

    public void drawBackground(int recipe) {
        CachedMetalPressRecipe r = (CachedMetalPressRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            try {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)32.0f, (float)25.0f, (float)100.0f);
                GL11.glRotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-120.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)12.0f, (float)-12.0f, (float)12.0f);
                TileEntityMetalPress tile = new TileEntityMetalPress();
                tile.pos = 4;
                tile.formed = true;
                ClientUtils.bindAtlas(0);
                ClientUtils.tes().startDrawingQuads();
                ClientUtils.handleStaticTileRenderer(tile, false);
                ClientUtils.tes().draw();
                TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)tile, 0.0, 0.0, 0.0, 0.0f);
                GL11.glPopMatrix();
                ClientUtils.drawSlot(r.input.relx, r.input.rely, 16, 16);
                ClientUtils.drawSlot(r.mould.relx, r.mould.rely, 16, 16);
                ClientUtils.drawSlot(r.output.relx, r.output.rely, 20, 20);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class CachedMetalPressRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack mould;
        PositionedStack output;
        public int energy;

        public CachedMetalPressRecipe(MetalPressRecipe recipe) {
            super((TemplateRecipeHandler)NEIMetalPressHandler.this);
            ArrayList in = recipe.input;
            if (in instanceof String) {
                in = OreDictionary.getOres((String)((String)((Object)in)));
            }
            if (in instanceof List) {
                in = new ArrayList(in);
                for (ItemStack s : in) {
                    s.stackSize = recipe.inputSize;
                }
            }
            this.input = new PositionedStack(in, 44, 9);
            this.mould = new PositionedStack((Object)(recipe.mold.oreID != -1 ? OreDictionary.getOres((String)OreDictionary.getOreName((int)recipe.mold.oreID)) : recipe.mold.stack), 75, 9);
            this.output = new PositionedStack((Object)recipe.output, 107, 9);
            this.energy = recipe.energy;
        }

        public PositionedStack getOtherStack() {
            return this.mould;
        }

        public List<PositionedStack> getIngredients() {
            this.input.setPermutationToRender(NEIMetalPressHandler.this.cycleticks / 20 % this.input.items.length);
            return Arrays.asList(this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

