/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityBottlingMachine;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEIBottlingMachineHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(64, 8, 38, 36), "ieBottlingMachine", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (BottlingMachineRecipe r : BottlingMachineRecipe.recipeList) {
                if (r == null) continue;
                this.arecipes.add(new CachedBottlingMachineRecipe(r));
            }
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        FluidStack fs = null;
        if (inputId == "liquid" && ingredients != null && ingredients.length > 0 && ingredients[0] instanceof FluidStack) {
            fs = (FluidStack)ingredients[0];
        }
        if (inputId == "item" && ingredients != null && ingredients.length > 0 && ingredients[0] instanceof ItemStack && FluidContainerRegistry.isFilledContainer((ItemStack)((ItemStack)ingredients[0]))) {
            fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)ingredients[0]));
        }
        if (fs != null) {
            for (BottlingMachineRecipe r : BottlingMachineRecipe.recipeList) {
                if (r == null || !r.fluidInput.isFluidEqual(fs)) continue;
                this.arecipes.add(new CachedBottlingMachineRecipe(r));
            }
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.ImmersiveEngineering.metalMultiblock.bottlingMachine.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/fluidProducer.png";
    }

    public String getOverlayIdentifier() {
        return "ieBottlingMachine";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (BottlingMachineRecipe r : BottlingMachineRecipe.recipeList) {
                if (r == null || !Utils.stackMatchesObject(result, r.output)) continue;
                this.arecipes.add(new CachedBottlingMachineRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null) {
            for (BottlingMachineRecipe r : BottlingMachineRecipe.recipeList) {
                if (r == null || !Utils.stackMatchesObject(ingredient, r.input)) continue;
                this.arecipes.add(new CachedBottlingMachineRecipe(r));
            }
        }
    }

    public void drawBackground(int recipe) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CachedBottlingMachineRecipe r = (CachedBottlingMachineRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            ClientUtils.drawSlot(r.input.relx, r.input.rely, 16, 16);
            ClientUtils.drawSlot(r.output.relx, r.output.rely, 20, 20);
            ClientUtils.drawSlot(16, 22, 18, 50);
            int timer = 30;
            int step = this.cycleticks % (timer * 7) / timer;
            int fluidHeight = 50 - step * 7 - (step > 0 ? 1 : 0);
            ClientUtils.drawRepeatedFluidIcon(r.fluid.getFluid(), 15.0f, 55 - fluidHeight, 18.0f, fluidHeight);
            GuiDraw.changeTexture((String)this.getGuiTexture());
            GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            GuiDraw.drawTexturedModalRect((int)15, (int)7, (int)179, (int)33, (int)16, (int)47);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)"textures/gui/container/furnace.png");
            GuiDraw.drawTexturedModalRect((int)74, (int)8, (int)82, (int)35, (int)20, (int)16);
            GuiDraw.drawTexturedModalRect((int)74, (int)8, (int)179, (int)14, (int)((int)((float)(this.cycleticks % timer) / (float)timer * 20.0f)), (int)16);
            GL11.glTranslatef((float)89.0f, (float)50.0f, (float)100.0f);
            GL11.glRotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)12.0f, (float)-12.0f, (float)12.0f);
            TileEntityBottlingMachine tile = new TileEntityBottlingMachine();
            tile.pos = 4;
            tile.formed = true;
            ClientUtils.bindAtlas(0);
            ClientUtils.tes().startDrawingQuads();
            ClientUtils.handleStaticTileRenderer(tile, false);
            ClientUtils.tes().draw();
            TileEntityRendererDispatcher.instance.renderTileEntityAt((TileEntity)tile, 0.0, 0.0, 0.0, 0.0f);
        }
        GL11.glPopMatrix();
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (gui.width - 176) / 2 - offset.x, mouse.y - (gui.height - 166) / 2 - offset.y);
        CachedBottlingMachineRecipe r = (CachedBottlingMachineRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null && new Rectangle(15, 5, 18, 50).contains(relMouse) && (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe") ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}) : keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage") && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}))) {
            return true;
        }
        return super.keyTyped(gui, keyChar, keyCode, recipe);
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (gui.width - 176) / 2 - offset.x, mouse.y - (gui.height - 166) / 2 - offset.y);
        CachedBottlingMachineRecipe r = (CachedBottlingMachineRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null && new Rectangle(15, 5, 18, 50).contains(relMouse) && (button == 0 ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}) : button == 1 && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{r.fluid}))) {
            return true;
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        Point mouse = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(mouse.x - (gui.width - 176) / 2 - offset.x, mouse.y - (gui.height - 166) / 2 - offset.y);
        CachedBottlingMachineRecipe r = (CachedBottlingMachineRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null && r.fluid != null && new Rectangle(15, 5, 18, 50).contains(relMouse)) {
            currenttip.add(r.fluid.getLocalizedName());
            currenttip.add(EnumChatFormatting.GRAY.toString() + r.fluid.amount + " mB");
        }
        return currenttip;
    }

    public class CachedBottlingMachineRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        FluidStack fluid;

        public CachedBottlingMachineRecipe(BottlingMachineRecipe recipe) {
            super((TemplateRecipeHandler)NEIBottlingMachineHandler.this);
            Object in = recipe.input;
            this.input = new PositionedStack(in, 46, 8);
            this.output = new PositionedStack((Object)recipe.output, 105, 8);
            this.fluid = recipe.fluidInput;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIBottlingMachineHandler.this.cycleticks / 20, Arrays.asList(this.input));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

