/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class NEIBlueprintHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(4, 24, 44, 32), "ieBlueprintCrafting", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (int s = 0; s < BlueprintCraftingRecipe.blueprintCategories.size(); ++s) {
                for (BlueprintCraftingRecipe r : BlueprintCraftingRecipe.recipeList.get((Object)BlueprintCraftingRecipe.blueprintCategories.get(s))) {
                    this.arecipes.add(new CachedBlueprintCraftingRecipe(s, r));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.ImmersiveEngineering.woodenDevice.modificationWorkbench.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/workbench.png";
    }

    public String getOverlayIdentifier() {
        return "ieBlueprintCrafting";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (int s = 0; s < BlueprintCraftingRecipe.blueprintCategories.size(); ++s) {
                for (BlueprintCraftingRecipe r : BlueprintCraftingRecipe.recipeList.get((Object)BlueprintCraftingRecipe.blueprintCategories.get(s))) {
                    if (r == null || !Utils.stackMatchesObject(result, r.output)) continue;
                    this.arecipes.add(new CachedBlueprintCraftingRecipe(s, r));
                }
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block6: {
            if (ingredient == null) break block6;
            if (((Object)((Object)IEContent.itemBlueprint)).equals(ingredient.getItem())) {
                for (BlueprintCraftingRecipe r : BlueprintCraftingRecipe.recipeList.get((Object)BlueprintCraftingRecipe.blueprintCategories.get(ingredient.getItemDamage()))) {
                    this.arecipes.add(new CachedBlueprintCraftingRecipe(ingredient.getItemDamage(), r));
                }
            } else {
                for (int s = 0; s < BlueprintCraftingRecipe.blueprintCategories.size(); ++s) {
                    block2: for (BlueprintCraftingRecipe r : BlueprintCraftingRecipe.recipeList.get((Object)BlueprintCraftingRecipe.blueprintCategories.get(s))) {
                        if (r == null) continue;
                        for (Object o : r.inputs) {
                            if (!Utils.stackMatchesObject(ingredient, o)) continue;
                            this.arecipes.add(new CachedBlueprintCraftingRecipe(s, r));
                            continue block2;
                        }
                    }
                }
            }
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)63);
        CachedBlueprintCraftingRecipe r = (CachedBlueprintCraftingRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            ClientUtils.drawSlot(19, 11, 16, 16, 51);
            ClientUtils.drawSlot(75, 10, 16, 16, 51);
            ClientUtils.drawSlot(93, 10, 16, 16, 51);
            ClientUtils.drawSlot(75, 28, 16, 16, 51);
            ClientUtils.drawSlot(93, 28, 16, 16, 51);
            ClientUtils.drawSlot(75, 46, 16, 16, 51);
            ClientUtils.drawSlot(93, 46, 16, 16, 51);
            ClientUtils.drawSlot(128, 28, 16, 16, 51);
        }
    }

    public class CachedBlueprintCraftingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack blueprint;
        PositionedStack[] inputs;
        PositionedStack output;

        public CachedBlueprintCraftingRecipe(int blueprintMeta, BlueprintCraftingRecipe recipe) {
            super((TemplateRecipeHandler)NEIBlueprintHandler.this);
            this.blueprint = new PositionedStack((Object)new ItemStack((Item)IEContent.itemBlueprint, 1, blueprintMeta), 19, 11);
            ArrayList<Object> formattedInputs = recipe.getFormattedInputs();
            this.inputs = new PositionedStack[formattedInputs.size()];
            for (int i = 0; i < this.inputs.length; ++i) {
                if (recipe.inputs[i] == null) continue;
                this.inputs[i] = new PositionedStack(formattedInputs.get(i), 75 + i % 2 * 18, 10 + i / 2 * 18);
            }
            this.output = new PositionedStack((Object)recipe.output, 128, 28);
        }

        public PositionedStack getOtherStack() {
            return this.blueprint;
        }

        public List<PositionedStack> getIngredients() {
            if (this.inputs.length < 1) {
                return new ArrayList<PositionedStack>();
            }
            return this.getCycledIngredients(NEIBlueprintHandler.this.cycleticks / 20, Arrays.asList(this.inputs));
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

