/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.GuiArcFurnace;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class NEIArcFurnaceHandler
extends TemplateRecipeHandler {
    public String specialRecipeType;

    public NEIArcFurnaceHandler() {
        String name = ((Object)((Object)this)).getClass().getName();
        int idx = name.indexOf("NEIArcFurnaceHandler");
        if (idx >= 0 && idx + "NEIArcFurnaceHandler".length() < name.length()) {
            this.specialRecipeType = name.substring(idx + "NEIArcFurnaceHandler".length());
        }
    }

    public static NEIArcFurnaceHandler createSubHandler(String subtype) {
        try {
            String entitySuperClassName = Type.getInternalName(NEIArcFurnaceHandler.class);
            String entityProxySubClassName = NEIArcFurnaceHandler.class.getSimpleName().concat(subtype);
            ClassWriter cw = new ClassWriter(1);
            cw.visit(50, 33, entityProxySubClassName, null, entitySuperClassName, null);
            cw.visitSource(entityProxySubClassName.concat(".java"), null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, entitySuperClassName, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
            cw.visitEnd();
            Class<?> c = new ProxyClassLoader(Thread.currentThread().getContextClassLoader(), cw.toByteArray()).loadClass(entityProxySubClassName.replaceAll("/", "."));
            return (NEIArcFurnaceHandler)((Object)c.newInstance());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiArcFurnace.class;
    }

    NEIArcFurnaceHandler setSpecialType(String type) {
        this.specialRecipeType = type;
        return this;
    }

    boolean specialTypeCompare(ArcFurnaceRecipe r) {
        if ((this.specialRecipeType == null || this.specialRecipeType.isEmpty()) && (r.specialRecipeType == null || r.specialRecipeType.isEmpty())) {
            return true;
        }
        return this.specialRecipeType != null && r.specialRecipeType != null && this.specialRecipeType.equalsIgnoreCase(r.specialRecipeType);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 26, 32, 40), "ieArcFurnace", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (this.getOverlayIdentifier().startsWith(outputId)) {
            for (ArcFurnaceRecipe r : ArcFurnaceRecipe.recipeList) {
                if (r == null || r.input == null || !this.specialTypeCompare(r)) continue;
                this.arecipes.add(new CachedArcFurnaceRecipe(r));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.ImmersiveEngineering.metalMultiblock.arcFurnace.name") + (this.specialRecipeType != null && !this.specialRecipeType.isEmpty() ? ": " + this.specialRecipeType : "");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/arcFurnace.png";
    }

    public String getOverlayIdentifier() {
        return "ieArcFurnace";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (ArcFurnaceRecipe r : ArcFurnaceRecipe.recipeList) {
                if (r == null || r.input == null || !Utils.stackMatchesObject(result, r.output) && (r.slag == null || !Utils.stackMatchesObject(result, r.slag)) || !this.specialTypeCompare(r)) continue;
                this.arecipes.add(new CachedArcFurnaceRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (ingredient != null) {
            for (ArcFurnaceRecipe r : ArcFurnaceRecipe.recipeList) {
                if (r == null || r.input == null || !this.specialTypeCompare(r)) continue;
                if (Utils.stackMatchesObject(ingredient, r.input)) {
                    this.arecipes.add(new CachedArcFurnaceRecipe(r));
                    continue;
                }
                for (Object o : r.additives) {
                    if (!Utils.stackMatchesObject(ingredient, o)) continue;
                    this.arecipes.add(new CachedArcFurnaceRecipe(r));
                }
            }
        }
    }

    public void drawBackground(int recipe) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CachedArcFurnaceRecipe r = (CachedArcFurnaceRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            ClientUtils.drawSlot(28, 0, 16, 16);
            for (int i = 0; i < 4; ++i) {
                ClientUtils.drawSlot(20 + i % 2 * 18, 24 + i / 2 * 18, 16, 16);
            }
            if (r.output != null) {
                for (PositionedStack ps : r.output) {
                    ClientUtils.drawSlot(ps.relx, ps.rely, 16, 16);
                }
            }
            if (r.slag != null) {
                ClientUtils.drawSlot(r.slag.relx, r.slag.rely, 16, 16);
            }
            String s = r.energy + " RF/t";
            ClientUtils.font().drawString(s, 88 - ClientUtils.font().getStringWidth(s) / 2, 32, 0x777777, false);
            s = r.time + " ticks";
            ClientUtils.font().drawString(s, 84 - ClientUtils.font().getStringWidth(s) / 2, 44, 0x777777, false);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)"textures/gui/container/furnace.png");
            GuiDraw.drawTexturedModalRect((int)72, (int)16, (int)80, (int)35, (int)22, (int)16);
            int w = this.cycleticks / 2 % 22;
            GuiDraw.drawTexturedModalRect((int)72, (int)16, (int)177, (int)14, (int)w, (int)16);
        }
        GL11.glPopMatrix();
    }

    public class CachedArcFurnaceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] inputs;
        PositionedStack[] output;
        PositionedStack slag;
        public int time;
        public int energy;

        public CachedArcFurnaceRecipe(ArcFurnaceRecipe recipe) {
            super((TemplateRecipeHandler)NEIArcFurnaceHandler.this);
            ArrayList<PositionedStack> lInputs = new ArrayList<PositionedStack>();
            ItemStack[] stackAdditives = new ItemStack[recipe.additives.length];
            if (recipe.input != null) {
                lInputs.add(new PositionedStack(recipe.input, 28, 0));
            }
            for (int i = 0; i < recipe.additives.length; ++i) {
                if (recipe.additives[i] == null) continue;
                lInputs.add(new PositionedStack(recipe.additives[i], 20 + i % 2 * 18, 24 + i / 2 * 18));
                stackAdditives[i] = ApiUtils.getItemStackFromObject(recipe.additives[i]);
            }
            this.inputs = lInputs.toArray(new PositionedStack[lInputs.size()]);
            ItemStack[] outs = recipe.getOutputs(ApiUtils.getItemStackFromObject(recipe.input), stackAdditives);
            if (outs != null && outs.length > 0) {
                this.output = new PositionedStack[outs.length];
                int l = this.output.length;
                for (int i = 0; i < l; ++i) {
                    this.output[i] = new PositionedStack((Object)outs[i], 122 + i % 2 * 18, (i > 2 ? 0 : 16) + i / 2 * 18);
                }
            } else if (recipe.output != null) {
                this.output = new PositionedStack[]{new PositionedStack((Object)recipe.output, 122, 16)};
            }
            if (recipe.slag != null) {
                this.slag = new PositionedStack((Object)recipe.slag, 122, 36);
            }
            this.time = recipe.time;
            this.energy = recipe.energyPerTick;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> l = new ArrayList<PositionedStack>();
            if (this.slag != null) {
                l.add(this.slag);
            }
            if (this.output != null) {
                for (int i = 1; i < this.output.length; ++i) {
                    l.add(this.output[i]);
                }
            }
            return l;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIArcFurnaceHandler.this.cycleticks / 20, Arrays.asList(this.inputs));
        }

        public PositionedStack getResult() {
            return this.output != null ? this.output[0] : null;
        }
    }

    public static class ProxyClassLoader
    extends ClassLoader {
        private byte[] rawClassBytes;

        public ProxyClassLoader(ClassLoader parentClassLoader, byte[] classBytes) {
            super(parentClassLoader);
            this.rawClassBytes = classBytes;
        }

        public Class findClass(String name) {
            return this.defineClass(name, this.rawClassBytes, 0, this.rawClassBytes.length);
        }
    }
}

